/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.containers.BidirectionalMap;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00062\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0006J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0006J&\u0010!\u001a\u00020\u00122\u001e\u0010\"\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070$\u0012\u0004\u0012\u00020\u00120#J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "", "<init>", "()V", "scriptUrlToSourceMap", "Ljava/util/HashMap;", "Lcom/intellij/util/Url;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "Lkotlin/collections/HashMap;", "generatedFileToSourceMap", "Ljava/nio/file/Path;", "sourceMapUrlToSourceMap", "Lcom/intellij/util/containers/BidirectionalMap;", "scriptUrlToRelativePath", "", "getScriptUrlToRelativePath", "()Ljava/util/HashMap;", "add", "", "mapUrl", "map", "scriptUrl", "relativePath", "generatedFile", "get", "url", "getByScript", "getBySourceFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "containsMap", "", "containsScript", "process", "procedure", "Lkotlin/Function1;", "", "getAllMaps", "", "removeHash", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nPreloadedSourceMapList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreloadedSourceMapList.kt\ncom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,64:1\n221#2,2:65\n1088#3,2:67\n*S KotlinDebug\n*F\n+ 1 PreloadedSourceMapList.kt\ncom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList\n*L\n51#1:65,2\n59#1:67,2\n*E\n"})
public final class PreloadedSourceMapList {
    @NotNull
    private final HashMap<Url, SourceMap> scriptUrlToSourceMap = new HashMap();
    @NotNull
    private final HashMap<Path, SourceMap> generatedFileToSourceMap = new HashMap();
    @NotNull
    private final BidirectionalMap<Url, SourceMap> sourceMapUrlToSourceMap = new BidirectionalMap();
    @NotNull
    private final HashMap<Url, String> scriptUrlToRelativePath = new HashMap();

    @NotNull
    public final HashMap<Url, String> getScriptUrlToRelativePath() {
        return this.scriptUrlToRelativePath;
    }

    public final synchronized void add(@NotNull Url mapUrl, @NotNull SourceMap map, @NotNull Url scriptUrl, @Nullable String relativePath, @Nullable Path generatedFile) {
        Intrinsics.checkNotNullParameter((Object)mapUrl, (String)"mapUrl");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        Url mapUrlWithoutHash = this.removeHash(mapUrl);
        Url scriptUrlWithoutHash = this.removeHash(scriptUrl);
        ((Map)this.sourceMapUrlToSourceMap).put(mapUrlWithoutHash, map);
        ((Map)this.scriptUrlToSourceMap).put(scriptUrlWithoutHash, map);
        if (relativePath != null) {
            ((Map)this.scriptUrlToRelativePath).put(scriptUrlWithoutHash, relativePath);
        }
        if (generatedFile != null) {
            ((Map)this.generatedFileToSourceMap).put(generatedFile, map);
        }
    }

    public static /* synthetic */ void add$default(PreloadedSourceMapList preloadedSourceMapList, Url url, SourceMap sourceMap, Url url2, String string, Path path, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            path = null;
        }
        preloadedSourceMapList.add(url, sourceMap, url2, string, path);
    }

    @Nullable
    public final synchronized SourceMap get(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (SourceMap)this.sourceMapUrlToSourceMap.get((Object)this.removeHash(url));
    }

    @Nullable
    public final synchronized SourceMap getByScript(@NotNull Url scriptUrl) {
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        return this.scriptUrlToSourceMap.get(this.removeHash(scriptUrl));
    }

    @Nullable
    public final synchronized SourceMap getBySourceFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.generatedFileToSourceMap.get(VfsUtilCore.virtualToIoFile((VirtualFile)file).toPath());
    }

    public final synchronized boolean containsMap(@NotNull SourceMap map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        return this.sourceMapUrlToSourceMap.containsValue((Object)map);
    }

    public final synchronized boolean containsScript(@NotNull Url scriptUrl) {
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        return this.scriptUrlToSourceMap.containsKey(this.removeHash(scriptUrl));
    }

    public final synchronized void process(@NotNull Function1<? super Map.Entry<? extends Url, ? extends SourceMap>, Unit> procedure) {
        Intrinsics.checkNotNullParameter(procedure, (String)"procedure");
        Map $this$forEach$iv = this.scriptUrlToSourceMap;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            procedure.invoke(element$iv);
        }
    }

    @NotNull
    public final synchronized Collection<SourceMap> getAllMaps() {
        Collection<SourceMap> collection = this.scriptUrlToSourceMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    private final Url removeHash(Url url) {
        Url url2 = url.removeParameter("hash");
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"removeParameter(...)");
        Url resultUrl = url2;
        String parameters = resultUrl.getParameters();
        if (parameters != null && parameters.length() > 8 && parameters.charAt(0) == '?') {
            boolean bl;
            block3: {
                String string = parameters.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                CharSequence $this$all$iv = string;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char p0 = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (StringUtil.isHexDigit((char)p0)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (bl) {
                Url url3 = resultUrl.trimParameters();
                Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"trimParameters(...)");
                return url3;
            }
        }
        return resultUrl;
    }
}

