/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import com.jetbrains.rd.platform.codeWithMe.blockmap.BlockMap;
import com.jetbrains.rd.platform.codeWithMe.blockmap.Chunk;
import com.jetbrains.rd.platform.codeWithMe.blockmap.ChunkInfo;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DirBlockMap;
import com.jetbrains.rd.platform.codeWithMe.blockmap.FileHash;
import com.jetbrains.rd.platform.codeWithMe.blockmap.FileInfo;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0007\u00a8\u0006\f"}, d2={"createDirBlockMap", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DirBlockMap;", "path", "", "algorithm", "minSize", "", "maxSize", "normalSize", "getPathFromRoot", "rootPath", "absolutePath", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nDirBlockMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirBlockMap.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/DirBlockMapKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1342#2:77\n1343#2:80\n1915#3,2:78\n*S KotlinDebug\n*F\n+ 1 DirBlockMap.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/DirBlockMapKt\n*L\n42#1:77\n42#1:80\n55#1:78,2\n*E\n"})
public final class DirBlockMapKt {
    @NotNull
    public static final DirBlockMap createDirBlockMap(@NotNull String path, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        return DirBlockMapKt.createDirBlockMap(path, algorithm, 512, 16384, 2048);
    }

    public static /* synthetic */ DirBlockMap createDirBlockMap$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "SHA-256";
        }
        return DirBlockMapKt.createDirBlockMap(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DirBlockMap createDirBlockMap(@NotNull String path, @NotNull String algorithm, int minSize, int maxSize, int normalSize) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        List fileInfos = new ArrayList();
        List chunks = new ArrayList();
        Sequence $this$forEach$iv = (Sequence)FilesKt.walkTopDown((File)new File(path));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object it;
            Object it2;
            File child = (File)element$iv;
            boolean bl = false;
            if (!child.isFile()) continue;
            String string = child.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            String name = DirBlockMapKt.getPathFromRoot(path, string);
            File file = new File(child.getAbsolutePath());
            Closeable closeable = new FileInputStream(file);
            Object object = null;
            try {
                it2 = (FileInputStream)closeable;
                boolean bl2 = false;
                it2 = new BlockMap((InputStream)it2, algorithm, minSize, maxSize, normalSize);
            }
            catch (Throwable bl2) {
                object = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            Object blockMap = it2;
            object = new FileInputStream(file);
            it2 = null;
            try {
                it = (FileInputStream)object;
                boolean bl3 = false;
                it = new FileHash((InputStream)it, ((BlockMap)blockMap).getAlgorithm()).getHash();
            }
            catch (Throwable bl3) {
                it2 = bl3;
                throw bl3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)it2);
            }
            Object fileHash = it;
            FileInfo fileInfo = new FileInfo(name, chunks.size(), chunks.size() + ((BlockMap)blockMap).getChunks().size(), (String)fileHash, file.length(), child.canExecute());
            int fileIdx = fileInfos.size();
            fileInfos.add(fileInfo);
            Iterable $this$forEach$iv2 = ((BlockMap)blockMap).getChunks();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Chunk chunk = (Chunk)element$iv2;
                boolean bl4 = false;
                chunks.add(new ChunkInfo(chunk, fileIdx));
            }
        }
        return new DirBlockMap(fileInfos, chunks, algorithm, minSize, maxSize, normalSize);
    }

    @ApiStatus.Internal
    @NotNull
    public static final String getPathFromRoot(@NotNull String rootPath, @NotNull String absolutePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        String[] stringArray = new String[]{rootPath};
        List tokens = StringsKt.split$default((CharSequence)absolutePath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (tokens.size() != 2) {
            throw new RuntimeException("Failed to get relative path. Root: '" + rootPath + "', absolutePath: '" + absolutePath + "'");
        }
        if (StringsKt.startsWith$default((CharSequence)((CharSequence)tokens.get(1)), (char)File.separatorChar, (boolean)false, (int)2, null)) {
            String string2 = ((String)tokens.get(1)).substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = (String)tokens.get(1);
        }
        return string;
    }
}

