/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\tJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/FileHash;", "", "hash", "", "algorithm", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "source", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getAlgorithm", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.split"})
public final class FileHash {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String hash;
    @NotNull
    private final String algorithm;

    public FileHash(@NotNull String hash, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.hash = hash;
        this.algorithm = algorithm;
    }

    public /* synthetic */ FileHash(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    @NotNull
    public final String getHash() {
        return this.hash;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public FileHash(@NotNull InputStream source, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this(Companion.makeFileHash(source, algorithm), algorithm);
    }

    public /* synthetic */ FileHash(InputStream inputStream, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "SHA-256";
        }
        this(inputStream, string);
    }

    @NotNull
    public final String component1() {
        return this.hash;
    }

    @NotNull
    public final String component2() {
        return this.algorithm;
    }

    @NotNull
    public final FileHash copy(@NotNull String hash, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        return new FileHash(hash, algorithm);
    }

    public static /* synthetic */ FileHash copy$default(FileHash fileHash, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = fileHash.hash;
        }
        if ((n & 2) != 0) {
            string2 = fileHash.algorithm;
        }
        return fileHash.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "FileHash(hash=" + this.hash + ", algorithm=" + this.algorithm + ")";
    }

    public int hashCode() {
        int result2 = this.hash.hashCode();
        result2 = result2 * 31 + this.algorithm.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileHash)) {
            return false;
        }
        FileHash fileHash = (FileHash)other;
        if (!Intrinsics.areEqual((Object)this.hash, (Object)fileHash.hash)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.algorithm, (Object)fileHash.algorithm);
    }

    public FileHash() {
        this((String)null, (String)null, 3, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/FileHash$Companion;", "", "<init>", "()V", "makeFileHash", "", "source", "Ljava/io/InputStream;", "algorithm", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String makeFileHash(@NotNull InputStream source, @NotNull String algorithm) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            Closeable closeable = source;
            int n = 8192;
            closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
            Throwable throwable = null;
            try {
                BufferedInputStream input = (BufferedInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new DigestInputStream(input, digest);
                Throwable throwable2 = null;
                try {
                    DigestInputStream digestInputStream = (DigestInputStream)closeable2;
                    boolean bl2 = false;
                    byte[] buffer = new byte[8192];
                    while (digestInputStream.read(buffer) != -1) {
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = Base64.getEncoder().encodeToString(digest.digest());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

