/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap.misc;

import com.jetbrains.rd.platform.codeWithMe.blockmap.misc.FileCacheItem;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B!\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/misc/FileCache;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "queue", "Ljava/util/LinkedList;", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/misc/FileCacheItem;", "FILE_CACHE_SIZE", "", "<init>", "(Ljava/util/LinkedList;I)V", "getRAF", "Ljava/io/RandomAccessFile;", "fileName", "", "readBytes", "", "offset", "length", "readWholeFile", "close", "", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileCache.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/misc/FileCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class FileCache
implements AutoCloseable {
    @NotNull
    private final LinkedList<FileCacheItem> queue;
    private final int FILE_CACHE_SIZE;

    public FileCache(@NotNull LinkedList<FileCacheItem> queue, int FILE_CACHE_SIZE) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        this.queue = queue;
        this.FILE_CACHE_SIZE = FILE_CACHE_SIZE;
    }

    public /* synthetic */ FileCache(LinkedList linkedList, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            linkedList = new LinkedList<FileCacheItem>();
        }
        if ((n2 & 2) != 0) {
            n = 2;
        }
        this(linkedList, n);
    }

    private final RandomAccessFile getRAF(String fileName) {
        int n = this.queue.size();
        for (int idx = 0; idx < n; ++idx) {
            if (!Intrinsics.areEqual((Object)this.queue.get(idx).getFileName(), (Object)fileName)) continue;
            if (idx != 0) {
                FileCacheItem fileCacheItem;
                FileCacheItem fileCacheItem2 = fileCacheItem = this.queue.get(0);
                int n2 = idx;
                LinkedList<FileCacheItem> linkedList = this.queue;
                boolean bl = false;
                this.queue.set(0, this.queue.get(idx));
                Unit unit = Unit.INSTANCE;
                linkedList.set(n2, fileCacheItem);
            }
            return this.queue.get(0).getRaf();
        }
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        this.queue.addFirst(new FileCacheItem(fileName, raf));
        if (this.queue.size() > this.FILE_CACHE_SIZE) {
            FileCacheItem fileCacheItem = this.queue.removeLast();
            Intrinsics.checkNotNullExpressionValue((Object)fileCacheItem, (String)"removeLast(...)");
            FileCacheItem nameAndRAF = fileCacheItem;
            nameAndRAF.getRaf().close();
        }
        return raf;
    }

    @NotNull
    public final synchronized byte[] readBytes(@NotNull String fileName, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        RandomAccessFile raf = this.getRAF(fileName);
        raf.seek(offset);
        byte[] b = new byte[length];
        raf.read(b);
        return b;
    }

    @NotNull
    public final synchronized byte[] readWholeFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        RandomAccessFile raf = this.getRAF(fileName);
        byte[] b = new byte[(int)raf.length()];
        raf.read(b);
        return b;
    }

    @Override
    public void close() {
        Iterator iterator = this.queue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        if (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            FileCacheItem item = (FileCacheItem)e;
            item.getRaf().close();
            return;
        }
    }

    public FileCache() {
        this(null, 0, 3, null);
    }
}

