/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\rJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0005J \u0010\u001b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\n\u0010\u001f\u001a\u00020 H\u0096\u0080\u0004R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/intellij/ui/awt/DevicePoint;", "", "locationOnScreen", "Ljava/awt/Point;", "sourceComponent", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Point;Ljava/awt/Component;)V", "event", "Ljava/awt/event/MouseEvent;", "(Ljava/awt/event/MouseEvent;)V", "relativePoint", "Lcom/intellij/ui/awt/RelativePoint;", "(Lcom/intellij/ui/awt/RelativePoint;)V", "point", "getPoint", "()Ljava/awt/Point;", "getLocationOnScreen", "destinationComponent", "destinationGraphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "getLocationOnScreenFromPoint", "destinationPoint", "requiresScaling", "", "toRelativePoint", "component", "scale", "screenOrigin", "factor", "", "toString", "", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nDevicePoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevicePoint.kt\ncom/intellij/ui/awt/DevicePoint\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,152:1\n14060#2,2:153\n*S KotlinDebug\n*F\n+ 1 DevicePoint.kt\ncom/intellij/ui/awt/DevicePoint\n*L\n109#1:153,2\n*E\n"})
public final class DevicePoint {
    @NotNull
    private final Point point;

    @NotNull
    public final Point getPoint() {
        return this.point;
    }

    public DevicePoint(@NotNull Point locationOnScreen, @NotNull Component sourceComponent) {
        Point point;
        Intrinsics.checkNotNullParameter((Object)locationOnScreen, (String)"locationOnScreen");
        Intrinsics.checkNotNullParameter((Object)sourceComponent, (String)"sourceComponent");
        if (this.requiresScaling()) {
            if (sourceComponent.getGraphicsConfiguration() == null) {
                throw new Error("Component's graphics configuration is null. Ensure component is added to a container. " + sourceComponent);
            }
            float scale = JBUIScale.sysScale(sourceComponent);
            Point screenOrigin = sourceComponent.getGraphicsConfiguration().getBounds().getLocation();
            Intrinsics.checkNotNull((Object)screenOrigin);
            point = this.scale(locationOnScreen, screenOrigin, scale);
        } else {
            Point point2 = locationOnScreen.getLocation();
            Intrinsics.checkNotNull((Object)point2);
            point = point2;
        }
        this.point = point;
    }

    public DevicePoint(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Point point = event.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
        Component component = event.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
        this(point, component);
    }

    public DevicePoint(@NotNull RelativePoint relativePoint) {
        Intrinsics.checkNotNullParameter((Object)relativePoint, (String)"relativePoint");
        Point point = relativePoint.getScreenPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getScreenPoint(...)");
        Component component = relativePoint.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
        this(point, component);
    }

    @NotNull
    public final Point getLocationOnScreen() {
        return this.requiresScaling() ? this.getLocationOnScreenFromPoint(this.point) : new Point(this.point);
    }

    @NotNull
    public final Point getLocationOnScreen(@NotNull Component destinationComponent) {
        Intrinsics.checkNotNullParameter((Object)destinationComponent, (String)"destinationComponent");
        if (destinationComponent.getGraphicsConfiguration() != null) {
            GraphicsConfiguration graphicsConfiguration = destinationComponent.getGraphicsConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
            return this.getLocationOnScreen(graphicsConfiguration);
        }
        if (destinationComponent.isShowing()) {
            Point point = destinationComponent.getLocationOnScreen();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
            return this.getLocationOnScreenFromPoint(point);
        }
        return new Point(this.point);
    }

    @NotNull
    public final Point getLocationOnScreen(@NotNull GraphicsConfiguration destinationGraphicsConfiguration) {
        Point point;
        Intrinsics.checkNotNullParameter((Object)destinationGraphicsConfiguration, (String)"destinationGraphicsConfiguration");
        if (this.requiresScaling()) {
            float factor = JBUIScale.sysScale(destinationGraphicsConfiguration);
            Point screenOrigin = destinationGraphicsConfiguration.getBounds().getLocation();
            Intrinsics.checkNotNull((Object)screenOrigin);
            point = this.scale(this.point, screenOrigin, 1.0f / factor);
        } else {
            point = new Point(this.point);
        }
        return point;
    }

    private final Point getLocationOnScreenFromPoint(Point destinationPoint) {
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsDeviceArray, (String)"getScreenDevices(...)");
        Object[] $this$forEach$iv = graphicsDeviceArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rectangle rectangle;
            GraphicsDevice device = (GraphicsDevice)element$iv;
            boolean bl = false;
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            float factor = JBUIScale.sysScale(gc);
            Rectangle it = rectangle = gc.getBounds();
            boolean bl2 = false;
            it.width = MathKt.roundToInt((float)((float)it.width * factor));
            it.height = MathKt.roundToInt((float)((float)it.height * factor));
            Rectangle deviceBounds = rectangle;
            if (!deviceBounds.contains(destinationPoint)) continue;
            Point point = deviceBounds.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
            return this.scale(this.point, point, 1.0f / factor);
        }
        return new Point(this.point);
    }

    private final boolean requiresScaling() {
        return SystemInfoRt.isLinux || SystemInfoRt.isMac ? false : JreHiDpiUtil.isJreHiDPIEnabled();
    }

    @NotNull
    public final RelativePoint toRelativePoint(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Point location = this.getLocationOnScreen(component);
        SwingUtilities.convertPointFromScreen(location, component);
        return new RelativePoint(component, location);
    }

    private final Point scale(Point point, Point screenOrigin, float factor) {
        return new Point(MathKt.roundToInt((float)((float)screenOrigin.x + (float)(point.x - screenOrigin.x) * factor)), MathKt.roundToInt((float)((float)screenOrigin.y + (float)(point.y - screenOrigin.y) * factor)));
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + "[x=" + this.point.x + ",y=" + this.point.y + "]";
    }
}

