/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.CachedImageIconKt;
import com.intellij.ui.icons.DeprecatedDuplicatesIconPathPatcher;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.ImageDataLoaderDescriptor;
import com.intellij.ui.scale.JBUIScaleKt;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.protobuf.ProtoBuf;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000bH\u0007\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007\u001a\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u0016*\u0004\u0018\u00010\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0002\u0010\u001e\u001a!\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0002\u0010$\"\u001b\u0010\u0000\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u0010\u0010\u0006\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"EMPTY_ICON", "Ljavax/swing/ImageIcon;", "getEMPTY_ICON", "()Ljavax/swing/ImageIcon;", "EMPTY_ICON$delegate", "Lkotlin/Lazy;", "pathTransformGlobalModCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "patchIconPath", "Lkotlin/Pair;", "", "Ljava/lang/ClassLoader;", "originalPath", "classLoader", "pathTransform", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ui/icons/IconTransform;", "createCachedIcon", "Lcom/intellij/ui/icons/CachedImageIcon;", "file", "Ljava/nio/file/Path;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "decodeCachedImageIconFromByteArray", "Ljavax/swing/Icon;", "byteArray", "", "applyGraphicsScaleToObjectScale", "graphicsScale", "", "(Lcom/intellij/ui/scale/ScaleContext;Ljava/lang/Double;)Lcom/intellij/ui/scale/ScaleContext;", "computeGraphicsScale", "g", "Ljava/awt/Graphics;", "gc", "Ljava/awt/GraphicsConfiguration;", "(Ljava/awt/Graphics;Ljava/awt/GraphicsConfiguration;)Ljava/lang/Double;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nCachedImageIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedImageIcon.kt\ncom/intellij/ui/icons/CachedImageIconKt\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,513:1\n196#2:514\n*S KotlinDebug\n*F\n+ 1 CachedImageIcon.kt\ncom/intellij/ui/icons/CachedImageIconKt\n*L\n470#1:514\n*E\n"})
public final class CachedImageIconKt {
    @NotNull
    private static final Lazy EMPTY_ICON$delegate = LazyKt.lazy(CachedImageIconKt::EMPTY_ICON_delegate$lambda$0);
    @JvmField
    @NotNull
    public static final AtomicInteger pathTransformGlobalModCount = new AtomicInteger();
    @JvmField
    @NotNull
    public static final AtomicReference<IconTransform> pathTransform;

    @NotNull
    public static final ImageIcon getEMPTY_ICON() {
        Lazy lazy = EMPTY_ICON$delegate;
        return (ImageIcon)lazy.getValue();
    }

    @ApiStatus.Internal
    @Nullable
    public static final Pair<String, ClassLoader> patchIconPath(@NotNull String originalPath, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return pathTransform.get().patchPath(originalPath, classLoader);
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public static final CachedImageIcon createCachedIcon(@NotNull Path file, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        return new CachedImageIcon(file, scaleContext);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @Nullable
    public static final Icon decodeCachedImageIconFromByteArray(@NotNull byte[] byteArray) {
        void $this$decodeFromByteArray$iv;
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        BinaryFormat binaryFormat = (BinaryFormat)ProtoBuf.Default;
        byte[] bytes$iv = byteArray;
        boolean $i$f$decodeFromByteArray = false;
        $this$decodeFromByteArray$iv.getSerializersModule();
        ImageDataLoaderDescriptor descriptor = (ImageDataLoaderDescriptor)$this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)ImageDataLoaderDescriptor.Companion.serializer(), bytes$iv);
        ImageDataLoader imageDataLoader = descriptor.createIcon();
        if (imageDataLoader == null) {
            return null;
        }
        return new CachedImageIcon(imageDataLoader);
    }

    private static final ScaleContext applyGraphicsScaleToObjectScale(ScaleContext $this$applyGraphicsScaleToObjectScale, Double graphicsScale) {
        if (graphicsScale == null) {
            return $this$applyGraphicsScaleToObjectScale;
        }
        if ($this$applyGraphicsScaleToObjectScale == null) {
            return ScaleContext.Companion.create(ScaleType.OBJ_SCALE.of(graphicsScale));
        }
        return $this$applyGraphicsScaleToObjectScale.copyWithScale(ScaleType.OBJ_SCALE.of($this$applyGraphicsScaleToObjectScale.getScale(ScaleType.OBJ_SCALE) * graphicsScale));
    }

    private static final Double computeGraphicsScale(Graphics g, GraphicsConfiguration gc) {
        Object object;
        Object object2 = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (object2 == null || (object2 = ((Graphics2D)object2).getTransform()) == null) {
            return null;
        }
        Object transform = object2;
        double defaultScale = JreHiDpiUtil.isJreHiDPIEnabled() ? ((object = gc) != null && (object = ((GraphicsConfiguration)object).getDefaultTransform()) != null ? ((AffineTransform)object).getScaleX() : 1.0) : 1.0;
        double graphicsScale = (double)JBUIScaleKt.getTransformScaleX((AffineTransform)transform) / defaultScale;
        if (Math.abs(graphicsScale - 1.0) < 0.001) {
            return null;
        }
        return graphicsScale;
    }

    private static final EMPTY_ICON.2.1 EMPTY_ICON_delegate$lambda$0() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 5);
        return new ImageIcon(bufferedImage){

            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
    }

    public static final /* synthetic */ Double access$computeGraphicsScale(Graphics g, GraphicsConfiguration gc) {
        return CachedImageIconKt.computeGraphicsScale(g, gc);
    }

    public static final /* synthetic */ ScaleContext access$applyGraphicsScaleToObjectScale(ScaleContext $receiver, Double graphicsScale) {
        return CachedImageIconKt.applyGraphicsScaleToObjectScale($receiver, graphicsScale);
    }

    static {
        IconPathPatcher[] iconPathPatcherArray = new IconPathPatcher[]{new DeprecatedDuplicatesIconPathPatcher()};
        pathTransform = new AtomicReference<IconTransform>(new IconTransform(false, iconPathPatcherArray, null));
    }
}

