/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.ui.Gray;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.RgbImageFilterSupplier;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContextSupport;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a*\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u000e"}, d2={"getScaleContextSupport", "Lcom/intellij/ui/scale/ScaleContextSupport;", "icon", "Ljavax/swing/Icon;", "getScaleToRenderIcon", "", "ancestor", "Ljava/awt/Component;", "renderFilteredIcon", "Lcom/intellij/util/ui/JBImageIcon;", "scale", "", "filterSupplier", "Lcom/intellij/ui/icons/RgbImageFilterSupplier;", "intellij.platform.util.ui"})
public final class FilteredIconKt {
    private static final ScaleContextSupport getScaleContextSupport(Icon icon) {
        ScaleContextSupport scaleContextSupport;
        Icon icon2 = icon;
        if (icon2 instanceof ScaleContextSupport) {
            scaleContextSupport = (ScaleContextSupport)((Object)icon);
        } else if (icon2 instanceof RetrievableIcon) {
            Icon icon3 = ((RetrievableIcon)icon).retrieveIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"retrieveIcon(...)");
            scaleContextSupport = FilteredIconKt.getScaleContextSupport(icon3);
        } else if (icon2 instanceof CompositeIcon) {
            if (((CompositeIcon)icon).getIconCount() == 0) {
                return null;
            }
            Icon icon4 = ((CompositeIcon)icon).getIcon(0);
            if (icon4 == null) {
                return null;
            }
            scaleContextSupport = FilteredIconKt.getScaleContextSupport(icon4);
        } else {
            scaleContextSupport = null;
        }
        return scaleContextSupport;
    }

    private static final float getScaleToRenderIcon(Icon icon, Component ancestor) {
        ScaleContextSupport ctxSupport = FilteredIconKt.getScaleContextSupport(icon);
        float scale = ctxSupport == null ? (JreHiDpiUtil.isJreHiDPI(null) ? JBUIScale.sysScale(ancestor) : 1.0f) : (JreHiDpiUtil.isJreHiDPI(null) ? (float)ctxSupport.getScale(ScaleType.SYS_SCALE) : 1.0f);
        return scale;
    }

    private static final JBImageIcon renderFilteredIcon(Icon icon, double scale, RgbImageFilterSupplier filterSupplier, Component ancestor) {
        BufferedImage image = new BufferedImage((int)(scale * (double)icon.getIconWidth()), (int)(scale * (double)icon.getIconHeight()), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Gray.TRANSPARENT);
        graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        graphics.scale(scale, scale);
        icon.paintIcon(IconLoaderKt.getFakeComponent(), graphics, 0, 0);
        graphics.dispose();
        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filterSupplier.getFilter()));
        if (StartupUiUtil.isJreHiDPI(ancestor)) {
            Image image2 = img;
            Intrinsics.checkNotNull((Object)image2);
            img = RetinaImage.createFrom(image2, scale, null);
        }
        Image image3 = img;
        Intrinsics.checkNotNull((Object)image3);
        return new JBImageIcon(image3);
    }

    public static final /* synthetic */ float access$getScaleToRenderIcon(Icon icon, Component ancestor) {
        return FilteredIconKt.getScaleToRenderIcon(icon, ancestor);
    }

    public static final /* synthetic */ JBImageIcon access$renderFilteredIcon(Icon icon, double scale, RgbImageFilterSupplier filterSupplier, Component ancestor) {
        return FilteredIconKt.renderFilteredIcon(icon, scale, filterSupplier, ancestor);
    }
}

