/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.Scale;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.SmartList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserScaleContext {
    protected Scale usrScale = ScaleType.USR_SCALE.of(JBUIScale.scale(1.0f));
    protected Scale objScale = ScaleType.OBJ_SCALE.of(1.0f);
    protected double pixScale;
    private List<UpdateListener> listeners;
    @Nullable
    protected EnumSet<ScaleType> overriddenScales;
    private static final Scale @NotNull [] EMPTY_SCALE_ARRAY = new Scale[0];

    protected UserScaleContext() {
        this.pixScale = this.usrScale.value;
    }

    @NotNull
    public static UserScaleContext createIdentity() {
        return UserScaleContext.create(ScaleType.USR_SCALE.of(1.0f));
    }

    @NotNull
    public static UserScaleContext create(Scale ... scales) {
        if (scales == null) {
            UserScaleContext.$$$reportNull$$$0(0);
        }
        UserScaleContext ctx = UserScaleContext.create();
        for (Scale s : scales) {
            ctx.setScale(s);
        }
        UserScaleContext userScaleContext = ctx;
        if (userScaleContext == null) {
            UserScaleContext.$$$reportNull$$$0(1);
        }
        return userScaleContext;
    }

    @NotNull
    public static UserScaleContext create() {
        return new UserScaleContext();
    }

    @NotNull
    public static UserScaleContext create(@Nullable UserScaleContext ctx) {
        UserScaleContext c = UserScaleContext.createIdentity();
        c.update(ctx);
        UserScaleContext userScaleContext = c;
        if (userScaleContext == null) {
            UserScaleContext.$$$reportNull$$$0(2);
        }
        return userScaleContext;
    }

    protected double derivePixScale() {
        return this.usrScale.value * this.objScale.value;
    }

    public boolean overrideScale(@NotNull Scale scale) {
        if (scale == null) {
            UserScaleContext.$$$reportNull$$$0(3);
        }
        if (this.overriddenScales != null) {
            this.overriddenScales.remove((Object)scale.type);
        }
        boolean updated = this.setScale(scale);
        if (this.overriddenScales == null) {
            this.overriddenScales = EnumSet.of(scale.type);
        } else {
            this.overriddenScales.add(scale.type);
        }
        return updated;
    }

    protected boolean isScaleOverridden(@NotNull Scale scale) {
        if (scale == null) {
            UserScaleContext.$$$reportNull$$$0(4);
        }
        return this.overriddenScales != null && this.overriddenScales.contains((Object)scale.type);
    }

    protected Scale @NotNull [] getOverriddenScales() {
        if (this.overriddenScales == null) {
            if (EMPTY_SCALE_ARRAY == null) {
                UserScaleContext.$$$reportNull$$$0(5);
            }
            return EMPTY_SCALE_ARRAY;
        }
        Scale[] scales = new Scale[this.overriddenScales.size()];
        int i = 0;
        for (ScaleType type : this.overriddenScales) {
            scales[i++] = this.getScaleObject(type);
        }
        if (scales == null) {
            UserScaleContext.$$$reportNull$$$0(6);
        }
        return scales;
    }

    public boolean setScale(@NotNull Scale scale) {
        if (scale == null) {
            UserScaleContext.$$$reportNull$$$0(7);
        }
        if (this.isScaleOverridden(scale)) {
            return false;
        }
        boolean updated = false;
        switch (scale.type) {
            case USR_SCALE: {
                updated = !this.usrScale.equals(scale);
                this.usrScale = scale;
                break;
            }
            case OBJ_SCALE: {
                updated = !this.objScale.equals(scale);
                this.objScale = scale;
                break;
            }
            case SYS_SCALE: {
                return false;
            }
        }
        return this.onUpdated(updated);
    }

    public double getScale(@NotNull ScaleType type) {
        if (type == null) {
            UserScaleContext.$$$reportNull$$$0(8);
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ScaleType.USR_SCALE -> this.usrScale.value;
            case ScaleType.SYS_SCALE -> 1.0;
            case ScaleType.OBJ_SCALE -> this.objScale.value;
        };
    }

    @NotNull
    protected Scale getScaleObject(@NotNull ScaleType type) {
        if (type == null) {
            UserScaleContext.$$$reportNull$$$0(9);
        }
        Scale scale = switch (type) {
            default -> throw new MatchException(null, null);
            case ScaleType.USR_SCALE -> this.usrScale;
            case ScaleType.SYS_SCALE -> ScaleType.SYS_SCALE.of(1.0f);
            case ScaleType.OBJ_SCALE -> this.objScale;
        };
        if (scale == null) {
            UserScaleContext.$$$reportNull$$$0(10);
        }
        return scale;
    }

    public double getScale(@NotNull DerivedScaleType type) {
        if (type == null) {
            UserScaleContext.$$$reportNull$$$0(11);
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case DerivedScaleType.DEV_SCALE -> 1.0;
            case DerivedScaleType.PIX_SCALE, DerivedScaleType.EFF_USR_SCALE -> this.pixScale;
        };
    }

    public double apply(double value, DerivedScaleType type) {
        return value * this.getScale(type);
    }

    public double apply(double value, ScaleType type) {
        return value * this.getScale(type);
    }

    protected boolean onUpdated(boolean updated) {
        if (updated) {
            this.pixScale = this.derivePixScale();
            this.notifyUpdateListeners();
        }
        return updated;
    }

    public boolean update() {
        return this.onUpdated(this.setScale(ScaleType.USR_SCALE.of(JBUIScale.scale(1.0f))));
    }

    public boolean update(@Nullable UserScaleContext scaleContext) {
        return scaleContext == null ? this.update() : this.onUpdated(this.updateAll(scaleContext));
    }

    protected <T extends UserScaleContext> boolean updateAll(@NotNull T scaleContext) {
        if (scaleContext == null) {
            UserScaleContext.$$$reportNull$$$0(12);
        }
        boolean updated = this.setScale(scaleContext.usrScale);
        updated = this.setScale(scaleContext.objScale) || updated;
        for (Scale scale : scaleContext.getOverriddenScales()) {
            this.overrideScale(scale);
        }
        return updated;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UserScaleContext)) {
            return false;
        }
        UserScaleContext that = (UserScaleContext)obj;
        return that.usrScale.value == this.usrScale.value && that.objScale.value == this.objScale.value;
    }

    public int hashCode() {
        return Double.hashCode(this.usrScale.value) * 31 + Double.hashCode(this.objScale.value);
    }

    public void dispose() {
        this.listeners = null;
    }

    public void addUpdateListener(@NotNull UpdateListener l) {
        if (l == null) {
            UserScaleContext.$$$reportNull$$$0(13);
        }
        if (this.listeners == null) {
            this.listeners = new SmartList((Object)l);
        } else {
            this.listeners.add(l);
        }
    }

    public void removeUpdateListener(@NotNull UpdateListener l) {
        if (l == null) {
            UserScaleContext.$$$reportNull$$$0(14);
        }
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    protected void notifyUpdateListeners() {
        if (this.listeners != null) {
            this.listeners.forEach(UpdateListener::contextUpdated);
        }
    }

    @NotNull
    public <T extends UserScaleContext> T copy() {
        UserScaleContext ctx = UserScaleContext.createIdentity();
        ctx.updateAll(this);
        UserScaleContext userScaleContext = ctx;
        if (userScaleContext == null) {
            UserScaleContext.$$$reportNull$$$0(15);
        }
        return (T)userScaleContext;
    }

    public String toString() {
        return String.valueOf(this.usrScale) + ", " + String.valueOf(this.objScale) + ", " + this.pixScale;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 10, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scales";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/scale/UserScaleContext";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scale";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/scale/UserScaleContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenScales";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScaleObject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "overrideScale";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isScaleOverridden";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setScale";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getScale";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScaleObject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateAll";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeUpdateListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 10, 15 -> new IllegalStateException(string);
        };
    }

    public static interface UpdateListener {
        public void contextUpdated();
    }
}

