/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.nodes.SVG;
import com.intellij.ui.icons.HiDPIImage;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.svg.DataWithMimeType;
import com.intellij.ui.svg.FloatDimensions;
import com.intellij.ui.svg.ImageDimension;
import com.intellij.ui.svg.ImageDimensions;
import com.intellij.ui.svg.JSvgDocumentFactoryKt;
import com.intellij.ui.svg.LoadedAdaptiveImage;
import com.intellij.ui.svg.LoadedRasterImage;
import com.intellij.ui.svg.LoadedSVGImage;
import com.intellij.ui.svg.RasterizedVectorImage;
import com.intellij.ui.svg.SVGRasterizationConfig;
import com.intellij.ui.svg.SvgViewBox;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"DEFAULT_SVG_WIDTH", "", "DEFAULT_SVG_HEIGHT", "ESTIMATED_SVG_MEMORY_PER_SRC_BYTE", "", "loadSvg", "Lcom/intellij/ui/svg/LoadedSVGImage;", "data", "", "src", "", "getSvgDimensions", "Lcom/intellij/ui/svg/ImageDimensions;", "svg", "Lcom/github/weisj/jsvg/nodes/SVG;", "svgLengthToImageDimension", "Lcom/intellij/ui/svg/ImageDimension;", "svgLength", "Lcom/github/weisj/jsvg/geometry/size/Length;", "rasterizeSVGImage", "Lcom/intellij/ui/svg/RasterizedVectorImage;", "config", "Lcom/intellij/ui/svg/SVGRasterizationConfig;", "loadAdaptiveImage", "Lcom/intellij/ui/svg/LoadedAdaptiveImage;", "dataWithMimeType", "Lcom/intellij/ui/svg/DataWithMimeType;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nAdaptiveImageLoad.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptiveImageLoad.kt\ncom/intellij/ui/svg/AdaptiveImageLoadKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class AdaptiveImageLoadKt {
    private static final float DEFAULT_SVG_WIDTH = 40.0f;
    private static final float DEFAULT_SVG_HEIGHT = 40.0f;
    private static final long ESTIMATED_SVG_MEMORY_PER_SRC_BYTE = 48L;

    @NotNull
    public static final LoadedSVGImage loadSvg(@NotNull byte[] data, @NotNull String src) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        SVG svg = JSvgDocumentFactoryKt.createJSvgDocument(data);
        ImageDimensions dimensions = AdaptiveImageLoadKt.getSvgDimensions(svg);
        long estimatedMemoryConsumption = (long)data.length * 48L;
        return new LoadedSVGImage(src, svg, dimensions, estimatedMemoryConsumption);
    }

    private static final ImageDimensions getSvgDimensions(SVG svg) {
        SvgViewBox viewBox = new SvgViewBox(svg);
        float aspectRatio = viewBox.getHeight() > 0.0f ? viewBox.getWidth() / viewBox.getHeight() : 0.0f;
        ImageDimension width = null;
        ImageDimension height = null;
        if (svg.getWidth().isSpecified() && svg.getHeight().isSpecified()) {
            Length length = svg.getWidth();
            Intrinsics.checkNotNullExpressionValue((Object)length, (String)"getWidth(...)");
            width = AdaptiveImageLoadKt.svgLengthToImageDimension(length);
            Length length2 = svg.getHeight();
            Intrinsics.checkNotNullExpressionValue((Object)length2, (String)"getHeight(...)");
            height = AdaptiveImageLoadKt.svgLengthToImageDimension(length2);
        } else if (svg.getWidth().isSpecified()) {
            Length length = svg.getWidth();
            Intrinsics.checkNotNullExpressionValue((Object)length, (String)"getWidth(...)");
            width = AdaptiveImageLoadKt.svgLengthToImageDimension(length);
            height = aspectRatio > 0.0f ? new ImageDimension(width.getUnit(), width.getValue() / aspectRatio) : new ImageDimension(ImageDimension.Unit.PX, 40.0f);
        } else if (svg.getHeight().isSpecified()) {
            Length length = svg.getHeight();
            Intrinsics.checkNotNullExpressionValue((Object)length, (String)"getHeight(...)");
            height = AdaptiveImageLoadKt.svgLengthToImageDimension(length);
            width = aspectRatio > 0.0f ? new ImageDimension(height.getUnit(), height.getValue() * aspectRatio) : new ImageDimension(ImageDimension.Unit.PX, 40.0f);
        } else if (viewBox.getWidth() > 0.0f && viewBox.getHeight() > 0.0f) {
            width = new ImageDimension(ImageDimension.Unit.PX, viewBox.getWidth());
            height = new ImageDimension(ImageDimension.Unit.PX, viewBox.getHeight());
        } else {
            width = new ImageDimension(ImageDimension.Unit.PX, 40.0f);
            height = new ImageDimension(ImageDimension.Unit.PX, 40.0f);
        }
        float fallbackWidth = 0.0f;
        float fallbackHeight = 0.0f;
        if (width.getUnit() == ImageDimension.Unit.PX && height.getUnit() == ImageDimension.Unit.PX) {
            fallbackWidth = width.getValue();
            fallbackHeight = height.getValue();
        } else {
            Float f = Float.valueOf(viewBox.getWidth());
            float it = ((Number)f).floatValue();
            boolean bl = false;
            Float f2 = it > 0.0f ? f : null;
            fallbackWidth = f2 != null ? f2.floatValue() : 40.0f;
            f = Float.valueOf(viewBox.getWidth());
            it = ((Number)f).floatValue();
            boolean bl2 = false;
            Float f3 = it > 0.0f ? f : null;
            fallbackHeight = f3 != null ? f3.floatValue() : 40.0f;
        }
        return new ImageDimensions(width, height, new FloatDimensions(fallbackWidth, fallbackHeight));
    }

    private static final ImageDimension svgLengthToImageDimension(Length svgLength) {
        switch (WhenMappings.$EnumSwitchMapping$0[svgLength.unit().ordinal()]) {
            case 1: 
            case 2: {
                return new ImageDimension(ImageDimension.Unit.PX, svgLength.raw());
            }
            case 3: {
                return new ImageDimension(ImageDimension.Unit.EM, svgLength.raw());
            }
            case 4: {
                return new ImageDimension(ImageDimension.Unit.EX, svgLength.raw());
            }
            case 5: {
                return new ImageDimension(ImageDimension.Unit.PERCENTAGE, svgLength.raw());
            }
        }
        MeasureContext measureContext = new MeasureContext(16.0f, 16.0f, 10.0f, 10.0f);
        return new ImageDimension(ImageDimension.Unit.PX, svgLength.resolveLength(measureContext));
    }

    @ApiStatus.Internal
    @NotNull
    public static final RasterizedVectorImage rasterizeSVGImage(@NotNull SVGRasterizationConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        HiDPIImage img = new HiDPIImage(config.getScale(), (double)config.getLogicalWidth(), (double)config.getLogicalHeight(), 2, PaintUtil.RoundingMode.FLOOR);
        Graphics2D g = img.createUnscaledGraphics();
        float defaultEm = SVGFont.defaultFontSize();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        config.getSvgImage().getSvgNode().renderWithSize((float)img.getWidth(), (float)img.getHeight(), defaultEm, g);
        return new RasterizedVectorImage(img);
    }

    @ApiStatus.Internal
    @NotNull
    public static final LoadedAdaptiveImage loadAdaptiveImage(@NotNull DataWithMimeType dataWithMimeType, @NotNull String src) {
        Intrinsics.checkNotNullParameter((Object)dataWithMimeType, (String)"dataWithMimeType");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (Intrinsics.areEqual((Object)dataWithMimeType.getContentType(), (Object)"image/svg+xml")) {
            return AdaptiveImageLoadKt.loadSvg(dataWithMimeType.getData(), src);
        }
        BufferedImage rasterImage = IconUtilKt.loadRasterImage(new ByteArrayInputStream(dataWithMimeType.getData()));
        float rasterWidth = rasterImage.getWidth();
        float rasterHeight = rasterImage.getHeight();
        ImageDimension width = new ImageDimension(ImageDimension.Unit.PX, rasterWidth);
        ImageDimension height = new ImageDimension(ImageDimension.Unit.PX, rasterHeight);
        long memorySize = (long)rasterImage.getWidth() * (long)rasterImage.getHeight() * (long)4;
        ImageDimensions dimensions = new ImageDimensions(width, height, new FloatDimensions(rasterWidth, rasterHeight));
        return new LoadedRasterImage(rasterImage, dimensions, memorySize);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Unit.values().length];
            try {
                nArray[Unit.PX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.Raw.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.EM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.EX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Unit.PERCENTAGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

