/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBInsets
extends Insets {
    @Nullable
    private final @Nullable Supplier<? extends @Nullable Insets> unscaledSupplier;
    @NotNull
    private final Insets unscaledDefault;

    @ApiStatus.Internal
    public JBInsets(int all) {
        this(all, all, all, all);
    }

    @ApiStatus.Internal
    @NotNull
    public static JBInsets emptyInsets() {
        return new JBInsets(0, 0, 0, 0);
    }

    public JBInsets(int top, int left, int bottom, int right) {
        this(null, new Insets(top, left, bottom, right), JBUI.scale(top), JBUI.scale(left), JBUI.scale(bottom), JBUI.scale(right));
    }

    private JBInsets(@NotNull JBInsets other) {
        if (other == null) {
            JBInsets.$$$reportNull$$$0(0);
        }
        super(other.top, other.left, other.bottom, other.right);
        this.unscaledSupplier = other.unscaledSupplier;
        this.unscaledDefault = new Insets(other.unscaledDefault.top, other.unscaledDefault.left, other.unscaledDefault.bottom, other.unscaledDefault.right);
    }

    private JBInsets(@Nullable @Nullable Supplier<? extends @Nullable Insets> unscaledSupplier, @NotNull Insets unscaledDefault, int scaledTop, int scaledLeft, int scaledBottom, int scaledRight) {
        if (unscaledDefault == null) {
            JBInsets.$$$reportNull$$$0(1);
        }
        super(scaledTop, scaledLeft, scaledBottom, scaledRight);
        this.unscaledSupplier = unscaledSupplier;
        this.unscaledDefault = unscaledDefault;
    }

    public void update() {
        Insets unscaled = this.unscaledNoCopy();
        this.top = JBUIScale.scale(unscaled.top);
        this.left = JBUIScale.scale(unscaled.left);
        this.bottom = JBUIScale.scale(unscaled.bottom);
        this.right = JBUIScale.scale(unscaled.right);
    }

    @NotNull
    private Insets unscaledNoCopy() {
        Insets result;
        Insets insets = result = this.unscaledSupplier != null ? this.unscaledSupplier.get() : this.unscaledDefault;
        if (result == null) {
            result = this.unscaledDefault;
        }
        Insets insets2 = result;
        if (insets2 == null) {
            JBInsets.$$$reportNull$$$0(2);
        }
        return insets2;
    }

    public int width() {
        return this.left + this.right;
    }

    public int height() {
        return this.top + this.bottom;
    }

    @NotNull
    public static JBInsets create(int topBottom, int leftRight) {
        return new JBInsets(topBottom, leftRight, topBottom, leftRight);
    }

    @NotNull
    public static JBInsets create(@NotNull Insets insets) {
        if (insets == null) {
            JBInsets.$$$reportNull$$$0(3);
        }
        if (insets instanceof JBInsets) {
            JBInsets jbInsets = (JBInsets)insets;
            return new JBInsets(jbInsets);
        }
        return new JBInsets(insets.top, insets.left, insets.bottom, insets.right);
    }

    @NotNull
    public static JBInsets create(@NotNull String key, @NotNull Insets defaultValue) {
        Insets insets;
        if (key == null) {
            JBInsets.$$$reportNull$$$0(4);
        }
        if (defaultValue == null) {
            JBInsets.$$$reportNull$$$0(5);
        }
        if (defaultValue instanceof JBInsets) {
            JBInsets jbInsets = (JBInsets)defaultValue;
            insets = jbInsets.unscaledDefault;
        } else {
            insets = defaultValue;
        }
        Insets defInsets = insets;
        return JBInsets.create(new UIDefaultsSupplier(key), defInsets);
    }

    @ApiStatus.Internal
    @NotNull
    public static JBInsets create(@Nullable @Nullable Supplier<? extends @Nullable Insets> unscaledSupplier, @NotNull Insets unscaledDefault) {
        if (unscaledDefault == null) {
            JBInsets.$$$reportNull$$$0(6);
        }
        JBInsets result = new JBInsets(unscaledSupplier, unscaledDefault, 0, 0, 0, 0);
        result.update();
        JBInsets jBInsets = result;
        if (jBInsets == null) {
            JBInsets.$$$reportNull$$$0(7);
        }
        return jBInsets;
    }

    public Insets getUnscaled() {
        Insets unscaled = this.unscaledNoCopy();
        return new Insets(unscaled.top, unscaled.left, unscaled.bottom, unscaled.right);
    }

    public JBInsetsUIResource asUIResource() {
        return new JBInsetsUIResource(this);
    }

    static boolean isZero(Insets insets) {
        if (insets instanceof JBInsets) {
            JBInsets jbInsets = (JBInsets)insets;
            if (jbInsets.unscaledSupplier != null) {
                return false;
            }
        }
        return insets.top == 0 && insets.left == 0 && insets.bottom == 0 && insets.right == 0;
    }

    public static void addTo(@NotNull Dimension dimension, Insets insets) {
        if (dimension == null) {
            JBInsets.$$$reportNull$$$0(8);
        }
        if (insets != null) {
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
    }

    public static void removeFrom(@NotNull Dimension dimension, Insets insets) {
        if (dimension == null) {
            JBInsets.$$$reportNull$$$0(9);
        }
        if (insets != null) {
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
        }
    }

    public static void addTo(@NotNull Rectangle rectangle, Insets insets) {
        if (rectangle == null) {
            JBInsets.$$$reportNull$$$0(10);
        }
        if (insets != null) {
            rectangle.x -= insets.left;
            rectangle.y -= insets.top;
            rectangle.width += insets.left + insets.right;
            rectangle.height += insets.top + insets.bottom;
        }
    }

    public static void removeFrom(@NotNull Rectangle rectangle, Insets insets) {
        if (rectangle == null) {
            JBInsets.$$$reportNull$$$0(11);
        }
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static JBInsets addInsets(Insets ... insets) {
        if (insets == null) {
            JBInsets.$$$reportNull$$$0(12);
        }
        JBInsets[] copies = new JBInsets[insets.length];
        for (int i = 0; i < insets.length; ++i) {
            copies[i] = JBInsets.create(insets[i]);
        }
        @Nullable SummingSupplier unscaledSupplier = new SummingSupplier(copies);
        Insets unscaledDefault = Objects.requireNonNull((Insets)unscaledSupplier.get());
        return JBInsets.create(unscaledSupplier, unscaledDefault);
    }

    @ApiStatus.Internal
    public static Insets unwrap(@NotNull Insets insets) {
        if (insets == null) {
            JBInsets.$$$reportNull$$$0(13);
        }
        if (insets instanceof JBInsets) {
            JBInsets jbInsets = (JBInsets)insets;
            return jbInsets.getUnscaled();
        }
        return insets;
    }

    @ApiStatus.Internal
    public static Insets unscale(@NotNull Insets insets) {
        if (insets == null) {
            JBInsets.$$$reportNull$$$0(14);
        }
        if (insets instanceof JBInsets) {
            JBInsets jbInsets = (JBInsets)insets;
            return jbInsets.getUnscaled();
        }
        return insets;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unscaledDefault";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBInsets";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimension";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBInsets";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unscaledNoCopy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTo";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeFrom";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unscale";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }

    private static class UIDefaultsSupplier
    implements Supplier<Insets> {
        private final String key;

        UIDefaultsSupplier(String key) {
            this.key = key;
        }

        @Override
        @Nullable
        public Insets get() {
            return UIManager.getInsets(this.key);
        }

        public String toString() {
            return "UIDefaultsSupplier{key='" + this.key + "'}";
        }
    }

    public static final class JBInsetsUIResource
    extends JBInsets
    implements UIResource {
        public JBInsetsUIResource(JBInsets insets) {
            super(insets);
        }
    }

    private static class SummingSupplier
    implements Supplier<Insets> {
        private final JBInsets[] values;

        SummingSupplier(JBInsets[] values) {
            this.values = values;
        }

        @Override
        @Nullable
        public Insets get() {
            Insets unscaled = new Insets(0, 0, 0, 0);
            for (JBInsets value : this.values) {
                Insets unscaledValue = value.unscaledNoCopy();
                unscaled.top += unscaledValue.top;
                unscaled.left += unscaledValue.left;
                unscaled.bottom += unscaledValue.bottom;
                unscaled.right += unscaledValue.right;
            }
            return unscaled;
        }

        public String toString() {
            return "SummingSupplier{values=" + Arrays.toString(this.values) + "}";
        }
    }
}

