/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.html;

import com.intellij.util.ui.html.UtilsKt;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ParagraphView;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J$\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/ui/html/ParagraphViewEx;", "Ljavax/swing/text/html/ParagraphView;", "elem", "Ljavax/swing/text/Element;", "<init>", "(Ljavax/swing/text/Element;)V", "fixedLineHeight", "", "Ljava/lang/Float;", "scaledLineHeight", "fontLineHeight", "", "Ljava/lang/Integer;", "justification", "setPropertiesFromAttributes", "", "calculateMinorAxisRequirements", "Ljavax/swing/SizeRequirements;", "axis", "r", "createRow", "Ljavax/swing/text/View;", "getToolTipText", "", "x", "y", "allocation", "Ljava/awt/Shape;", "ParagraphRow", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nParagraphViewEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphViewEx.kt\ncom/intellij/util/ui/html/ParagraphViewEx\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n18#2:176\n18#2:178\n18#2:179\n1#3:177\n*S KotlinDebug\n*F\n+ 1 ParagraphViewEx.kt\ncom/intellij/util/ui/html/ParagraphViewEx\n*L\n42#1:176\n65#1:178\n79#1:179\n*E\n"})
public class ParagraphViewEx
extends ParagraphView {
    @JvmField
    @Nullable
    protected Float fixedLineHeight;
    @JvmField
    @Nullable
    protected Float scaledLineHeight;
    @JvmField
    @Nullable
    protected Integer fontLineHeight;
    @JvmField
    protected int justification;

    public ParagraphViewEx(@NotNull Element elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        super(elem);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setPropertiesFromAttributes() {
        String string;
        void $this$asSafely$iv;
        super.setPropertiesFromAttributes();
        Object object = this.getAttributes().getAttribute(CSS.Attribute.LINE_HEIGHT);
        if (object == null) return;
        Object object2 = object;
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof String)) {
            v0 = null;
        }
        if ((string = (String)v0) == null) return;
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String lineHeight = string2;
        if (lineHeight == null) return;
        if (StringsKt.endsWith$default(lineHeight, (String)"%", (boolean)false, (int)2, null)) {
            object = StringsKt.toFloatOrNull((String)StringsKt.removeSuffix(lineHeight, (CharSequence)"%"));
            if (object == null) return;
            float it = ((Number)object).floatValue();
            boolean bl = false;
            this.scaledLineHeight = Float.valueOf(it / 100.0f);
            return;
        } else if (StringsKt.endsWith$default((String)lineHeight, (String)"px", (boolean)false, (int)2, null)) {
            object = StringsKt.toFloatOrNull((String)StringsKt.removeSuffix((String)lineHeight, (CharSequence)"px"));
            if (object == null) return;
            float it = ((Number)object).floatValue();
            boolean bl = false;
            this.fixedLineHeight = Float.valueOf(it);
            return;
        } else {
            object = StringsKt.toFloatOrNull((String)lineHeight);
            if (object == null) return;
            float it = ((Number)object).floatValue();
            boolean bl = false;
            this.scaledLineHeight = Float.valueOf(it);
        }
    }

    @Override
    @NotNull
    protected SizeRequirements calculateMinorAxisRequirements(int axis, @Nullable SizeRequirements r) {
        Serializable serializable;
        Object it;
        Object font;
        Object object;
        Document $this$asSafely$iv = this.getDocument();
        boolean $i$f$asSafely = false;
        Document document = $this$asSafely$iv;
        if (!(document instanceof StyledDocument)) {
            document = null;
        }
        if ((object = (StyledDocument)document) == null || (object = object.getFont(this.getAttributes())) == null) {
            Container container = this.getContainer();
            object = container != null ? container.getFont() : null;
        }
        if ((font = object) != null) {
            it = font;
            boolean bl = false;
            serializable = this.getContainer();
            if (serializable == null || (serializable = serializable.getFontMetrics((Font)it)) == null) {
                serializable = Toolkit.getDefaultToolkit().getFontMetrics((Font)font);
            }
        } else {
            serializable = null;
        }
        it = serializable;
        boolean bl = false;
        Object object2 = it;
        this.fontLineHeight = object2 != null ? Integer.valueOf(((FontMetrics)object2).getHeight()) : null;
        SizeRequirements sizeRequirements = super.calculateMinorAxisRequirements(axis, r);
        Intrinsics.checkNotNullExpressionValue((Object)sizeRequirements, (String)"calculateMinorAxisRequirements(...)");
        return sizeRequirements;
    }

    @Override
    @NotNull
    protected View createRow() {
        Element element = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getElement(...)");
        return new ParagraphRow(element);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public String getToolTipText(float x, float y, @Nullable Shape allocation) {
        Object object;
        Object object2 = this.getElement().getAttributes().getAttribute(HTML.Attribute.TITLE);
        if (object2 != null) {
            String string;
            void $this$asSafely$iv;
            Object object3 = object2;
            boolean $i$f$asSafely = false;
            Object v0 = $this$asSafely$iv;
            if (!(v0 instanceof String)) {
                v0 = null;
            }
            if ((string = (String)v0) != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                Object object4 = object3 = ((CharSequence)it).length() > 0 ? string2 : null;
                if (object3 != null) {
                    object = object3;
                    return object;
                }
            }
        }
        object = super.getToolTipText(x, y, allocation);
        return object;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J(\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0014J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0014J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\"H\u0014J\b\u0010$\u001a\u00020\"H\u0014R\u0014\u0010%\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/intellij/util/ui/html/ParagraphViewEx$ParagraphRow;", "Ljavax/swing/text/BoxView;", "elem", "Ljavax/swing/text/Element;", "<init>", "(Lcom/intellij/util/ui/html/ParagraphViewEx;Ljavax/swing/text/Element;)V", "loadChildren", "", "f", "Ljavax/swing/text/ViewFactory;", "getAttributes", "Ljavax/swing/text/AttributeSet;", "getAlignment", "", "axis", "", "modelToView", "Ljava/awt/Shape;", "pos", "a", "b", "Ljavax/swing/text/Position$Bias;", "getStartOffset", "getEndOffset", "layoutMinorAxis", "targetSpan", "offsets", "", "spans", "calculateMinorAxisRequirements", "Ljavax/swing/SizeRequirements;", "r", "getViewIndexAtPosition", "getLeftInset", "", "getTopInset", "getBottomInset", "lineHeightCorrection", "getLineHeightCorrection", "()I", "intellij.platform.util.ui"})
    @SourceDebugExtension(value={"SMAP\nParagraphViewEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphViewEx.kt\ncom/intellij/util/ui/html/ParagraphViewEx$ParagraphRow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
    public final class ParagraphRow
    extends BoxView {
        public ParagraphRow(Element elem) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            super(elem, 0);
        }

        @Override
        protected void loadChildren(@NotNull ViewFactory f) {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        }

        @Override
        @Nullable
        public AttributeSet getAttributes() {
            View view = this.getParent();
            return view != null ? view.getAttributes() : null;
        }

        @Override
        public float getAlignment(int axis) {
            if (axis == 0) {
                switch (ParagraphViewEx.this.justification) {
                    case 0: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: {
                        return 0.5f;
                    }
                    case 3: {
                        return 0.0f;
                    }
                }
            }
            return super.getAlignment(axis);
        }

        @Override
        @NotNull
        public Shape modelToView(int pos, @NotNull Shape a, @NotNull Position.Bias b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Rectangle r = a.getBounds();
            View v = this.getViewAtPosition(pos, r);
            if (v != null && !v.getElement().isLeaf()) {
                Shape shape = super.modelToView(pos, a, b);
                Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"modelToView(...)");
                return shape;
            }
            r = a.getBounds();
            int height = r.height;
            int y = r.y;
            Shape loc = super.modelToView(pos, a, b);
            Rectangle2D bounds = loc.getBounds2D();
            bounds.setRect(bounds.getX(), y, bounds.getWidth(), height);
            Intrinsics.checkNotNull((Object)bounds);
            return bounds;
        }

        @Override
        public int getStartOffset() {
            Comparable comparable;
            Iterator iterator = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)this.getViewCount()))), arg_0 -> ParagraphRow.getStartOffset$lambda$0(this, arg_0)).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                View it = (View)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(it.getStartOffset());
                while (iterator.hasNext()) {
                    View it2 = (View)iterator.next();
                    $i$a$-minOfOrNull-ParagraphViewEx$ParagraphRow$getStartOffset$2 = false;
                    Comparable comparable3 = Integer.valueOf(it2.getStartOffset());
                    if (comparable2.compareTo(comparable3) <= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n = (Integer)comparable;
            return n != null ? n : Integer.MAX_VALUE;
        }

        @Override
        public int getEndOffset() {
            Comparable comparable;
            Iterator iterator = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)this.getViewCount()))), arg_0 -> ParagraphRow.getEndOffset$lambda$0(this, arg_0)).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                View it = (View)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(it.getEndOffset());
                while (iterator.hasNext()) {
                    View it2 = (View)iterator.next();
                    $i$a$-maxOfOrNull-ParagraphViewEx$ParagraphRow$getEndOffset$2 = false;
                    Comparable comparable3 = Integer.valueOf(it2.getEndOffset());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n = (Integer)comparable;
            return n != null ? n : 0;
        }

        @Override
        protected void layoutMinorAxis(int targetSpan, int axis, @NotNull int[] offsets, @NotNull int[] spans) {
            Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
            Intrinsics.checkNotNullParameter((Object)spans, (String)"spans");
            this.baselineLayout(targetSpan, axis, offsets, spans);
        }

        @Override
        @NotNull
        protected SizeRequirements calculateMinorAxisRequirements(int axis, @Nullable SizeRequirements r) {
            SizeRequirements sizeRequirements = this.baselineRequirements(axis, r);
            Intrinsics.checkNotNullExpressionValue((Object)sizeRequirements, (String)"baselineRequirements(...)");
            return sizeRequirements;
        }

        @Override
        protected int getViewIndexAtPosition(int pos) {
            if (pos < this.getStartOffset() || pos >= this.getEndOffset()) {
                return -1;
            }
            for (int counter = this.getViewCount() - 1; -1 < counter; --counter) {
                View v = this.getView(counter);
                if (pos < v.getStartOffset() || pos >= v.getEndOffset()) continue;
                return counter;
            }
            return -1;
        }

        @Override
        protected short getLeftInset() {
            View view;
            View parentView = null;
            int adjustment = 0;
            View it = view = this.getParent();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            parentView = it;
            if (view != null && this == parentView.getView(0)) {
                adjustment = ParagraphViewEx.this.firstLineIndent;
            }
            return (short)(super.getLeftInset() + adjustment);
        }

        @Override
        protected short getTopInset() {
            return (short)(super.getTopInset() + this.getLineHeightCorrection() / 2);
        }

        @Override
        protected short getBottomInset() {
            return (short)(super.getBottomInset() + this.getLineHeightCorrection() / 2);
        }

        private final int getLineHeightCorrection() {
            float f;
            Float f2 = ParagraphViewEx.this.scaledLineHeight;
            if (f2 != null) {
                Float f3 = f2;
                ParagraphViewEx paragraphViewEx = ParagraphViewEx.this;
                float it = ((Number)f3).floatValue();
                boolean bl = false;
                Integer n = paragraphViewEx.fontLineHeight;
                if (n == null) {
                    return 0;
                }
                f = it * (float)n.intValue();
            } else {
                Float f4 = ParagraphViewEx.this.fixedLineHeight;
                if (f4 != null) {
                    f = f4.floatValue();
                } else {
                    return 0;
                }
            }
            float expectedLineHeight = f;
            SizeRequirements sizeRequirements = UtilsKt.getMinorRequest(this);
            int actualLineHeight = sizeRequirements != null ? sizeRequirements.preferred : 0;
            return (int)Math.max(0.0f, expectedLineHeight - (float)actualLineHeight);
        }

        private static final View getStartOffset$lambda$0(ParagraphRow this$0, int it) {
            return this$0.getView(it);
        }

        private static final View getEndOffset$lambda$0(ParagraphRow this$0, int it) {
            return this$0.getView(it);
        }
    }
}

