/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.jam;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.PairProcessor;

public final class SpringSecurityOAuth2ModelProvider
extends LocalAnnotationModelDependentModelsProvider {
    public static final String OATH_2_CLIENT_CONFIGURATION = "org.springframework.security.config.annotation.web.configuration.OAuth2ClientConfiguration";
    private static final String OATH_IMPORT_SELECTOR = "org.springframework.security.config.annotation.web.configuration.OAuth2ImportSelector";
    private static final String CLIENT_REGISTRATION = "org.springframework.security.oauth2.client.registration.ClientRegistration";
    private static final String EXCHANGE_FILTER_FUNCTION = "org.springframework.web.reactive.function.client.ExchangeFilterFunction";
    private static final String SECURITY_REACTOR_CONTEXT_CONFIGURATION = "org.springframework.security.config.annotation.web.configuration.SecurityReactorContextConfiguration";
    private static final Pair<String, String>[] configurations = new Pair[]{Pair.create((Object)"org.springframework.security.oauth2.client.registration.ClientRegistration", (Object)"org.springframework.security.config.annotation.web.configuration.OAuth2ClientConfiguration"), Pair.create((Object)"org.springframework.web.reactive.function.client.ExchangeFilterFunction", (Object)"org.springframework.security.config.annotation.web.configuration.SecurityReactorContextConfiguration")};

    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<? super LocalModel<?>, ? super LocalModelDependency> processor) {
        Module module = localAnnotationModel.getModule();
        if (OATH_IMPORT_SELECTOR.equals(localAnnotationModel.getConfig().getQualifiedName())) {
            for (Pair<String, String> pair : configurations) {
                LocalAnnotationModel model;
                PsiClass configuration;
                if (!JavaLibraryUtil.hasLibraryClass((Module)module, (String)((String)pair.first)) || (configuration = SpringCommonUtils.findLibraryClass((Module)module, (String)((String)pair.second))) == null || processor.process((Object)(model = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(configuration, module, localAnnotationModel.getActiveProfiles())), (Object)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)configuration))) continue;
                return false;
            }
        }
        return true;
    }
}

