/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.mvc.inlay;

import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.security.mvc.SpringSecuredUrlsUtils;
import com.intellij.spring.security.mvc.inlay.SpringSecurityMatchersInlayCollector;
import com.intellij.spring.security.mvc.inlay.SpringSecurityMatchersInlayProvider;
import com.intellij.spring.security.mvc.inlay.SpringSecurityXmlMatchersInlayProvider;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/security/mvc/inlay/SpringSecurityXmlMatchersInlayProvider;", "Lcom/intellij/spring/security/mvc/inlay/SpringSecurityMatchersInlayProvider;", "<init>", "()V", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "Lcom/intellij/codeInsight/hints/NoSettings;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "intellij.spring.security.mvc"})
public final class SpringSecurityXmlMatchersInlayProvider
extends SpringSecurityMatchersInlayProvider {
    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project) || file.getProject().isDefault()) {
            return null;
        }
        return (InlayHintsCollector)new SpringSecurityMatchersInlayCollector(editor){

            public boolean collect(PsiElement element, Editor editor, InlayHintsSink sink) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    if (!(element instanceof XmlAttribute) || !SpringSecuredUrlsUtils.XML_ATTRIBUTE_PATTERN.accepts((Object)element)) break block1;
                    Function0 mappings = () -> getCollectorFor.1.collect$lambda$0(element);
                    XmlAttributeValue xmlAttributeValue = ((XmlAttribute)element).getValueElement();
                    if (xmlAttributeValue != null && (xmlAttributeValue = xmlAttributeValue.getTextRange()) != null) {
                        int it = xmlAttributeValue.getStartOffset();
                        boolean bl = false;
                        sink.addInlineElement(it, false, this.buildPresentation(element, editor, (Function0<? extends Set<UrlMappingElement>>)mappings), false);
                    }
                }
                return true;
            }

            private static final Set collect$lambda$0(PsiElement $element) {
                return SpringSecuredUrlsUtils.getUrlMappings((XmlAttribute)$element);
            }
        };
    }
}

