/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gateway.eel;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.util.progress.RawProgressReporter;
import com.jetbrains.gateway.ssh.deploy.TransferProgressTracker;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/gateway/eel/ReporterProgressTrackerAdapter;", "Lcom/jetbrains/gateway/ssh/deploy/TransferProgressTracker;", "progressReporter", "Lcom/intellij/platform/util/progress/RawProgressReporter;", "progressScope", "Lkotlinx/coroutines/CoroutineScope;", "totalBytes", "", "<init>", "(Lcom/intellij/platform/util/progress/RawProgressReporter;Lkotlinx/coroutines/CoroutineScope;J)V", "isCancelled", "", "()Z", "updateProgress", "", "transferred", "speed", "(JLjava/lang/Long;)V", "intellij.gateway.eel"})
final class ReporterProgressTrackerAdapter
implements TransferProgressTracker {
    @NotNull
    private final RawProgressReporter progressReporter;
    @NotNull
    private final CoroutineScope progressScope;
    private final long totalBytes;

    public ReporterProgressTrackerAdapter(@NotNull RawProgressReporter progressReporter, @NotNull CoroutineScope progressScope, long totalBytes) {
        Intrinsics.checkNotNullParameter((Object)progressReporter, (String)"progressReporter");
        Intrinsics.checkNotNullParameter((Object)progressScope, (String)"progressScope");
        this.progressReporter = progressReporter;
        this.progressScope = progressScope;
        this.totalBytes = totalBytes;
    }

    public boolean isCancelled() {
        return JobKt.getJob((CoroutineContext)this.progressScope.getCoroutineContext()).isCancelled();
    }

    public void updateProgress(long transferred, @Nullable Long speed) {
        double fraction = (double)transferred / (double)this.totalBytes;
        String fractionPercentage = (int)(fraction * (double)100) + "%";
        int rankForTotalSize = StringUtil.rankForFileSize((long)this.totalBytes);
        String string = StringUtil.formatFileSize((long)this.totalBytes, (String)" ", (int)rankForTotalSize);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String totalBytesFormatted = string;
        String string2 = StringUtil.formatFileSize((long)transferred, (String)" ", (int)rankForTotalSize);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFileSize(...)");
        String transferredFormatted = string2;
        String progress = transferredFormatted + "/" + totalBytesFormatted;
        this.progressReporter.fraction(Double.valueOf(fraction));
        if (speed != null) {
            String speedFormatted = StringUtil.formatFileSize((long)speed) + "/s";
            this.progressReporter.details(fractionPercentage + " \u00b7 " + progress + " \u00b7 " + speedFormatted);
        } else {
            this.progressReporter.details(fractionPercentage + " \u00b7 " + progress);
        }
    }
}

