/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.run.ParametersHolder;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.ide.DataManager;
import com.intellij.jpa.engine.JpaConsoleAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jpa/engine/SessionVisibilityController;", "S", "Lcom/intellij/jpa/engine/JpaConsoleAdapter;", "Lcom/intellij/database/run/ParametersHolder$VisibilityController;", "session", "<init>", "(Lcom/intellij/jpa/engine/JpaConsoleAdapter;)V", "Lcom/intellij/jpa/engine/JpaConsoleAdapter;", "content", "Lcom/intellij/ui/content/Content;", "state", "", "isToggled", "show", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "project", "Lcom/intellij/openapi/project/Project;", "holder", "Lcom/intellij/database/run/ParametersHolder;", "hide", "", "initContent", "toggleParamContent", "intellij.javaee.jpa.impl"})
public final class SessionVisibilityController<S extends JpaConsoleAdapter<?>>
implements ParametersHolder.VisibilityController {
    @NotNull
    private final S session;
    @Nullable
    private Content content;
    private boolean state;

    public SessionVisibilityController(@NotNull S session) {
        Intrinsics.checkNotNullParameter(session, (String)"session");
        this.session = session;
    }

    public boolean isToggled() {
        return this.state;
    }

    @NotNull
    public Promise<Void> show(@NotNull Project project, @NotNull ParametersHolder holder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.initContent(holder);
        return this.toggleParamContent(true);
    }

    public void hide() {
        this.toggleParamContent(false);
    }

    private final void initContent(ParametersHolder holder) {
        if (this.content != null) {
            return;
        }
        this.content = ((JpaConsoleAdapter)((Object)this.session)).getView().getUi().createContent("Parameters", (JComponent)holder.getParamPanel(), DatabaseBundle.message((String)"jdbc.console.tab.title.parameters", (Object[])new Object[0]), IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Parameter), null);
        Disposable disposable = (Disposable)holder;
        Content content = this.content;
        Intrinsics.checkNotNull((Object)content);
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)content));
    }

    private final Promise<Void> toggleParamContent(boolean state) {
        if (state == this.state) {
            return Promises.resolvedPromise();
        }
        this.state = state;
        JpaConsoleAdapter.AdaptingView adaptingView = ((JpaConsoleAdapter)((Object)this.session)).getView();
        Intrinsics.checkNotNullExpressionValue(adaptingView, (String)"getView(...)");
        JpaConsoleAdapter.AdaptingView view = adaptingView;
        if (state) {
            Promise promise;
            RunnerLayoutUi runnerLayoutUi = view.getUi();
            Content content = this.content;
            Intrinsics.checkNotNull((Object)content);
            runnerLayoutUi.addContent(content, 0, PlaceInGrid.right, false);
            if (!view.isShowing()) {
                Promise promise2 = view.show(true, false);
                promise = promise2;
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"show(...)");
            } else {
                promise = Promises.resolvedPromise();
            }
            return promise;
        }
        if (this.content == null) {
            return Promises.resolvedPromise();
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)view.getUi().getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        RunnerContentUi runnerContentUi = (RunnerContentUi)RunnerContentUi.KEY.getData(dataContext);
        if (runnerContentUi != null) {
            runnerContentUi.saveUiState();
        }
        ContentManager contentManager = view.getUi().getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager manager = contentManager;
        Content content = this.content;
        Intrinsics.checkNotNull((Object)content);
        manager.removeContent(content, false);
        return Promises.resolvedPromise();
    }
}

