/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.jpa.ql.lang.inject.JpaSqlDialectDetector;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jpa/ql/FacetJpaSqlDialectDetector;", "Lcom/intellij/jpa/ql/lang/inject/JpaSqlDialectDetector;", "<init>", "()V", "detectSqlDialect", "Lcom/intellij/lang/Language;", "psiElement", "Lcom/intellij/psi/PsiElement;", "calculateDialect", "module", "Lcom/intellij/openapi/module/Module;", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nFacetJpaSqlDialectDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetJpaSqlDialectDetector.kt\ncom/intellij/jpa/ql/FacetJpaSqlDialectDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,38:1\n4253#2,12:39\n*S KotlinDebug\n*F\n+ 1 FacetJpaSqlDialectDetector.kt\ncom/intellij/jpa/ql/FacetJpaSqlDialectDetector\n*L\n21#1:39,12\n*E\n"})
public final class FacetJpaSqlDialectDetector
implements JpaSqlDialectDetector {
    @Nullable
    public Language detectSqlDialect(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        return this.calculateDialect(module2);
    }

    /*
     * WARNING - void declaration
     */
    private final Language calculateDialect(Module module) {
        void $this$filterIsInstanceTo$iv$iv;
        Facet[] facetArray = FacetManager.getInstance((Module)module).getAllFacets();
        Intrinsics.checkNotNullExpressionValue((Object)facetArray, (String)"getAllFacets(...)");
        Object[] $this$filterIsInstance$iv = facetArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PersistenceFacet)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List jpaFacets = (List)destination$iv$iv;
        if (jpaFacets.isEmpty()) {
            return null;
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
        DbPsiFacade dbPsiFacade2 = dbPsiFacade;
        DbDataSource result = null;
        for (PersistenceFacet facet : jpaFacets) {
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                String dataSourceId;
                DbDataSource dbDataSource;
                if (facet.getDataSourceId(unit) == null || (dbDataSource = dbPsiFacade2.findDataSource(dataSourceId)) == null || (dbDataSource = dbDataSource.getLanguage()) == null) continue;
                DbDataSource language = dbDataSource;
                if (result == null) {
                    result = language;
                    continue;
                }
                if (Intrinsics.areEqual((Object)result, (Object)language)) continue;
                return null;
            }
        }
        return result;
    }
}

