/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.editing.JavaScriptTypedHandler;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.inspections.JSStringConcatenationToES6TemplateInspection;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JSTemplateStringReplacingTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JSTemplateStringReplacingTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSTemplateStringReplacingTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JSTemplateStringReplacingTypedHandler.$$$reportNull$$$0(2);
        }
        if (c == '{' && JSEditorOptions.getInstance().AUTOMATICALLY_REPLACE_WITH_TEMPLATE_STRING_ON_TYPING) {
            boolean isStringLiteral;
            int caretOffset = editor.getCaretModel().getOffset();
            HighlighterIterator iterator = JavaScriptTypedHandler.createHighlighterIterator((Editor)editor, (int)(caretOffset - 1));
            IElementType tokenType = iterator.getTokenType();
            CharSequence documentContent = editor.getDocument().getCharsSequence();
            boolean isPreviousCharDollar = caretOffset - 2 >= 0 && documentContent.charAt(caretOffset - 2) == '$';
            boolean bl = isStringLiteral = tokenType == JSTokenTypes.STRING_LITERAL || tokenType == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL;
            if (isPreviousCharDollar && isStringLiteral) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiElement element = file.findElementAt(caretOffset);
                JSLiteralExpression literalExpression = Objects.requireNonNull((JSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSLiteralExpression.class));
                SmartPsiElementPointer literalExpressionPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)literalExpression, file);
                JSStringConcatenationToES6TemplateInspection.ReplaceWithTemplateFix templateFix = new JSStringConcatenationToES6TemplateInspection.ReplaceWithTemplateFix((JSExpression)literalExpression);
                if (templateFix.isAvailable(project, file, (PsiElement)literalExpression, (PsiElement)literalExpression)) {
                    String marker = "###__WS_INTERPOLATION_CARET_MARKER###";
                    String prefixedMarker = "\\{" + marker;
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)marker, (boolean)false, (int)0);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    JSLiteralExpression expression = Objects.requireNonNull((JSLiteralExpression)literalExpressionPointer.getElement());
                    templateFix.invoke(project, file, (PsiElement)expression, (PsiElement)expression);
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    documentContent = editor.getDocument().getCharsSequence();
                    int markerOffset = StringUtil.indexOf((CharSequence)documentContent, (CharSequence)prefixedMarker);
                    editor.getDocument().deleteString(markerOffset, markerOffset + prefixedMarker.length());
                    editor.getCaretModel().moveToOffset(markerOffset);
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"{}", (boolean)false, (int)1);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
                    if (result2 == null) {
                        JSTemplateStringReplacingTypedHandler.$$$reportNull$$$0(3);
                    }
                    return result2;
                }
            }
        }
        TypedHandlerDelegate.Result result3 = super.charTyped(c, project, editor, file);
        if (result3 == null) {
            JSTemplateStringReplacingTypedHandler.$$$reportNull$$$0(4);
        }
        return result3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JSTemplateStringReplacingTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JSTemplateStringReplacingTypedHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

