/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSFieldFromParameterAction
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myReferencedName;

    public CreateJSFieldFromParameterAction(@Nullable PsiElement element, String fieldName) {
        super(element);
        this.myReferencedName = fieldName;
    }

    @IntentionName
    @NotNull
    public String getText() {
        return CreateJSFieldFromParameterAction.getCreateFieldMessage(this.myReferencedName);
    }

    @NotNull
    @IntentionName
    public static String getCreateFieldMessage(String name) {
        String string = JavaScriptBundle.message((String)"javascript.create.field.intention.name", (Object[])new Object[]{name});
        if (string == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.create.variable.intention.family", (Object[])new Object[0]);
        if (string == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement psiElement, @NotNull PsiElement endElement) {
        if (project == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(3);
        }
        if (psiElement == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            return;
        }
        JSParameter parameter = (JSParameter)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSParameter.class);
        JSFunction containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, JSFunction.class);
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)containingFunction);
        if (parameter == null || containingFunction == null || dialectOptionHolder == null || !dialectOptionHolder.hasFeature(JSLanguageFeature.CLASSES)) {
            return;
        }
        BaseCreateFix.InsertPlaceInfo info = new BaseCreateFix.InsertPlaceInfo((PsiElement)containingFunction, containingFunction.getContainingFile(), true, true);
        if (info.anchor == null) {
            return;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            String typeString2 = CreateJSFieldFromParameterAction.getTypeString(parameter, dialectOptionHolder);
            this.startTemplate(project, psiFile, editor, psiElement, containingFunction, dialectOptionHolder, info, typeString2);
        } else {
            ReadAction.nonBlocking(() -> CreateJSFieldFromParameterAction.getTypeString(parameter, dialectOptionHolder)).expireWhen(() -> !psiElement.isValid()).finishOnUiThread(ModalityState.nonModal(), typeString -> this.startTemplate(project, psiFile, editor, psiElement, containingFunction, dialectOptionHolder, info, (String)typeString)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    @Nullable
    private static String getTypeString(@NotNull JSParameter parameter, @NotNull DialectOptionHolder dialectOptionHolder) {
        if (parameter == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(6);
        }
        if (dialectOptionHolder == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(7);
        }
        if (!dialectOptionHolder.hasFeature(JSLanguageFeature.TYPES)) {
            return null;
        }
        return (String)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)parameter, () -> {
            JSType type = parameter.getJSType();
            return type != null ? type.getTypeText(JSType.TypeTextFormat.CODE) : null;
        });
    }

    private void startTemplate(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull PsiElement psiElement, @NotNull JSFunction containingFunction, @NotNull DialectOptionHolder dialectOptionHolder, @NotNull BaseCreateFix.InsertPlaceInfo info, @Nullable String typeString) {
        if (project == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(10);
        }
        if (psiElement == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(11);
        }
        if (containingFunction == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(12);
        }
        if (dialectOptionHolder == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(13);
        }
        if (info == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(14);
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        if (info.addNewLineBefore) {
            template.addTextSegment("\n");
        }
        CreateJSFieldFromParameterAction.addAccessModifiers(template, dialectOptionHolder, JSResolveUtil.calculateStaticFromContext((PsiElement)psiElement));
        template.addTextSegment(JSClassUtils.isES6ClassImplementation((PsiElement)containingFunction) ? "" : "var ");
        template.addTextSegment(this.myReferencedName);
        if (!StringUtil.isEmpty((String)typeString)) {
            template.addTextSegment(":");
            template.addTextSegment(typeString);
        }
        template.addTextSegment(JSCodeStyleSettings.getSemicolon((PsiElement)containingFunction));
        if (info.toInsertNewLineAfter) {
            template.addTextSegment("\n");
        }
        int offset = info.anchor.getTextRange().getStartOffset();
        BaseCreateFix.navigate((Project)project, (Editor)editor, (int)offset, (VirtualFile)file.getVirtualFile());
        templateManager.startTemplate(editor, template);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void addAccessModifiers(Template template, DialectOptionHolder dialectOptionHolder, boolean isStatic) {
        if (dialectOptionHolder.isTypeScript || dialectOptionHolder.isECMA4) {
            template.addTextSegment("private ");
        }
        if (isStatic) {
            template.addTextSegment("static ");
        }
    }

    public boolean availableInBatchMode() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/CreateJSFieldFromParameterAction";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectOptionHolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFunction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateFieldMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/CreateJSFieldFromParameterAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

