/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.intentions.destructuring.JSDestructuringPropagationIntentionBase;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropagateToDestructuringIntention
extends JSDestructuringPropagationIntentionBase {
    @Override
    @NotNull
    @IntentionName
    protected String getDescription() {
        String string = JavaScriptBundle.message((String)"refactoring.destructuring.vars.intention.propagate", (Object[])new Object[0]);
        if (string == null) {
            JSPropagateToDestructuringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSPropagateToDestructuringIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSPropagateToDestructuringIntention.$$$reportNull$$$0(2);
        }
        element = JSPropagateToDestructuringIntention.adjustElement(element);
        this.invokeForVariable(project, editor, JSPropagateToDestructuringIntention.findVariable(element));
    }

    @NotNull
    private static JSVariable findVariable(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSPropagateToDestructuringIntention.$$$reportNull$$$0(3);
        }
        if (JSPropagateToDestructuringIntention.isAcceptableVariable(parent = element.getParent())) {
            JSVariable jSVariable = (JSVariable)parent;
            if (jSVariable == null) {
                JSPropagateToDestructuringIntention.$$$reportNull$$$0(4);
            }
            return jSVariable;
        }
        JSQualifiedExpression expression = JSPropagateToDestructuringIntention.findExpression(element, e -> JSPropagateToDestructuringIntention.findIndexerOrPropertyAccess(e));
        assert (expression != null);
        JSExpression expressionQualifier = expression.getQualifier();
        JSReferenceExpression qualifierReference = (JSReferenceExpression)ObjectUtils.tryCast((Object)(expressionQualifier == null && expression.getParent() instanceof JSDestructuringElement ? expression : expressionQualifier), JSReferenceExpression.class);
        assert (qualifierReference != null);
        JSVariable targetVar = (JSVariable)qualifierReference.resolve();
        assert (targetVar != null);
        JSVariable jSVariable = targetVar;
        if (jSVariable == null) {
            JSPropagateToDestructuringIntention.$$$reportNull$$$0(5);
        }
        return jSVariable;
    }

    @Override
    protected boolean isAvailableOnElement(@NotNull PsiElement element, Project project, Editor editor) {
        if (element == null) {
            JSPropagateToDestructuringIntention.$$$reportNull$$$0(6);
        }
        return JSPropagateToDestructuringIntention.doCheckAvailableOnExpression(JSPropagateToDestructuringIntention.findExpression(element = JSPropagateToDestructuringIntention.adjustElement(element), e -> JSPropagateToDestructuringIntention.findIndexerOrPropertyAccess(e))) || JSPropagateToDestructuringIntention.doCheckAvailableOnVariable(element, project, editor);
    }

    @NotNull
    private static PsiElement adjustElement(@NotNull PsiElement element) {
        PsiElement leaf;
        IElementType elementType;
        if (element == null) {
            JSPropagateToDestructuringIntention.$$$reportNull$$$0(7);
        }
        if ((elementType = PsiUtilCore.getElementType((PsiElement)element)) == JSTokenTypes.RPAR || elementType == JSTokenTypes.RBRACE || elementType == JSTokenTypes.RBRACKET || elementType == JSTokenTypes.EQ || elementType == JSTokenTypes.COMMA) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)element);
            if (leaf == null) {
                PsiElement psiElement = element;
                if (psiElement == null) {
                    JSPropagateToDestructuringIntention.$$$reportNull$$$0(8);
                }
                return psiElement;
            }
            element = leaf;
        }
        while (element instanceof PsiWhiteSpace) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)element);
            if (leaf == null) {
                PsiElement psiElement = element;
                if (psiElement == null) {
                    JSPropagateToDestructuringIntention.$$$reportNull$$$0(9);
                }
                return psiElement;
            }
            if (!(leaf instanceof PsiWhiteSpace)) {
                PsiElement psiElement = leaf;
                if (psiElement == null) {
                    JSPropagateToDestructuringIntention.$$$reportNull$$$0(10);
                }
                return psiElement;
            }
            element = leaf;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSPropagateToDestructuringIntention.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    private static boolean doCheckAvailableOnVariable(PsiElement element, Project project, Editor editor) {
        PsiElement parent = element.getParent();
        if (!JSPropagateToDestructuringIntention.isAcceptableVariable(parent)) {
            return false;
        }
        Collection references = ReferencesSearch.search((PsiElement)parent, (SearchScope)parent.getUseScope().intersectWith((SearchScope)GlobalSearchScope.fileScope((PsiFile)parent.getContainingFile()))).findAll();
        return JSPropagateToDestructuringIntention.validateRefs(references, (MultiMap<JSDestructuringPropagationIntentionBase.Key, JSDestructuringPropagationIntentionBase.RefUsage>)MultiMap.create(), project, editor, false, element) != JSDestructuringPropagationIntentionBase.Kind.None;
    }

    @Nullable
    private static JSQualifiedExpression findIndexerOrPropertyAccess(@NotNull PsiElement e) {
        JSIndexedPropertyAccessExpression indexer;
        if (e == null) {
            JSPropagateToDestructuringIntention.$$$reportNull$$$0(12);
        }
        if ((indexer = JSPropagateToDestructuringIntention.findIndexer(e)) != null) {
            return indexer;
        }
        JSReferenceExpression reference = JSPropagateToDestructuringIntention.findReference(e);
        if (reference != null) {
            return reference;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)e, JSReferenceExpression.class, (boolean)false);
        if (referenceExpression == null) {
            return null;
        }
        PsiElement parent = referenceExpression.getParent();
        JSDestructuringElement element = (JSDestructuringElement)ObjectUtils.tryCast((Object)parent, JSDestructuringElement.class);
        if (element != null && element.getParent() instanceof JSVarStatement) {
            return referenceExpression;
        }
        if (parent instanceof JSQualifiedExpression) {
            if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess(parent) == ReadWriteAccessDetector.Access.Read) {
                return (JSQualifiedExpression)parent;
            }
        } else if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)referenceExpression) == ReadWriteAccessDetector.Access.Read) {
            return referenceExpression;
        }
        return null;
    }

    private static boolean doCheckAvailableOnExpression(@Nullable JSQualifiedExpression expression) {
        JSQualifiedExpression qualifier;
        if (expression == null) {
            return false;
        }
        PsiElement expressionParent = expression.getParent();
        Object object = qualifier = expressionParent instanceof JSDestructuringElement ? expression : expression.getQualifier();
        if (!(qualifier instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement potentialVariable = ((JSReferenceExpression)qualifier).resolve();
        if (potentialVariable == null || expression.getContainingFile() != potentialVariable.getContainingFile()) {
            return false;
        }
        return JSPropagateToDestructuringIntention.isAcceptableVariable(potentialVariable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/destructuring/JSPropagateToDestructuringIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSPropagateToDestructuringIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIndexerOrPropertyAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7, 12 -> new IllegalArgumentException(string);
        };
    }
}

