/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.IntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.ui.JSEditorComboBox;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public abstract class JSBaseIntroduceDialog<T extends IntroducedEntityInfoProvider>
extends DialogWrapper
implements BaseIntroduceSettings {
    protected final Project myProject;
    protected final T entityInfoProvider;
    private final Alarm myAlarm = new Alarm();

    protected JSBaseIntroduceDialog(Project project, T _typeProvider, String titleKey) {
        super(project, true);
        this.myProject = project;
        this.entityInfoProvider = _typeProvider;
        this.setTitle(JavaScriptBundle.message((String)titleKey, (Object[])new Object[0]));
    }

    protected void doInit() {
        JCheckBox replaceAllCheckBox = this.getReplaceAllCheckBox();
        if (replaceAllCheckBox != null) {
            int occurrenceCount = this.entityInfoProvider.getOccurrenceCount();
            if (occurrenceCount > 1) {
                replaceAllCheckBox.setText(JavaScriptBundle.message((String)"javascript.introduce.variable.replace.all.occurrences", (Object[])new Object[]{occurrenceCount}));
            } else {
                replaceAllCheckBox.setVisible(false);
            }
            replaceAllCheckBox.setFocusable(false);
        }
        this.getNameField().addDataChangedListener(() -> this.initiateValidation());
        this.getNameLabel().setLabelFor(this.getNameField().getComponent());
        JComboBox typeField = this.getVarTypeField();
        final ArrayList<String> possibleTypes = new ArrayList<String>();
        String type = this.entityInfoProvider.evaluateType();
        PsiFile containingFile = this.entityInfoProvider.getContainingFile();
        if (type != null) {
            String qName = JSResolveUtil.getQualifiedTypeName((String)JSImportHandlingUtil.resolveTypeName((String)type, (PsiElement)containingFile));
            JSResolveUtil.processHierarchy((String)qName, (PsiFile)containingFile, (Processor)new Processor<JSClass>(this){
                final Set<String> visited = new HashSet<String>();
                int firstInterfaceOrObjectIndex = -1;

                public boolean process(JSClass jsClass) {
                    String qName = JSResolveUtil.getQualifiedTypeName((String)jsClass.getQualifiedName());
                    if (this.visited.add(qName)) {
                        if (!jsClass.isInterface() && !"Object".equals(qName)) {
                            if (this.firstInterfaceOrObjectIndex == -1) {
                                possibleTypes.add(qName);
                            } else {
                                possibleTypes.add(this.firstInterfaceOrObjectIndex++, qName);
                            }
                        } else {
                            if (this.firstInterfaceOrObjectIndex == -1) {
                                this.firstInterfaceOrObjectIndex = possibleTypes.size();
                            }
                            possibleTypes.add(qName);
                        }
                    }
                    return true;
                }
            }, (boolean)true);
            if (possibleTypes.isEmpty()) {
                if ("*".equals(type)) {
                    typeField.setEditable(true);
                }
                possibleTypes.add(type);
            }
        }
        typeField.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(possibleTypes)));
        typeField.setRenderer(SimpleListCellRenderer.create((String)"", JSLookupUtilImpl::getShortName));
        this.init();
        SwingUtilities.invokeLater(() -> this.initiateValidation());
    }

    protected abstract NameSuggestionsField getNameField();

    protected abstract JLabel getNameLabel();

    protected abstract JPanel getPanel();

    protected abstract JCheckBox getReplaceAllCheckBox();

    protected void initiateValidation() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.checkIsValid(), 100, ModalityState.current());
    }

    protected void checkIsValid() {
        String nameCandidate = this.getNameField().getEnteredName();
        this.setOKActionEnabled(!nameCandidate.isEmpty() && this.isValidName(nameCandidate, (PsiElement)this.entityInfoProvider.getContainingFile()));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getNameField().getFocusableComponent();
    }

    protected JComponent createCenterPanel() {
        return this.getPanel();
    }

    public void doSilentOK() {
        this.doOKAction();
    }

    protected void doOKAction() {
        String name = this.getVariableName();
        if (name.isEmpty() || !this.isValidName(name, (PsiElement)this.entityInfoProvider.getContainingFile())) {
            Messages.showErrorDialog((Project)this.myProject, (String)JavaScriptBundle.message((String)"javascript.introduce.variable.invalid.name", (Object[])new Object[0]), (String)JavaScriptBundle.message((String)"javascript.introduce.variable.title", (Object[])new Object[0]));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getNameField().getFocusableComponent(), true));
            return;
        }
        if (!this.entityInfoProvider.checkConflicts(name)) {
            return;
        }
        super.doOKAction();
    }

    @Override
    public boolean isReplaceAllOccurrences() {
        JCheckBox replaceAllCheckBox = this.getReplaceAllCheckBox();
        return replaceAllCheckBox != null && replaceAllCheckBox.isSelected();
    }

    @Override
    public String getVariableName() {
        return this.getNameField().getEnteredName().trim();
    }

    @Override
    public String getVariableType() {
        JComboBox varTypeField = this.getVarTypeField();
        if (varTypeField.isEditable()) {
            return (String)varTypeField.getEditor().getItem();
        }
        return (String)varTypeField.getSelectedItem();
    }

    protected boolean isValidName(String name, PsiElement context) {
        return JSNamesValidation.isIdentifier((String)name, (PsiElement)context);
    }

    public abstract JComboBox getVarTypeField();

    protected NameSuggestionsField configureNameField() {
        final String[] suggestions = this.entityInfoProvider.suggestCandidateNames();
        return new NameSuggestionsField(suggestions, this.myProject, (FileType)JavaScriptSupportLoader.JAVASCRIPT){

            public void addNotify() {
                Editor editor;
                super.addNotify();
                if (suggestions.length <= 1 && (editor = this.getEditor()) != null) {
                    editor.setBorder((Border)BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
                }
            }
        };
    }

    protected EditorComboBox configureTypeField() {
        PsiFile containingFile = this.entityInfoProvider.getContainingFile();
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement((PsiElement)containingFile);
        JSExpressionCodeFragment codeFragment = JSElementFactory.createExpressionCodeFragment((Project)this.myProject, (CharSequence)"", (PsiElement)containingFile, (JSLanguageDialect)languageDialect, (GlobalSearchScope)containingFile.getResolveScope(), (JSElementFactory.TopLevelCompletion)JSElementFactory.TopLevelCompletion.YES, (JavaScriptParserBase.ForceContext)JavaScriptParserBase.ForceContext.Type);
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)codeFragment);
        return new JSEditorComboBox(document, this.myProject);
    }
}

