/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/validation/SetJSDocElementVisibilityFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "myNewVisibility", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList$AccessType;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList$AccessType;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "getText", "", "getFamilyName", "intellij.javascript.codeinsight"})
public final class SetJSDocElementVisibilityFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final JSAttributeList.AccessType myNewVisibility;

    public SetJSDocElementVisibilityFix(@NotNull PsiElement element, @NotNull JSAttributeList.AccessType myNewVisibility) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)myNewVisibility, (String)"myNewVisibility");
        super(element);
        this.myNewVisibility = myNewVisibility;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)startElement);
        if (!(comment instanceof JSDocComment)) {
            return;
        }
        JSDocTag[] jSDocTagArray = ((JSDocComment)comment).getTags();
        Intrinsics.checkNotNullExpressionValue((Object)jSDocTagArray, (String)"getTags(...)");
        for (JSDocTag tag : jSDocTagArray) {
            String tagName;
            Intrinsics.checkNotNullExpressionValue((Object)tag.getName(), (String)"getName(...)");
            if (!Intrinsics.areEqual((Object)"private", (Object)tagName) && !Intrinsics.areEqual((Object)"protected", (Object)tagName) && !Intrinsics.areEqual((Object)"public", (Object)tagName)) continue;
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(((JSDocComment)comment).getContainingFile());
            if (document != null) {
                String visibilityTag = JSVisibilityUtil.getJSDocVisibilityKeyword((JSAttributeList.AccessType)this.myNewVisibility);
                if (visibilityTag != null) {
                    document.replaceString(tag.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset(), (CharSequence)("@" + visibilityTag));
                } else {
                    document.deleteString(tag.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset());
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            }
            return;
        }
    }

    @NotNull
    public String getText() {
        PsiElement element = this.getStartElement();
        String name = element instanceof JSNamedElement ? ((JSNamedElement)element).getName() : "element";
        String visibility = JSVisibilityUtil.getJSDocVisibilityKeyword((JSAttributeList.AccessType)this.myNewVisibility);
        if (visibility == null) {
            visibility = "default";
        }
        Object[] objectArray = new Object[]{name, visibility};
        String string = JavaScriptBundle.message((String)"javascript.fix.set.element.visibility", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.fix.visibility.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

