/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.typescript.inspections.TypeScriptConfigEnableOptionFix;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTokenType;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeScriptMissingConfigOptionInspection
extends JSInspection {
    public boolean isCoveredByTypeScriptServiceHighlighting() {
        return true;
    }

    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptMissingConfigOptionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            TypeScriptMissingConfigOptionInspection.$$$reportNull$$$0(1);
        }
        final TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)holder.getFile());
        return new JSElementVisitor(){

            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(node instanceof JSXXmlLiteralExpressionImpl)) {
                    return;
                }
                TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile((PsiFile)holder.getFile());
                if (config == null) {
                    return;
                }
                if (!holder.isOnTheFly() && provider.skipErrors((PsiElement)node)) {
                    return;
                }
                if (config.jsx() == null) {
                    ProblemHighlightType highlightType = this.getProblemHighlightType((PsiElement)node);
                    List<TypeScriptConfigEnableOptionFix> fixes = Collections.singletonList(new TypeScriptConfigEnableOptionFix("jsx", JsonSchemaType._string, "react"));
                    TextRange from = this.getErrorRange(node);
                    holder.registerProblem((PsiElement)node, TypeScriptMissingConfigOptionInspection.this.getDisplayName(), highlightType, from, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }

            @NotNull
            public TextRange getErrorRange(@NotNull JSLiteralExpression node) {
                ASTNode astNode;
                ASTNode closeTag;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                int endRange = (closeTag = (astNode = node.getNode()).findChildByType(XmlTokenType.XML_TAG_END)) == null ? astNode.getTextLength() : closeTag.getPsi().getStartOffsetInParent() + 1;
                TextRange textRange = TextRange.from((int)0, (int)endRange);
                if (textRange == null) {
                    1.$$$reportNull$$$0(2);
                }
                return textRange;
            }

            @NotNull
            private ProblemHighlightType getProblemHighlightType(@NotNull PsiElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                ProblemHighlightType problemHighlightType = provider.skipErrors(node) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (problemHighlightType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return problemHighlightType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptMissingConfigOptionInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptMissingConfigOptionInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getErrorRange";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProblemHighlightType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitJSLiteralExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getErrorRange";
                        break;
                    }
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getProblemHighlightType";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 4 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/typescript/inspections/TypeScriptMissingConfigOptionInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

