/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.javascript.typeEngine.JSTypeEngineUtils;
import com.intellij.javascript.types.TSBooleanLiteralType;
import com.intellij.javascript.types.TSBooleanType;
import com.intellij.javascript.types.TSType;
import com.intellij.javascript.types.TSUnionOrIntersectionType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import com.sixrr.inspectjs.utils.ConditionalUtils;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\n\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/sixrr/inspectjs/utils/BoolUtils;", "", "<init>", "()V", "isNegation", "", "exp", "Lcom/intellij/lang/javascript/psi/JSExpression;", "isTrueLiteral", "expression", "isFalseLiteral", "getNegatedExpressionText", "", "condition", "getNegated", "isBoolean", "allowNullable", "isStrictBooleanType", "Lcom/intellij/javascript/types/TSType;", "intellij.javascript.codeinsight"})
@SourceDebugExtension(value={"SMAP\nBoolUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoolUtils.kt\ncom/sixrr/inspectjs/utils/BoolUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1786#2,3:108\n*S KotlinDebug\n*F\n+ 1 BoolUtils.kt\ncom/sixrr/inspectjs/utils/BoolUtils\n*L\n104#1:108,3\n*E\n"})
public final class BoolUtils {
    @NotNull
    public static final BoolUtils INSTANCE = new BoolUtils();

    private BoolUtils() {
    }

    @JvmStatic
    public static final boolean isNegation(@NotNull JSExpression exp) {
        Intrinsics.checkNotNullParameter((Object)exp, (String)"exp");
        return exp instanceof JSPrefixExpression && ((JSPrefixExpression)exp).getOperationSign() == JSTokenTypes.EXCL;
    }

    @JvmStatic
    @Contract(value="null -> false")
    public static final boolean isTrueLiteral(@Nullable JSExpression expression) {
        return ConditionalUtils.isLiteralWithKind(expression, JSLiteralExpressionKind.TRUE);
    }

    @JvmStatic
    @Contract(value="null -> false")
    public static final boolean isFalseLiteral(@Nullable JSExpression expression) {
        return ConditionalUtils.isLiteralWithKind(expression, JSLiteralExpressionKind.FALSE);
    }

    @JvmStatic
    @NotNull
    public static final String getNegatedExpressionText(@NotNull JSExpression condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        if (condition instanceof JSParenthesizedExpression) {
            JSExpression contentExpression;
            JSExpression jSExpression = contentExpression = ((JSParenthesizedExpression)condition).getInnerExpression();
            Intrinsics.checkNotNull((Object)jSExpression);
            return "(" + BoolUtils.getNegatedExpressionText(jSExpression) + ")";
        }
        if (BoolUtils.isNegation(condition)) {
            JSExpression negated = INSTANCE.getNegated(condition);
            String string = negated.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
        if (ComparisonUtils.isComparison(condition)) {
            IElementType sign;
            JSBinaryExpression binaryExpression = (JSBinaryExpression)condition;
            IElementType iElementType = sign = binaryExpression.getOperationSign();
            Intrinsics.checkNotNull((Object)iElementType);
            String negatedComparison = ComparisonUtils.getNegatedComparison(iElementType);
            JSExpression lhs = binaryExpression.getLOperand();
            JSExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                JSExpression jSExpression = lhs;
                Intrinsics.checkNotNull((Object)jSExpression);
                return jSExpression.getText() + negatedComparison;
            }
            JSExpression jSExpression = lhs;
            Intrinsics.checkNotNull((Object)jSExpression);
            return jSExpression.getText() + negatedComparison + rhs.getText();
        }
        if (JSParenthesesUtils.getPrecedence((JSExpression)condition) > 3) {
            return "!(" + condition.getText() + ")";
        }
        return "!" + condition.getText();
    }

    private final JSExpression getNegated(JSExpression exp) {
        Intrinsics.checkNotNull((Object)exp, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSPrefixExpression");
        JSPrefixExpression prefixExp = (JSPrefixExpression)exp;
        JSExpression operand = prefixExp.getExpression();
        JSExpression jSExpression = JSParenthesesUtils.stripParentheses((JSExpression)operand);
        Intrinsics.checkNotNull((Object)jSExpression);
        return jSExpression;
    }

    @JvmStatic
    public static final boolean isBoolean(@NotNull JSExpression expression, boolean allowNullable) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        JSExpression expression2 = expression;
        if (expression2 instanceof JSParenthesizedExpression) {
            JSExpression jSExpression = JSUtils.unparenthesize((JSExpression)expression2);
            if (jSExpression == null) {
                return false;
            }
            expression2 = jSExpression;
        }
        boolean isBooleanExpression = false;
        if (expression2 instanceof JSBinaryExpression) {
            IElementType sign = ((JSBinaryExpression)expression2).getOperationSign();
            boolean bl = isBooleanExpression = sign != null && (JSTokenTypes.RELATIONAL_OPERATIONS.contains(sign) || JSTokenTypes.EQUALITY_OPERATIONS.contains(sign));
        }
        if (isBooleanExpression) {
            return true;
        }
        if (allowNullable || DialectDetector.isActionScript((PsiElement)((PsiElement)expression2)) || DialectDetector.isTypeScript((PsiElement)((PsiElement)expression2)) && TypeScriptConfigUtil.strictNullChecks((PsiElement)((PsiElement)expression2))) {
            TSType type = JSTypeEngineUtils.INSTANCE.getTSType((PsiElement)expression2);
            return type != null && INSTANCE.isStrictBooleanType(type);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isStrictBooleanType(TSType $this$isStrictBooleanType) {
        TSType it;
        if ($this$isStrictBooleanType instanceof TSBooleanType) return true;
        if ($this$isStrictBooleanType instanceof TSBooleanLiteralType) return true;
        if (!($this$isStrictBooleanType instanceof TSUnionOrIntersectionType)) return false;
        Iterable $this$all$iv = ((TSUnionOrIntersectionType)$this$isStrictBooleanType).getTypes();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (TSType)element$iv;
            boolean bl = false;
        } while (INSTANCE.isStrictBooleanType(it));
        return false;
    }
}

