/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class ImportChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiClass>> mySingleImportedClasses;
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiField>> mySingleImportedFields;

    ImportChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            ImportChecker.$$$reportNull$$$0(0);
        }
        this.mySingleImportedClasses = new HashMap<String, Pair<PsiImportStaticReferenceElement, PsiClass>>();
        this.mySingleImportedFields = new HashMap<String, Pair<PsiImportStaticReferenceElement, PsiField>>();
        this.myVisitor = visitor;
    }

    void checkStaticOnDemandImportResolvesToClass(@NotNull PsiImportStaticStatement statement) {
        PsiElement resolve;
        PsiJavaCodeReferenceElement ref;
        if (statement == null) {
            ImportChecker.$$$reportNull$$$0(1);
        }
        if (statement.isOnDemand() && statement.resolveTargetClass() == null && (ref = statement.getImportReference()) != null && (resolve = ref.resolve()) != null) {
            this.myVisitor.report(JavaErrorKinds.IMPORT_STATIC_ON_DEMAND_RESOLVES_TO_CLASS.create(ref));
        }
    }

    void checkImportStaticReferenceElement(@NotNull PsiImportStaticReferenceElement ref) {
        if (ref == null) {
            ImportChecker.$$$reportNull$$$0(2);
        }
        String refName = ref.getReferenceName();
        JavaResolveResult[] results = ref.multiResolve(false);
        PsiElement referenceNameElement = ref.getReferenceNameElement();
        if (results.length == 0) {
            assert (referenceNameElement != null) : ref;
            if (this.myVisitor.isIncompleteModel() && ref.getClassReference().resolve() == null) {
                this.myVisitor.report(JavaErrorKinds.REFERENCE_PENDING.create(referenceNameElement));
            } else {
                this.myVisitor.report(JavaErrorKinds.REFERENCE_UNRESOLVED.create((PsiJavaCodeReferenceElement)ref));
            }
        } else {
            PsiManager manager = ref.getManager();
            for (JavaResolveResult result : results) {
                JavaErrorKind.Simple<PsiJavaCodeReferenceElement> kind;
                Pair<PsiImportStaticReferenceElement, PsiClass> imported;
                PsiElement element = result.getElement();
                if (element instanceof PsiClass) {
                    imported = this.mySingleImportedClasses.get(refName);
                    PsiClass aClass = (PsiClass)Pair.getSecond(imported);
                    if (aClass != null && !manager.areElementsEquivalent((PsiElement)aClass, element)) {
                        if (imported.first == null) {
                            this.myVisitor.report(JavaErrorKinds.IMPORT_SINGLE_CLASS_CONFLICT.create((PsiJavaCodeReferenceElement)ref, aClass));
                        } else {
                            kind = ((PsiImportStaticReferenceElement)imported.first).equals((Object)ref) ? JavaErrorKinds.IMPORT_SINGLE_STATIC_CLASS_AMBIGUOUS : JavaErrorKinds.IMPORT_SINGLE_STATIC_CLASS_ALREADY_DEFINED;
                            this.myVisitor.report(kind.create((PsiJavaCodeReferenceElement)ref));
                        }
                    }
                    this.mySingleImportedClasses.put(refName, (Pair<PsiImportStaticReferenceElement, PsiClass>)Pair.create((Object)ref, (Object)((PsiClass)element)));
                    continue;
                }
                if (!(element instanceof PsiField)) continue;
                imported = this.mySingleImportedFields.get(refName);
                PsiField field = (PsiField)Pair.getSecond(imported);
                if (field != null && !manager.areElementsEquivalent((PsiElement)field, element)) {
                    kind = ((PsiImportStaticReferenceElement)imported.first).equals((Object)ref) ? JavaErrorKinds.IMPORT_SINGLE_STATIC_FIELD_AMBIGUOUS : JavaErrorKinds.IMPORT_SINGLE_STATIC_FIELD_ALREADY_DEFINED;
                    this.myVisitor.report(kind.create((PsiJavaCodeReferenceElement)ref));
                }
                this.mySingleImportedFields.put(refName, (Pair<PsiImportStaticReferenceElement, PsiField>)Pair.create((Object)ref, (Object)((PsiField)element)));
            }
        }
        if (!this.myVisitor.hasErrorResults() && results.length == 1) {
            this.myVisitor.myExpressionChecker.checkReference((PsiJavaCodeReferenceElement)ref, results[0]);
            if (!this.myVisitor.hasErrorResults()) {
                PsiClass containingClass;
                PsiElement element = results[0].getElement();
                if (element instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)element;
                    v0 = psiMethod.getContainingClass();
                } else {
                    v0 = containingClass = null;
                }
                if (containingClass != null && containingClass.isInterface()) {
                    this.myVisitor.myExpressionChecker.checkStaticInterfaceCallQualifier((PsiJavaCodeReferenceElement)ref, results[0], containingClass);
                }
            }
        }
    }

    void checkSingleImportClassConflict(@NotNull PsiImportStatement statement) {
        if (statement == null) {
            ImportChecker.$$$reportNull$$$0(3);
        }
        if (statement.isOnDemand()) {
            return;
        }
        PsiElement element = statement.resolve();
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            String name = psiClass.getName();
            Pair<PsiImportStaticReferenceElement, PsiClass> imported = this.mySingleImportedClasses.get(name);
            PsiClass importedClass = (PsiClass)Pair.getSecond(imported);
            if (importedClass != null && !this.myVisitor.file().getManager().areElementsEquivalent((PsiElement)importedClass, element)) {
                PsiJavaCodeReferenceElement reference = statement.getImportReference();
                if (reference != null) {
                    this.myVisitor.report(JavaErrorKinds.IMPORT_SINGLE_CLASS_CONFLICT.create(reference, importedClass));
                }
                return;
            }
            this.mySingleImportedClasses.put(name, (Pair<PsiImportStaticReferenceElement, PsiClass>)Pair.pair(null, (Object)psiClass));
        }
    }

    void checkExtraSemicolonBetweenImportStatements(@NotNull PsiJavaToken token, IElementType type) {
        if (token == null) {
            ImportChecker.$$$reportNull$$$0(4);
        }
        if (type == JavaTokenType.SEMICOLON && this.myVisitor.languageLevel().isAtLeast(LanguageLevel.JDK_21) && PsiUtil.isFollowedByImport((PsiElement)token)) {
            this.myVisitor.report(JavaErrorKinds.IMPORT_LIST_EXTRA_SEMICOLON.create(token));
        }
    }

    void checkImportModuleInModuleInfo(@NotNull PsiImportModuleStatement statement) {
        if (statement == null) {
            ImportChecker.$$$reportNull$$$0(5);
        }
        if (PsiUtil.isModuleFile((PsiFile)statement.getContainingFile())) {
            this.myVisitor.report(JavaErrorKinds.IMPORT_MODULE_NOT_ALLOWED.create(statement));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/ImportChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticOnDemandImportResolvesToClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkImportStaticReferenceElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSingleImportClassConflict";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExtraSemicolonBetweenImportStatements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkImportModuleInModuleInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

