/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.core.JavaPsiBundle;
import com.intellij.java.codeserver.core.JavaPsiVariableUtil;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatementBase;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StatementChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;

    StatementChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            StatementChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void checkLabelWithoutStatement(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            StatementChecker.$$$reportNull$$$0(1);
        }
        if (statement.getStatement() == null) {
            this.myVisitor.report(JavaErrorKinds.LABEL_WITHOUT_STATEMENT.create(statement));
        }
    }

    void checkLabelAlreadyInUse(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            StatementChecker.$$$reportNull$$$0(2);
        }
        PsiIdentifier identifier = statement.getLabelIdentifier();
        String text = identifier.getText();
        for (PsiLabeledStatement element = statement; element != null && !(element instanceof PsiMethod) && !(element instanceof PsiClass); element = element.getParent()) {
            if (!(element instanceof PsiLabeledStatement)) continue;
            PsiLabeledStatement labeledStatement = element;
            if (element == statement || !Objects.equals(labeledStatement.getLabelIdentifier().getText(), text)) continue;
            this.myVisitor.report(JavaErrorKinds.LABEL_DUPLICATE.create(statement));
            return;
        }
    }

    void checkForeachExpressionTypeIsIterable(@NotNull PsiExpression expression) {
        if (expression == null) {
            StatementChecker.$$$reportNull$$$0(3);
        }
        if (!StatementChecker.shouldReportForeachNotApplicable(expression)) {
            return;
        }
        if (expression.getType() == null) {
            return;
        }
        PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)expression);
        if (itemType == null) {
            this.myVisitor.report(JavaErrorKinds.FOREACH_NOT_APPLICABLE.create(expression));
        }
    }

    private static boolean shouldReportForeachNotApplicable(@NotNull PsiExpression expression) {
        PsiElement psiElement;
        if (expression == null) {
            StatementChecker.$$$reportNull$$$0(4);
        }
        if (!((psiElement = expression.getParent()) instanceof PsiForeachStatementBase)) {
            return false;
        }
        PsiForeachStatementBase parentForEach = (PsiForeachStatementBase)psiElement;
        PsiExpression iteratedValue = parentForEach.getIteratedValue();
        if (iteratedValue != expression) {
            return false;
        }
        PsiType iteratedValueType = iteratedValue.getType();
        return iteratedValueType == null || !PsiTypesUtil.hasUnresolvedComponents((PsiType)iteratedValueType);
    }

    void checkCatchTypeIsDisjoint(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            StatementChecker.$$$reportNull$$$0(5);
        }
        if (!(parameter.getType() instanceof PsiDisjunctionType)) {
            return;
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
        int size = typeElements.size();
        block0: for (int i = 0; i < size; ++i) {
            PsiClass class1 = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiTypeElement)typeElements.get(i)).getType());
            if (class1 == null) continue;
            for (int j = i + 1; j < size; ++j) {
                PsiClass class2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiTypeElement)typeElements.get(j)).getType());
                if (class2 == null) continue;
                boolean sub = InheritanceUtil.isInheritorOrSelf((PsiClass)class1, (PsiClass)class2, (boolean)true);
                boolean sup = InheritanceUtil.isInheritorOrSelf((PsiClass)class2, (PsiClass)class1, (boolean)true);
                if (!sub && !sup) continue;
                PsiTypeElement element = (PsiTypeElement)typeElements.get(sub ? i : j);
                this.myVisitor.report(JavaErrorKinds.EXCEPTION_MUST_BE_DISJOINT.create(element, new JavaErrorKinds.SuperclassSubclassContext(sub ? class2 : class1, sub ? class1 : class2)));
                continue block0;
            }
        }
    }

    void checkExceptionAlreadyCaught(@NotNull PsiParameter parameter) {
        PsiElement scope;
        if (parameter == null) {
            StatementChecker.$$$reportNull$$$0(6);
        }
        if (!((scope = parameter.getDeclarationScope()) instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)scope;
        Object[] allCatchSections = catchSection.getTryStatement().getCatchSections();
        int startFrom = ArrayUtilRt.find((Object[])allCatchSections, (Object)catchSection) - 1;
        if (startFrom < 0) {
            return;
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
        for (PsiTypeElement typeElement : typeElements) {
            PsiClass catchClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeElement.getType());
            if (catchClass == null) continue;
            for (int i = startFrom; i >= 0; --i) {
                boolean highlight;
                Object upperCatchSection = allCatchSections[i];
                PsiType upperCatchType = upperCatchSection.getCatchType();
                if (upperCatchType instanceof PsiDisjunctionType) {
                    PsiDisjunctionType type = (PsiDisjunctionType)upperCatchType;
                    v0 = StatementChecker.checkMultipleTypes(catchClass, type.getDisjunctions());
                } else {
                    v0 = highlight = StatementChecker.checkSingleType(catchClass, upperCatchType);
                }
                if (!highlight) continue;
                this.myVisitor.report(JavaErrorKinds.EXCEPTION_ALREADY_CAUGHT.create(typeElement, (PsiCatchSection)upperCatchSection));
            }
        }
    }

    void checkExceptionThrownInTry(@NotNull PsiParameter parameter, @NotNull Set<? extends PsiClassType> thrownTypes) {
        PsiElement declarationScope;
        if (parameter == null) {
            StatementChecker.$$$reportNull$$$0(7);
        }
        if (thrownTypes == null) {
            StatementChecker.$$$reportNull$$$0(8);
        }
        if (!((declarationScope = parameter.getDeclarationScope()) instanceof PsiCatchSection)) {
            return;
        }
        PsiType caughtType = parameter.getType();
        if (caughtType instanceof PsiClassType) {
            this.checkSimpleCatchParameter(parameter, thrownTypes, (PsiClassType)caughtType);
            return;
        }
        if (caughtType instanceof PsiDisjunctionType) {
            this.checkMultiCatchParameter(parameter, thrownTypes);
        }
    }

    private void checkSimpleCatchParameter(@NotNull PsiParameter parameter, @NotNull Collection<? extends PsiClassType> thrownTypes, @NotNull PsiClassType caughtType) {
        if (parameter == null) {
            StatementChecker.$$$reportNull$$$0(9);
        }
        if (thrownTypes == null) {
            StatementChecker.$$$reportNull$$$0(10);
        }
        if (caughtType == null) {
            StatementChecker.$$$reportNull$$$0(11);
        }
        if (ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)caughtType)) {
            return;
        }
        for (PsiClassType psiClassType : thrownTypes) {
            if (!psiClassType.isAssignableFrom((PsiType)caughtType) && !caughtType.isAssignableFrom((PsiType)psiClassType)) continue;
            return;
        }
        this.myVisitor.report(JavaErrorKinds.EXCEPTION_NEVER_THROWN_TRY.create(parameter, caughtType));
    }

    private void checkMultiCatchParameter(@NotNull PsiParameter parameter, @NotNull Collection<? extends PsiClassType> thrownTypes) {
        if (parameter == null) {
            StatementChecker.$$$reportNull$$$0(12);
        }
        if (thrownTypes == null) {
            StatementChecker.$$$reportNull$$$0(13);
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
        for (PsiTypeElement typeElement : typeElements) {
            PsiClassType classType;
            PsiType catchType = typeElement.getType();
            if (!(catchType instanceof PsiClassType) || ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)(classType = (PsiClassType)catchType))) continue;
            boolean used = false;
            for (PsiClassType psiClassType : thrownTypes) {
                if (!psiClassType.isAssignableFrom(catchType) && !catchType.isAssignableFrom((PsiType)psiClassType)) continue;
                used = true;
                break;
            }
            if (used) continue;
            this.myVisitor.report(JavaErrorKinds.EXCEPTION_NEVER_THROWN_TRY_MULTI.create(typeElement, classType));
        }
    }

    void checkForStatement(@NotNull PsiForStatement statement) {
        PsiDeclarationStatement declarationStatement;
        PsiStatement init;
        if (statement == null) {
            StatementChecker.$$$reportNull$$$0(14);
        }
        if ((init = statement.getInitialization()) == null || init instanceof PsiEmptyStatement || init instanceof PsiDeclarationStatement && ArrayUtil.getFirstElement((Object[])(declarationStatement = (PsiDeclarationStatement)init).getDeclaredElements()) instanceof PsiLocalVariable || init instanceof PsiExpressionStatement || init instanceof PsiExpressionListStatement) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.STATEMENT_INVALID.create(init));
    }

    void checkTryResourceIsAutoCloseable(@NotNull PsiResourceListElement resource) {
        PsiType type;
        if (resource == null) {
            StatementChecker.$$$reportNull$$$0(15);
        }
        if ((type = resource.getType()) == null) {
            return;
        }
        PsiElementFactory factory = this.myVisitor.factory();
        PsiClassType autoCloseable = factory.createTypeByFQClassName("java.lang.AutoCloseable", resource.getResolveScope());
        if (TypeConversionUtil.isAssignable((PsiType)autoCloseable, (PsiType)type)) {
            return;
        }
        if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)autoCloseable, (PsiType)type, (PsiElement)resource)) {
            return;
        }
        this.myVisitor.reportIncompatibleType((PsiType)autoCloseable, type, (PsiElement)resource);
    }

    void checkBreakTarget(@NotNull PsiBreakStatement statement) {
        PsiSwitchExpression expression;
        if (statement == null) {
            StatementChecker.$$$reportNull$$$0(16);
        }
        PsiIdentifier label = statement.getLabelIdentifier();
        PsiStatement target = statement.findExitedStatement();
        if (target == null) {
            if (label != null) {
                this.myVisitor.report(JavaErrorKinds.LABEL_UNRESOLVED.create(label));
            } else {
                this.myVisitor.report(JavaErrorKinds.BREAK_OUTSIDE_SWITCH_OR_LOOP.create(statement));
            }
            return;
        }
        if (this.myVisitor.isApplicable(JavaFeature.ENHANCED_SWITCH) && (expression = PsiImplUtil.findEnclosingSwitchExpression((PsiElement)statement)) != null && PsiTreeUtil.isAncestor((PsiElement)target, (PsiElement)expression, (boolean)true)) {
            this.myVisitor.report(JavaErrorKinds.BREAK_OUT_OF_SWITCH_EXPRESSION.create(statement));
        }
    }

    void checkContinueTarget(@NotNull PsiContinueStatement statement) {
        PsiSwitchExpression expression;
        if (statement == null) {
            StatementChecker.$$$reportNull$$$0(17);
        }
        PsiIdentifier label = statement.getLabelIdentifier();
        PsiStatement target = statement.findContinuedStatement();
        if (target == null) {
            if (label != null) {
                this.myVisitor.report(JavaErrorKinds.LABEL_UNRESOLVED.create(label));
            } else {
                this.myVisitor.report(JavaErrorKinds.CONTINUE_OUTSIDE_LOOP.create(statement));
            }
            return;
        }
        if (label != null && !(target instanceof PsiLoopStatement)) {
            this.myVisitor.report(JavaErrorKinds.LABEL_MUST_BE_LOOP.create(statement, label));
            return;
        }
        if (this.myVisitor.isApplicable(JavaFeature.ENHANCED_SWITCH) && (expression = PsiImplUtil.findEnclosingSwitchExpression((PsiElement)statement)) != null && PsiTreeUtil.isAncestor((PsiElement)target, (PsiElement)expression, (boolean)true)) {
            this.myVisitor.report(JavaErrorKinds.CONTINUE_OUT_OF_SWITCH_EXPRESSION.create(statement));
        }
    }

    private static boolean checkMultipleTypes(@NotNull PsiClass catchClass, @NotNull List<? extends PsiType> upperCatchTypes) {
        if (catchClass == null) {
            StatementChecker.$$$reportNull$$$0(18);
        }
        if (upperCatchTypes == null) {
            StatementChecker.$$$reportNull$$$0(19);
        }
        return ContainerUtil.exists((Iterable)upperCatchTypes.reversed(), type -> StatementChecker.checkSingleType(catchClass, type));
    }

    private static boolean checkSingleType(@NotNull PsiClass catchClass, @Nullable PsiType upperCatchType) {
        PsiClass upperCatchClass;
        if (catchClass == null) {
            StatementChecker.$$$reportNull$$$0(20);
        }
        return (upperCatchClass = PsiUtil.resolveClassInType((PsiType)upperCatchType)) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)catchClass, (PsiClass)upperCatchClass, (boolean)true);
    }

    void checkReturnStatement(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            StatementChecker.$$$reportNull$$$0(21);
        }
        if (this.myVisitor.isApplicable(JavaFeature.ENHANCED_SWITCH) && PsiImplUtil.findEnclosingSwitchExpression((PsiElement)statement) != null) {
            this.myVisitor.report(JavaErrorKinds.RETURN_OUTSIDE_SWITCH_EXPRESSION.create(statement));
            return;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiFile.class, PsiClassInitializer.class, PsiLambdaExpression.class, PsiMethod.class});
        if (parent instanceof PsiMethod) {
            PsiMethodCallExpression constructorCall;
            PsiMethod method = (PsiMethod)parent;
            if (JavaPsiRecordUtil.isCompactConstructor((PsiMethod)method)) {
                this.myVisitor.report(JavaErrorKinds.RETURN_COMPACT_CONSTRUCTOR.create(statement));
                return;
            }
            if (method.isConstructor() && (constructorCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method)) != null && statement.getTextOffset() < constructorCall.getTextOffset()) {
                this.myVisitor.report(JavaErrorKinds.RETURN_BEFORE_EXPLICIT_CONSTRUCTOR_CALL.create(statement, constructorCall));
                return;
            }
        }
        if (parent != null) {
            this.checkReturnStatementType(statement, parent);
        }
    }

    void checkReturnStatementType(@NotNull PsiReturnStatement statement, @NotNull PsiElement parent) {
        if (statement == null) {
            StatementChecker.$$$reportNull$$$0(22);
        }
        if (parent == null) {
            StatementChecker.$$$reportNull$$$0(23);
        }
        if (parent instanceof PsiCodeFragment || parent instanceof PsiLambdaExpression) {
            return;
        }
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)parent, PsiMethod.class);
        if (method == null && !(parent instanceof ServerPageFile)) {
            this.myVisitor.report(JavaErrorKinds.RETURN_OUTSIDE_METHOD.create(statement));
            return;
        }
        PsiType returnType = method != null ? method.getReturnType() : null;
        boolean isMethodVoid = returnType == null || PsiTypes.voidType().equals((Object)returnType);
        PsiExpression returnValue = statement.getReturnValue();
        if (returnValue != null) {
            PsiType valueType = RefactoringChangeUtil.getTypeByExpression((PsiExpression)returnValue);
            if (isMethodVoid) {
                PsiClass containingClass;
                boolean constructor;
                boolean bl = constructor = method != null && method.isConstructor();
                if (constructor && (containingClass = method.getContainingClass()) != null && !method.getName().equals(containingClass.getName())) {
                    return;
                }
                JavaErrorKind.Parameterized<PsiReturnStatement, PsiMethod> kind = constructor ? JavaErrorKinds.RETURN_FROM_CONSTRUCTOR : JavaErrorKinds.RETURN_FROM_VOID_METHOD;
                this.myVisitor.report(kind.create(statement, method));
            } else {
                this.myVisitor.myExpressionChecker.checkAssignability(returnType, valueType, returnValue, (PsiElement)returnValue);
            }
        } else if (!isMethodVoid && !PsiTreeUtil.hasErrorElements((PsiElement)statement)) {
            this.myVisitor.report(JavaErrorKinds.RETURN_VALUE_MISSING.create(statement, method));
        }
    }

    void checkNotAStatement(@NotNull PsiStatement statement) {
        if (statement == null) {
            StatementChecker.$$$reportNull$$$0(24);
        }
        if (PsiUtil.isStatement((PsiElement)statement)) {
            return;
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)statement)) {
            PsiErrorElement errorElement;
            PsiElement psiElement;
            PsiElement[] children;
            boolean allowedError = false;
            if (statement instanceof PsiExpressionStatement && (children = statement.getChildren())[0] instanceof PsiExpression && (psiElement = children[1]) instanceof PsiErrorElement && (errorElement = (PsiErrorElement)psiElement).getErrorDescription().equals(JavaPsiBundle.message((String)"expected.semicolon", (Object[])new Object[0]))) {
                allowedError = true;
            }
            if (!allowedError) {
                return;
            }
        }
        boolean isDeclarationNotAllowed = false;
        if (statement instanceof PsiDeclarationStatement) {
            PsiElement parent = statement.getParent();
            isDeclarationNotAllowed = parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement;
        }
        JavaErrorKind.Simple<PsiStatement> kind = isDeclarationNotAllowed ? JavaErrorKinds.STATEMENT_DECLARATION_NOT_ALLOWED : JavaErrorKinds.STATEMENT_BAD_EXPRESSION;
        this.myVisitor.report(kind.create(statement));
    }

    void checkAssertStatementTypes(@NotNull PsiExpression expression) {
        PsiElement psiElement;
        if (expression == null) {
            StatementChecker.$$$reportNull$$$0(25);
        }
        if (!((psiElement = expression.getParent()) instanceof PsiAssertStatement)) {
            return;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)psiElement;
        PsiType type = expression.getType();
        if (type == null) {
            return;
        }
        if (expression == assertStatement.getAssertCondition() && !TypeConversionUtil.isBooleanType((PsiType)type)) {
            this.myVisitor.reportIncompatibleType((PsiType)PsiTypes.booleanType(), type, (PsiElement)expression);
        } else if (expression == assertStatement.getAssertDescription() && TypeConversionUtil.isVoidType((PsiType)type)) {
            this.myVisitor.report(JavaErrorKinds.TYPE_VOID_NOT_ALLOWED.create(expression));
        }
    }

    void checkSynchronizedStatementType(@NotNull PsiExpression expression) {
        PsiSynchronizedStatement synchronizedStatement;
        PsiElement psiElement;
        if (expression == null) {
            StatementChecker.$$$reportNull$$$0(26);
        }
        if ((psiElement = expression.getParent()) instanceof PsiSynchronizedStatement && expression == (synchronizedStatement = (PsiSynchronizedStatement)psiElement).getLockExpression()) {
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (type instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)type)) {
                PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)this.myVisitor.file().getManager(), (GlobalSearchScope)expression.getResolveScope());
                this.myVisitor.reportIncompatibleType((PsiType)objectType, type, (PsiElement)expression);
            }
        }
    }

    void checkVariableAlreadyDefined(@NotNull PsiVariable variable) {
        PsiVariable oldVariable;
        if (variable == null) {
            StatementChecker.$$$reportNull$$$0(27);
        }
        if ((oldVariable = JavaPsiVariableUtil.findPreviousVariableDeclaration((PsiVariable)variable)) != null) {
            this.myVisitor.report(JavaErrorKinds.VARIABLE_ALREADY_DEFINED.create(variable, oldVariable));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 4: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrownTypes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caughtType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperCatchTypes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/StatementChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLabelWithoutStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLabelAlreadyInUse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForeachExpressionTypeIsIterable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldReportForeachNotApplicable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCatchTypeIsDisjoint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExceptionAlreadyCaught";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExceptionThrownInTry";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSimpleCatchParameter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMultiCatchParameter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForStatement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTryResourceIsAutoCloseable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBreakTarget";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "checkContinueTarget";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMultipleTypes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSingleType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReturnStatement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReturnStatementType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNotAStatement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAssertStatementTypes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSynchronizedStatementType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVariableAlreadyDefined";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

