/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting.errors;

import com.intellij.java.codeserver.highlighting.JavaCompilationErrorBundle;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.Range;

public sealed interface JavaErrorKind<Psi extends PsiElement, Context> {
    @NotNull
    public @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key();

    @NotNull
    @Nls
    default public String description(@NotNull Psi psi, Context context) {
        if (psi == null) {
            JavaErrorKind.$$$reportNull$$$0(0);
        }
        String string = JavaCompilationErrorBundle.message(this.key(), new Object[0]);
        if (string == null) {
            JavaErrorKind.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    default public HtmlChunk tooltip(@NotNull Psi psi, Context context) {
        if (psi == null) {
            JavaErrorKind.$$$reportNull$$$0(2);
        }
        HtmlChunk htmlChunk = HtmlChunk.empty();
        if (htmlChunk == null) {
            JavaErrorKind.$$$reportNull$$$0(3);
        }
        return htmlChunk;
    }

    @NotNull
    default public TextRange range(@NotNull Psi psi, Context context) {
        if (psi == null) {
            JavaErrorKind.$$$reportNull$$$0(4);
        }
        TextRange textRange = psi.getTextRange();
        if (textRange == null) {
            JavaErrorKind.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    default public @Range(from=0L, to=0x7FFFFFFFL) int navigationShift(@NotNull Psi psi, Context context) {
        if (psi == null) {
            JavaErrorKind.$$$reportNull$$$0(6);
        }
        return 0;
    }

    @NotNull
    default public JavaErrorHighlightType highlightType(@NotNull Psi psi, Context context) {
        if (psi == null) {
            JavaErrorKind.$$$reportNull$$$0(7);
        }
        JavaErrorHighlightType javaErrorHighlightType = JavaErrorHighlightType.ERROR;
        if (javaErrorHighlightType == null) {
            JavaErrorKind.$$$reportNull$$$0(8);
        }
        return javaErrorHighlightType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "description";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tooltip";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "range";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "description";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tooltip";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "range";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigationShift";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "highlightType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 8 -> new IllegalStateException(string);
        };
    }

    public static final class Parameterized<Psi extends PsiElement, Context>
    implements JavaErrorKind<Psi, Context> {
        @NotNull
        @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle")
        private final @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String myKey;
        private final @Nullable BiFunction<? super Psi, ? super Context, @Nls String> myDescription;
        @Nullable
        private final BiFunction<? super Psi, ? super Context, ? extends HtmlChunk> myTooltip;
        @Nullable
        private final BiFunction<? super Psi, ? super Context, ? extends TextRange> myRange;
        @Nullable
        private final BiFunction<? super Psi, ? super Context, JavaErrorHighlightType> myHighlightType;
        @Nullable
        private final ToIntBiFunction<? super Psi, ? super Context> myNavigationShift;

        private Parameterized(@NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key, @Nullable BiFunction<? super Psi, ? super Context, @Nls String> description, @Nullable BiFunction<? super Psi, ? super Context, ? extends HtmlChunk> tooltip, @Nullable BiFunction<? super Psi, ? super Context, ? extends TextRange> range, @Nullable BiFunction<? super Psi, ? super Context, JavaErrorHighlightType> type, @Nullable ToIntBiFunction<? super Psi, ? super Context> navigationShift) {
            if (key == null) {
                Parameterized.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myDescription = description;
            this.myTooltip = tooltip;
            this.myRange = range;
            this.myHighlightType = type;
            this.myNavigationShift = navigationShift;
        }

        Parameterized(@NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key) {
            if (key == null) {
                Parameterized.$$$reportNull$$$0(1);
            }
            this(key, null, null, null, null, null);
        }

        @NotNull
        private <T> T checkNotNull(T val, String name) {
            if (val == null) {
                throw new NullPointerException("Function '" + name + "' returns null for key " + this.key());
            }
            T t = val;
            if (t == null) {
                Parameterized.$$$reportNull$$$0(2);
            }
            return t;
        }

        @Override
        @NotNull
        public @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key() {
            String string = this.myKey;
            if (string == null) {
                Parameterized.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String description(@NotNull Psi psi, Context context) {
            if (psi == null) {
                Parameterized.$$$reportNull$$$0(4);
            }
            if (this.myDescription == null) {
                String string = JavaErrorKind.super.description(psi, context);
                if (string == null) {
                    Parameterized.$$$reportNull$$$0(5);
                }
                return string;
            }
            return this.checkNotNull(this.myDescription.apply(psi, context), "description");
        }

        @Override
        @NotNull
        public HtmlChunk tooltip(@NotNull Psi psi, Context context) {
            if (psi == null) {
                Parameterized.$$$reportNull$$$0(6);
            }
            if (this.myTooltip == null) {
                HtmlChunk htmlChunk = JavaErrorKind.super.tooltip(psi, context);
                if (htmlChunk == null) {
                    Parameterized.$$$reportNull$$$0(7);
                }
                return htmlChunk;
            }
            return this.checkNotNull(this.myTooltip.apply(psi, context), "tooltip");
        }

        @Override
        @NotNull
        public TextRange range(@NotNull Psi psi, Context context) {
            if (psi == null) {
                Parameterized.$$$reportNull$$$0(8);
            }
            if (this.myRange == null) {
                TextRange textRange = JavaErrorKind.super.range(psi, context);
                if (textRange == null) {
                    Parameterized.$$$reportNull$$$0(9);
                }
                return textRange;
            }
            TextRange textRange = this.myRange.apply(psi, context);
            if (textRange == null) {
                Parameterized.$$$reportNull$$$0(10);
            }
            return textRange;
        }

        @Override
        public @Range(from=0L, to=0x7FFFFFFFL) int navigationShift(@NotNull Psi psi, Context context) {
            if (psi == null) {
                Parameterized.$$$reportNull$$$0(11);
            }
            if (this.myNavigationShift == null) {
                return 0;
            }
            return this.myNavigationShift.applyAsInt(psi, context);
        }

        @Override
        @NotNull
        public JavaErrorHighlightType highlightType(@NotNull Psi psi, Context context) {
            if (psi == null) {
                Parameterized.$$$reportNull$$$0(12);
            }
            if (this.myHighlightType == null) {
                JavaErrorHighlightType javaErrorHighlightType = JavaErrorKind.super.highlightType(psi, context);
                if (javaErrorHighlightType == null) {
                    Parameterized.$$$reportNull$$$0(13);
                }
                return javaErrorHighlightType;
            }
            return this.checkNotNull(this.myHighlightType.apply(psi, context), "highlightType");
        }

        @Contract(pure=true)
        @NotNull
        public JavaCompilationError<Psi, Context> create(@NotNull Psi psi, Context context) {
            if (psi == null) {
                Parameterized.$$$reportNull$$$0(14);
            }
            return new JavaCompilationError<Psi, Context>(this, psi, context);
        }

        Parameterized<Psi, Context> withAnchor(@NotNull Function<? super Psi, ? extends PsiElement> anchor) {
            if (anchor == null) {
                Parameterized.$$$reportNull$$$0(15);
            }
            return this.withAbsoluteRange((psi, ctx) -> ((PsiElement)anchor.apply((Object)psi)).getTextRange());
        }

        Parameterized<Psi, Context> withAbsoluteRange(@NotNull @NotNull BiFunction<? super Psi, ? super Context, ? extends @NotNull TextRange> range) {
            if (range == null) {
                Parameterized.$$$reportNull$$$0(16);
            }
            if (this.myRange != null) {
                throw new IllegalStateException("Range function is already set for " + this.key());
            }
            return new Parameterized<Psi, Context>(this.myKey, this.myDescription, this.myTooltip, range, this.myHighlightType, this.myNavigationShift);
        }

        Parameterized<Psi, Context> withRange(@NotNull BiFunction<? super Psi, ? super Context, ? extends TextRange> range) {
            if (range == null) {
                Parameterized.$$$reportNull$$$0(17);
            }
            return this.withAbsoluteRange((psi, ctx) -> {
                TextRange res = (TextRange)range.apply((Object)psi, (Object)ctx);
                return res == null ? psi.getTextRange() : res.shiftRight(psi.getTextRange().getStartOffset());
            });
        }

        Parameterized<Psi, Context> withNavigationShift(@NotNull ToIntBiFunction<? super Psi, ? super Context> navigationShift) {
            if (navigationShift == null) {
                Parameterized.$$$reportNull$$$0(18);
            }
            if (this.myNavigationShift != null) {
                throw new IllegalStateException("Navigation shift function is already set for " + this.key());
            }
            return new Parameterized<Psi, Context>(this.myKey, this.myDescription, this.myTooltip, this.myRange, this.myHighlightType, navigationShift);
        }

        Parameterized<Psi, Context> withNavigationShift(int navigationShift) {
            return this.withNavigationShift((psi, ctx) -> navigationShift);
        }

        Parameterized<Psi, Context> withHighlightType(@NotNull BiFunction<? super Psi, ? super Context, JavaErrorHighlightType> type) {
            if (type == null) {
                Parameterized.$$$reportNull$$$0(19);
            }
            if (this.myHighlightType != null) {
                throw new IllegalStateException("Highlight type function is already set for " + this.key());
            }
            return new Parameterized<Psi, Context>(this.myKey, this.myDescription, this.myTooltip, this.myRange, type, this.myNavigationShift);
        }

        Parameterized<Psi, Context> withHighlightType(@NotNull JavaErrorHighlightType type) {
            if (type == null) {
                Parameterized.$$$reportNull$$$0(20);
            }
            return this.withHighlightType((? super Psi psi, ? super Context ctx) -> type);
        }

        Parameterized<Psi, Context> withTooltip(@NotNull BiFunction<? super Psi, ? super Context, ? extends HtmlChunk> tooltip) {
            if (tooltip == null) {
                Parameterized.$$$reportNull$$$0(21);
            }
            if (this.myTooltip != null) {
                throw new IllegalStateException("Tooltip function is already set for " + this.key());
            }
            return new Parameterized<Psi, Context>(this.myKey, this.myDescription, tooltip, this.myRange, this.myHighlightType, this.myNavigationShift);
        }

        Parameterized<Psi, Context> withDescription(@NotNull BiFunction<? super Psi, ? super Context, @Nls String> description) {
            if (description == null) {
                Parameterized.$$$reportNull$$$0(22);
            }
            if (this.myDescription != null) {
                throw new IllegalStateException("Description function is already set for " + this.key());
            }
            return new Parameterized<Psi, Context>(this.myKey, description, this.myTooltip, this.myRange, this.myHighlightType, this.myNavigationShift);
        }

        public String toString() {
            return "JavaErrorKind[" + this.myKey + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5, 7, 9, 10, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKind$Parameterized";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 11: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationShift";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tooltip";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKind$Parameterized";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkNotNull";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "key";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "description";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tooltip";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "range";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "highlightType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 13: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "description";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "tooltip";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "range";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "navigationShift";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "highlightType";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "withAnchor";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "withAbsoluteRange";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "withRange";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "withNavigationShift";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "withHighlightType";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "withTooltip";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "withDescription";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5, 7, 9, 10, 13 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Simple<Psi extends PsiElement>
    implements JavaErrorKind<Psi, Void> {
        @NotNull
        @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle")
        private final @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String myKey;
        private final @Nullable Function<? super Psi, @Nls String> myDescription;
        @Nullable
        private final Function<? super Psi, ? extends HtmlChunk> myTooltip;
        private final @Nullable Function<? super Psi, ? extends @NotNull TextRange> myRange;
        @Nullable
        private final Function<? super Psi, JavaErrorHighlightType> myHighlightType;
        @Nullable
        private final ToIntFunction<? super Psi> myNavigationShift;

        private Simple(@NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key, @Nullable Function<? super Psi, @Nls String> description, @Nullable Function<? super Psi, ? extends HtmlChunk> tooltip, @Nullable Function<? super Psi, ? extends TextRange> range, @Nullable Function<? super Psi, JavaErrorHighlightType> type, @Nullable ToIntFunction<? super Psi> navigationShift) {
            if (key == null) {
                Simple.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myDescription = description;
            this.myTooltip = tooltip;
            this.myRange = range;
            this.myHighlightType = type;
            this.myNavigationShift = navigationShift;
        }

        Simple(@NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key) {
            if (key == null) {
                Simple.$$$reportNull$$$0(1);
            }
            this(key, null, null, null, null, null);
        }

        @NotNull
        private <T> T checkNotNull(T val, String name) {
            if (val == null) {
                throw new NullPointerException("Function '" + name + "' returns null for key " + this.key());
            }
            T t = val;
            if (t == null) {
                Simple.$$$reportNull$$$0(2);
            }
            return t;
        }

        @Override
        @NotNull
        public @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key() {
            String string = this.myKey;
            if (string == null) {
                Simple.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String description(@NotNull Psi psi, Void unused) {
            if (psi == null) {
                Simple.$$$reportNull$$$0(4);
            }
            if (this.myDescription == null) {
                String string = JavaErrorKind.super.description(psi, null);
                if (string == null) {
                    Simple.$$$reportNull$$$0(5);
                }
                return string;
            }
            return this.checkNotNull(this.myDescription.apply(psi), "description");
        }

        @Override
        @NotNull
        public HtmlChunk tooltip(@NotNull Psi psi, Void unused) {
            if (psi == null) {
                Simple.$$$reportNull$$$0(6);
            }
            if (this.myTooltip == null) {
                HtmlChunk htmlChunk = JavaErrorKind.super.tooltip(psi, null);
                if (htmlChunk == null) {
                    Simple.$$$reportNull$$$0(7);
                }
                return htmlChunk;
            }
            return this.checkNotNull(this.myTooltip.apply(psi), "tooltip");
        }

        @Override
        @NotNull
        public TextRange range(@NotNull Psi psi, Void unused) {
            if (psi == null) {
                Simple.$$$reportNull$$$0(8);
            }
            if (this.myRange == null) {
                TextRange textRange = JavaErrorKind.super.range(psi, null);
                if (textRange == null) {
                    Simple.$$$reportNull$$$0(9);
                }
                return textRange;
            }
            TextRange textRange = this.myRange.apply(psi);
            if (textRange == null) {
                Simple.$$$reportNull$$$0(10);
            }
            return textRange;
        }

        @Override
        public @Range(from=0L, to=0x7FFFFFFFL) int navigationShift(@NotNull Psi psi, Void unused) {
            if (psi == null) {
                Simple.$$$reportNull$$$0(11);
            }
            if (this.myNavigationShift == null) {
                return 0;
            }
            return this.myNavigationShift.applyAsInt(psi);
        }

        @Override
        @NotNull
        public JavaErrorHighlightType highlightType(@NotNull Psi psi, Void unused) {
            if (psi == null) {
                Simple.$$$reportNull$$$0(12);
            }
            if (this.myHighlightType == null) {
                JavaErrorHighlightType javaErrorHighlightType = JavaErrorKind.super.highlightType(psi, null);
                if (javaErrorHighlightType == null) {
                    Simple.$$$reportNull$$$0(13);
                }
                return javaErrorHighlightType;
            }
            return this.checkNotNull(this.myHighlightType.apply(psi), "highlightType");
        }

        Simple<Psi> withAnchor(@NotNull Function<? super Psi, ? extends PsiElement> anchor) {
            if (anchor == null) {
                Simple.$$$reportNull$$$0(14);
            }
            return this.withAbsoluteRange(psi -> ((PsiElement)anchor.apply((Object)psi)).getTextRange());
        }

        Simple<Psi> withAbsoluteRange(@NotNull Function<? super Psi, ? extends TextRange> range) {
            if (range == null) {
                Simple.$$$reportNull$$$0(15);
            }
            if (this.myRange != null) {
                throw new IllegalStateException("Range function is already set for " + this.key());
            }
            return new Simple<Psi>(this.myKey, this.myDescription, this.myTooltip, range, this.myHighlightType, this.myNavigationShift);
        }

        Simple<Psi> withRange(@NotNull Function<? super Psi, ? extends @Nullable TextRange> range) {
            if (range == null) {
                Simple.$$$reportNull$$$0(16);
            }
            return this.withAbsoluteRange(psi -> {
                TextRange res = (TextRange)range.apply((Object)psi);
                return res == null ? psi.getTextRange() : res.shiftRight(psi.getTextRange().getStartOffset());
            });
        }

        Simple<Psi> withHighlightType(@NotNull Function<? super Psi, JavaErrorHighlightType> type) {
            if (type == null) {
                Simple.$$$reportNull$$$0(17);
            }
            if (this.myHighlightType != null) {
                throw new IllegalStateException("Highlight type function is already set for " + this.key());
            }
            return new Simple<Psi>(this.myKey, this.myDescription, this.myTooltip, this.myRange, type, this.myNavigationShift);
        }

        Simple<Psi> withHighlightType(@NotNull JavaErrorHighlightType type) {
            if (type == null) {
                Simple.$$$reportNull$$$0(18);
            }
            return this.withHighlightType((? super Psi psi) -> type);
        }

        Simple<Psi> withNavigationShift(@NotNull ToIntFunction<? super Psi> navigationShift) {
            if (navigationShift == null) {
                Simple.$$$reportNull$$$0(19);
            }
            if (this.myNavigationShift != null) {
                throw new IllegalStateException("Navigation shift function is already set for " + this.key());
            }
            return new Simple<Psi>(this.myKey, this.myDescription, this.myTooltip, this.myRange, this.myHighlightType, navigationShift);
        }

        Simple<Psi> withNavigationShift(int navigationShift) {
            return this.withNavigationShift(psi -> navigationShift);
        }

        Simple<Psi> withDescription(@NotNull Function<? super Psi, @Nls String> description) {
            if (description == null) {
                Simple.$$$reportNull$$$0(20);
            }
            if (this.myDescription != null) {
                throw new IllegalStateException("Description function is already set for " + this.key());
            }
            return new Simple<Psi>(this.myKey, description, this.myTooltip, this.myRange, this.myHighlightType, this.myNavigationShift);
        }

        <Context> Parameterized<Psi, Context> parameterized() {
            return new Parameterized<PsiElement, Object>(this.myKey, this.myDescription == null ? null : (psi, ctx) -> this.myDescription.apply(psi), this.myTooltip == null ? null : (psi, ctx) -> this.myTooltip.apply(psi), this.myRange == null ? null : (psi, ctx) -> this.myRange.apply(psi), this.myHighlightType == null ? null : (psi, ctx) -> this.myHighlightType.apply(psi), this.myNavigationShift == null ? null : (psi, ctx) -> this.myNavigationShift.applyAsInt(psi));
        }

        @Contract(pure=true)
        @NotNull
        public JavaCompilationError<Psi, Void> create(@NotNull Psi psi) {
            if (psi == null) {
                Simple.$$$reportNull$$$0(21);
            }
            return new JavaCompilationError<Psi, Object>(this, psi, null);
        }

        public String toString() {
            return "JavaErrorKind[" + this.myKey + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5, 7, 9, 10, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKind$Simple";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 11: 
                case 12: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationShift";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKind$Simple";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkNotNull";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "key";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "description";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tooltip";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "range";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "highlightType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 13: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "description";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "tooltip";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "range";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "navigationShift";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "highlightType";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "withAnchor";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "withAbsoluteRange";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "withRange";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "withHighlightType";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "withNavigationShift";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "withDescription";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5, 7, 9, 10, 13 -> new IllegalStateException(string);
            };
        }
    }
}

