/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting.errors;

import com.intellij.java.codeserver.highlighting.JavaCompilationErrorBundle;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorFormatUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaIncompatibleTypeErrorContext
extends Record {
    @NotNull
    private final PsiType lType;
    @Nullable
    private final PsiType rType;
    @Nullable
    @Nls
    private final String reasonForIncompatibleTypes;
    @NlsSafe
    private static final String ANONYMOUS = "anonymous ";

    public JavaIncompatibleTypeErrorContext(@NotNull PsiType lType, @Nullable PsiType rType) {
        if (lType == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(0);
        }
        this(lType, rType, null);
    }

    public JavaIncompatibleTypeErrorContext(@NotNull PsiType lType, @Nullable PsiType rType, @Nullable @Nls String reasonForIncompatibleTypes) {
        if (lType == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(1);
        }
        this.lType = lType;
        this.rType = rType;
        this.reasonForIncompatibleTypes = reasonForIncompatibleTypes;
    }

    @Nls
    @NotNull
    private String getReasonForIncompatibleTypes() {
        PsiMethodReferenceType referenceType;
        JavaResolveResult[] results;
        PsiType psiType = this.rType;
        if (psiType instanceof PsiMethodReferenceType && (results = (referenceType = (PsiMethodReferenceType)psiType).getExpression().multiResolve(false)).length > 1) {
            PsiElement element1 = results[0].getElement();
            PsiElement element2 = results[1].getElement();
            if (element1 instanceof PsiMethod && element2 instanceof PsiMethod) {
                String candidate1 = JavaErrorFormatUtil.format(element1);
                String candidate2 = JavaErrorFormatUtil.format(element2);
                String string = JavaCompilationErrorBundle.message("type.incompatible.reason.ambiguous.method.reference", candidate1, candidate2);
                if (string == null) {
                    JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        return "";
    }

    @NotNull
    HtmlChunk createTooltip() {
        String reason = this.reasonForIncompatibleTypes == null ? this.getReasonForIncompatibleTypes() : this.reasonForIncompatibleTypes;
        HtmlChunk styledReason = reason.isEmpty() ? HtmlChunk.empty() : HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)HtmlChunk.tag((String)"td").style("padding-top: 10px; padding-left: 4px;").addText(reason)));
        IncompatibleTypesTooltipComposer tooltipComposer = (lTypeString, lTypeArguments, rTypeString, rTypeArguments) -> JavaIncompatibleTypeErrorContext.createRequiredProvidedTypeMessage(lTypeString, lTypeArguments, rTypeString, rTypeArguments, styledReason);
        HtmlChunk htmlChunk = this.createIncompatibleTypesTooltip(tooltipComposer);
        if (htmlChunk == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(3);
        }
        return htmlChunk;
    }

    @NotNull
    @Nls
    String createDescription() {
        PsiType baseLType = PsiUtil.convertAnonymousToBaseType((PsiType)this.lType);
        PsiType baseRType = this.rType == null ? null : PsiUtil.convertAnonymousToBaseType((PsiType)this.rType);
        boolean leftAnonymous = PsiUtil.resolveClassInClassTypeOnly((PsiType)this.lType) instanceof PsiAnonymousClass;
        String lTypeString = JavaErrorFormatUtil.formatType(leftAnonymous ? this.lType : baseLType);
        String rTypeString = JavaErrorFormatUtil.formatType(leftAnonymous ? this.rType : baseRType);
        String string = JavaCompilationErrorBundle.message("type.incompatible", lTypeString, rTypeString);
        if (string == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    static HtmlChunk createRequiredProvidedTypeMessage(@NotNull HtmlChunk lType, @Nls @NotNull String lTypeArguments, @NotNull HtmlChunk rType, @Nls @NotNull String rTypeArguments, @NotNull HtmlChunk styledReason) {
        if (lType == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(5);
        }
        if (lTypeArguments == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(6);
        }
        if (rType == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(7);
        }
        if (rTypeArguments == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(8);
        }
        if (styledReason == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(9);
        }
        HtmlChunk.Element element = HtmlChunk.html().child((HtmlChunk)HtmlChunk.body().children(new HtmlChunk[]{HtmlChunk.tag((String)"table").children(new HtmlChunk[]{HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{HtmlChunk.tag((String)"td").style("padding: 0px 16px 8px 4px;").setClass("--java-display-grayed").addText(JavaCompilationErrorBundle.message("type.incompatible.tooltip.required.type", new Object[0])), HtmlChunk.tag((String)"td").style("padding: 0px 4px 8px 0px;").child(lType), HtmlChunk.raw((String)lTypeArguments)}), HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{HtmlChunk.tag((String)"td").style("padding: 0px 16px 0px 4px;").setClass("--java-display-grayed").addText(JavaCompilationErrorBundle.message("type.incompatible.tooltip.provided.type", new Object[0])), HtmlChunk.tag((String)"td").style("padding: 0px 4px 0px 0px;").child(rType), HtmlChunk.raw((String)rTypeArguments)})}), styledReason}));
        if (element == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(10);
        }
        return element;
    }

    @NlsContexts.Tooltip
    @NotNull
    HtmlChunk createIncompatibleTypesTooltip(@NotNull IncompatibleTypesTooltipComposer consumer) {
        PsiType psiType;
        PsiType lRawType;
        if (consumer == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(11);
        }
        PsiType baseLType = PsiUtil.convertAnonymousToBaseType((PsiType)this.lType);
        PsiType baseRType = this.rType == null ? null : PsiUtil.convertAnonymousToBaseType((PsiType)this.rType);
        boolean leftAnonymous = PsiUtil.resolveClassInClassTypeOnly((PsiType)this.lType) instanceof PsiAnonymousClass;
        PsiType lType = leftAnonymous ? this.lType : baseLType;
        PsiType rType = leftAnonymous ? this.rType : baseRType;
        TypeData lTypeData = JavaIncompatibleTypeErrorContext.typeData(lType);
        TypeData rTypeData = JavaIncompatibleTypeErrorContext.typeData(rType);
        PsiTypeParameter[] lTypeParams = lTypeData.typeParameters();
        PsiTypeParameter[] rTypeParams = rTypeData.typeParameters();
        int typeParamColumns = Math.max(lTypeParams.length, rTypeParams.length);
        boolean skipColumns = consumer.skipTypeArgsColumns();
        StringBuilder requiredRow = new StringBuilder();
        StringBuilder foundRow = new StringBuilder();
        for (int i = 0; i < typeParamColumns; ++i) {
            PsiTypeParameter lTypeParameter = i >= lTypeParams.length ? null : lTypeParams[i];
            PsiTypeParameter rTypeParameter = i >= rTypeParams.length ? null : rTypeParams[i];
            PsiType lSubstitutedType = lTypeParameter == null ? null : lTypeData.substitutor().substitute(lTypeParameter);
            PsiType rSubstitutedType = rTypeParameter == null ? null : rTypeData.substitutor().substitute(rTypeParameter);
            boolean matches = lSubstitutedType == rSubstitutedType || lSubstitutedType != null && rSubstitutedType != null && TypeConversionUtil.typesAgree((PsiType)lSubstitutedType, (PsiType)rSubstitutedType, (boolean)true);
            String openBrace = i == 0 ? "&lt;" : "";
            String closeBrace = i == typeParamColumns - 1 ? "&gt;" : ",";
            boolean showShortType = JavaIncompatibleTypeErrorContext.showShortType(lSubstitutedType, rSubstitutedType);
            requiredRow.append(skipColumns ? "" : "<td style='padding: 0px 0px 8px 0px;'>").append(lTypeParams.length == 0 ? "" : openBrace).append(JavaIncompatibleTypeErrorContext.redIfNotMatch(lSubstitutedType, true, showShortType)).append(i < lTypeParams.length ? closeBrace : "").append(skipColumns ? "" : "</td>");
            foundRow.append(skipColumns ? "" : "<td style='padding: 0px 0px 0px 0px;'>").append(rTypeParams.length == 0 ? "" : openBrace).append(JavaIncompatibleTypeErrorContext.redIfNotMatch(rSubstitutedType, matches, showShortType)).append(i < rTypeParams.length ? closeBrace : "").append(skipColumns ? "" : "</td>");
        }
        if (lType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)lType;
            v0 = classType.rawType();
        } else {
            v0 = lRawType = lType;
        }
        if (rType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)rType;
            psiType = classType.rawType();
        } else {
            psiType = rType;
        }
        PsiType rRawType = psiType;
        boolean assignable = rRawType == null || TypeConversionUtil.isAssignable((PsiType)lRawType, (PsiType)rRawType);
        boolean shortType = JavaIncompatibleTypeErrorContext.showShortType(lRawType, rRawType);
        HtmlChunk htmlChunk = consumer.consume(JavaIncompatibleTypeErrorContext.redIfNotMatch(lRawType, true, shortType), requiredRow.toString(), JavaIncompatibleTypeErrorContext.redIfNotMatch(rRawType, assignable, shortType), foundRow.toString());
        if (htmlChunk == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(12);
        }
        return htmlChunk;
    }

    @NotNull
    private static TypeData typeData(PsiType type) {
        PsiTypeParameter[] parameters;
        PsiSubstitutor substitutor;
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            substitutor = resolveResult.getSubstitutor();
            PsiClass psiClass = resolveResult.getElement();
            parameters = psiClass == null || classType.isRaw() ? PsiTypeParameter.EMPTY_ARRAY : psiClass.getTypeParameters();
        } else {
            substitutor = PsiSubstitutor.EMPTY;
            parameters = PsiTypeParameter.EMPTY_ARRAY;
        }
        return new TypeData(parameters, substitutor);
    }

    @NotNull
    @NlsSafe
    static HtmlChunk redIfNotMatch(@Nullable PsiType type, boolean matches, boolean shortType) {
        if (type == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(13);
            }
            return htmlChunk;
        }
        Object typeText = shortType || type instanceof PsiCapturedWildcardType ? (PsiUtil.resolveClassInClassTypeOnly((PsiType)type) instanceof PsiAnonymousClass ? ANONYMOUS + type.getPresentableText() : type.getPresentableText()) : type.getCanonicalText();
        HtmlChunk.Element element = HtmlChunk.span().setClass(matches ? "--java-display-information" : "--java-display-error").addText((String)typeText);
        if (element == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(14);
        }
        return element;
    }

    static boolean showShortType(@Nullable PsiType lType, @Nullable PsiType rType) {
        if (Comparing.equal((Object)lType, (Object)rType)) {
            return true;
        }
        return lType != null && rType != null && (!lType.getPresentableText().equals(rType.getPresentableText()) || lType.getCanonicalText().equals(rType.getCanonicalText()));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{JavaIncompatibleTypeErrorContext.class, "lType;rType;reasonForIncompatibleTypes", "lType", "rType", "reasonForIncompatibleTypes"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{JavaIncompatibleTypeErrorContext.class, "lType;rType;reasonForIncompatibleTypes", "lType", "rType", "reasonForIncompatibleTypes"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{JavaIncompatibleTypeErrorContext.class, "lType;rType;reasonForIncompatibleTypes", "lType", "rType", "reasonForIncompatibleTypes"}, this, o);
    }

    @NotNull
    public PsiType lType() {
        PsiType psiType = this.lType;
        if (psiType == null) {
            JavaIncompatibleTypeErrorContext.$$$reportNull$$$0(15);
        }
        return psiType;
    }

    @Nullable
    public PsiType rType() {
        return this.rType;
    }

    @Nullable
    @Nls
    public String reasonForIncompatibleTypes() {
        return this.reasonForIncompatibleTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 10, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaIncompatibleTypeErrorContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lTypeArguments";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rTypeArguments";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styledReason";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaIncompatibleTypeErrorContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReasonForIncompatibleTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequiredProvidedTypeMessage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createIncompatibleTypesTooltip";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "redIfNotMatch";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "lType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRequiredProvidedTypeMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleTypesTooltip";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 10, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    static interface IncompatibleTypesTooltipComposer {
        @NlsContexts.Tooltip
        @NotNull
        public HtmlChunk consume(@NotNull HtmlChunk var1, @NotNull @NlsSafe String var2, @NotNull HtmlChunk var3, @NotNull @NlsSafe String var4);

        default public boolean skipTypeArgsColumns() {
            return false;
        }
    }

    private record TypeData(@NotNull @NotNull PsiTypeParameter @NotNull [] typeParameters, @NotNull PsiSubstitutor substitutor) {
        @NotNull
        private final @NotNull PsiTypeParameter @NotNull [] typeParameters;
        @NotNull
        private final PsiSubstitutor substitutor;

        private TypeData(@NotNull @NotNull PsiTypeParameter @NotNull [] typeParameters, @NotNull PsiSubstitutor substitutor) {
            if (substitutor == null) {
                TypeData.$$$reportNull$$$0(0);
            }
            if (typeParameters == null) {
                TypeData.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public @NotNull PsiTypeParameter @NotNull [] typeParameters() {
            if (this.typeParameters == null) {
                TypeData.$$$reportNull$$$0(2);
            }
            return this.typeParameters;
        }

        @NotNull
        public PsiSubstitutor substitutor() {
            PsiSubstitutor psiSubstitutor = this.substitutor;
            if (psiSubstitutor == null) {
                TypeData.$$$reportNull$$$0(3);
            }
            return psiSubstitutor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeParameters";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaIncompatibleTypeErrorContext$TypeData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaIncompatibleTypeErrorContext$TypeData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "typeParameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substitutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

