/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.scheme.RegisteredLogDescriptionsProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fH\u0000\u00a2\u0006\u0002\b\u0011J\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H&J\u0014\u0010\u0015\u001a\u00020\r*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J(\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013*\u00020\u00162\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0004R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "", "groupId", "", "eventId", "recorder", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getEventId", "()Ljava/lang/String;", "getRecorder", "processLoggers", "", "log", "Lkotlin/Function1;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "processLoggers$intellij_platform_statistics", "getFields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "extendFeatureUsageData", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "fuData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "extendEventFields", "eventFields", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nEventId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventId.kt\ncom/intellij/internal/statistic/eventLog/events/BaseEventId\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n1915#2,2:300\n1915#2,2:302\n1586#2:304\n1661#2,3:305\n*S KotlinDebug\n*F\n+ 1 EventId.kt\ncom/intellij/internal/statistic/eventLog/events/BaseEventId\n*L\n52#1:300,2\n60#1:302,2\n67#1:304\n67#1:305,3\n*E\n"})
public abstract class BaseEventId {
    @NotNull
    private final String eventId;
    @NotNull
    private final String recorder;

    public BaseEventId(@NotNull String groupId, @NotNull String eventId, @NotNull String recorder, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        this.eventId = eventId;
        this.recorder = recorder;
        if (description != null && ((CharSequence)description).length() == 0) {
            throw new IllegalArgumentException("Recorder " + this.recorder + ", event ID " + this.eventId + ": the event description can't be empty string.");
        }
        RegisteredLogDescriptionsProcessor.INSTANCE.registerEventDescription(groupId, this.eventId, description);
    }

    @NotNull
    public final String getEventId() {
        return this.eventId;
    }

    @NotNull
    public final String getRecorder() {
        return this.recorder;
    }

    public final void processLoggers$intellij_platform_statistics(@NotNull Function1<? super StatisticsEventLogger, Unit> log2) {
        Intrinsics.checkNotNullParameter(log2, (String)"log");
        List errors = new ArrayList();
        for (StatisticsEventLoggerProvider p : StatisticsEventLogProviderUtil.getEventLogProvidersExt(this.recorder)) {
            try {
                log2.invoke((Object)p.getLogger());
            }
            catch (Throwable e) {
                errors.add(e);
            }
        }
        if (errors.size() == 1) {
            throw (Throwable)CollectionsKt.first((List)errors);
        }
        if (!((Collection)errors).isEmpty()) {
            Throwable throwable = new Throwable("Multiple errors occurred:");
            Iterable $this$forEach$iv = errors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable p0 = (Throwable)element$iv;
                boolean bl = false;
                throwable.addSuppressed(p0);
            }
            throw throwable;
        }
    }

    @NotNull
    public abstract List<EventField<?>> getFields();

    protected final void extendFeatureUsageData(@NotNull EventLogGroup $this$extendFeatureUsageData, @NotNull FeatureUsageData fuData) {
        Intrinsics.checkNotNullParameter((Object)$this$extendFeatureUsageData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
        Iterable $this$forEach$iv = $this$extendFeatureUsageData.getGroupData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Function1 appendData = (Function1)pair.component2();
            appendData.invoke((Object)fuData);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<EventField<?>> extendEventFields(@NotNull EventLogGroup $this$extendEventFields, @NotNull List<? extends EventField<?>> eventFields) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$extendEventFields, (String)"<this>");
        Intrinsics.checkNotNullParameter(eventFields, (String)"eventFields");
        if ($this$extendEventFields.getGroupData().isEmpty()) {
            return eventFields;
        }
        Iterable iterable = $this$extendEventFields.getGroupData();
        Collection collection = new ArrayList();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((EventField)it.getFirst());
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (Iterable)eventFields));
    }
}

