/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ifds;

import com.intellij.rml.dfa.impl.ifds.AccessPathDelta;
import com.intellij.rml.dfa.ir.ast.IrFieldID;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0080\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\r\u001a\u00020\u000eH\u0096\u0080\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0004J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001c\u001a\u00020\nH\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/rml/dfa/impl/ifds/AccessPath;", "", "fields", "", "Lcom/intellij/rml/dfa/ir/ast/IrFieldID;", "<init>", "(Ljava/util/List;)V", "getFields", "()Ljava/util/List;", "size", "", "getSize", "()I", "toString", "", "startsWith", "", "other", "endsWith", "apply", "delta", "Lcom/intellij/rml/dfa/impl/ifds/AccessPathDelta;", "dropLast", "append", "field", "component1", "copy", "equals", "hashCode", "Companion", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIFDSImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IFDSImpl.kt\ncom/intellij/rml/dfa/impl/ifds/AccessPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,727:1\n1786#2,3:728\n1786#2,3:731\n*S KotlinDebug\n*F\n+ 1 IFDSImpl.kt\ncom/intellij/rml/dfa/impl/ifds/AccessPath\n*L\n67#1:728,3\n70#1:731,3\n*E\n"})
public final class AccessPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<IrFieldID> fields;
    private final int size;
    @NotNull
    private static final AccessPath Empty = new AccessPath(CollectionsKt.emptyList());

    public AccessPath(@NotNull List<IrFieldID> fields) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this.fields = fields;
        this.size = this.fields.size();
    }

    @NotNull
    public final List<IrFieldID> getFields() {
        return this.fields;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.fields, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean startsWith(@NotNull AccessPath other) {
        int it;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.fields.size() < other.fields.size()) return false;
        Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)other.fields);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            int element$iv;
            if (!iterator.hasNext()) return true;
            it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)this.fields.get(it), (Object)other.fields.get(it)));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean endsWith(@NotNull AccessPath other) {
        int it;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.fields.size() < other.fields.size()) return false;
        Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)other.fields);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            int element$iv;
            if (!iterator.hasNext()) return true;
            it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)this.fields.get(this.fields.size() - other.fields.size() + it), (Object)other.fields.get(it)));
        return false;
    }

    @Nullable
    public final AccessPath apply(@NotNull AccessPathDelta delta) {
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        if (this.startsWith(delta.getPrefixToRemove())) {
            return new AccessPath(CollectionsKt.plus((Collection)delta.getPrefixToAdd().fields, (Iterable)CollectionsKt.drop((Iterable)this.fields, (int)delta.getPrefixToRemove().size)));
        }
        return null;
    }

    @NotNull
    public final AccessPath dropLast() {
        return new AccessPath(CollectionsKt.dropLast(this.fields, (int)1));
    }

    @NotNull
    public final AccessPath append(@NotNull IrFieldID field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return new AccessPath(CollectionsKt.plus((Collection)this.fields, (Object)field));
    }

    @NotNull
    public final List<IrFieldID> component1() {
        return this.fields;
    }

    @NotNull
    public final AccessPath copy(@NotNull List<IrFieldID> fields) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        return new AccessPath(fields);
    }

    public static /* synthetic */ AccessPath copy$default(AccessPath accessPath, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = accessPath.fields;
        }
        return accessPath.copy(list);
    }

    public int hashCode() {
        return ((Object)this.fields).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AccessPath)) {
            return false;
        }
        AccessPath accessPath = (AccessPath)other;
        return Intrinsics.areEqual(this.fields, accessPath.fields);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/rml/dfa/impl/ifds/AccessPath$Companion;", "", "<init>", "()V", "Empty", "Lcom/intellij/rml/dfa/impl/ifds/AccessPath;", "getEmpty", "()Lcom/intellij/rml/dfa/impl/ifds/AccessPath;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AccessPath getEmpty() {
            return Empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

