/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.rml.dfa.AnalysisPass;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.impl.DfaFunctionEvaluationBaseEvent;
import com.intellij.rml.dfa.impl.DfaFunctionEvaluationEvent;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.summaries.DfaMeasurement;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryFunctionEvaluationBaseEvent;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryFunctionEvaluationEvent;
import com.intellij.rml.dfa.utils.Key;
import com.intellij.rml.dfa.utils.KeyMap;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementKind;
import com.intellij.rml.dfa.utils.measurements.DfaSingleMeasurementResult;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\u0010\u0004\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003$%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J'\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u001fJ\f\u0010 \u001a\u00020\t*\u00020\u001dH\u0002J\f\u0010!\u001a\u00020\"*\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement;", "Lcom/intellij/rml/dfa/impl/summaries/DfaMeasurement;", "parallelism", "", "<init>", "(I)V", "memoryOfCollectionProviders", "Ljava/util/concurrent/atomic/AtomicLong;", "memoryOfGlobalProvider", "", "memoryOfLocalProvider", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$FunctionEvalID;", "functionEvaluationEvents", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$FunctionEvaluationEvent;", "getMetrics", "Lcom/intellij/rml/dfa/utils/KeyMap;", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult;", "computeUpperBoundOfLocalMemoryPeak", "functionAnalysisStarted", "", "event", "Lcom/intellij/rml/dfa/impl/DfaFunctionEvaluationBaseEvent;", "functionAnalysisFinished", "Lcom/intellij/rml/dfa/impl/DfaFunctionEvaluationEvent;", "startTime", "afterAllPasses", "globalProvider", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;", "storageSize", "(Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;JLjava/lang/Long;)V", "memory", "byteToMb", "", "", "FunctionEvalID", "Action", "FunctionEvaluationEvent", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nDfaMeasurement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaMeasurement.kt\ncom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement\n+ 2 KeyMap.kt\ncom/intellij/rml/dfa/utils/KeyMap$Companion\n*L\n1#1,269:1\n25#2:270\n*S KotlinDebug\n*F\n+ 1 DfaMeasurement.kt\ncom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement\n*L\n92#1:270\n*E\n"})
public final class DfaMemoryMeasurement
extends DfaMeasurement {
    private final int parallelism;
    @NotNull
    private AtomicLong memoryOfCollectionProviders;
    private long memoryOfGlobalProvider;
    @NotNull
    private final ConcurrentHashMap<FunctionEvalID, Long> memoryOfLocalProvider;
    @NotNull
    private final ConcurrentLinkedQueue<FunctionEvaluationEvent> functionEvaluationEvents;

    public DfaMemoryMeasurement(int parallelism) {
        this.parallelism = parallelism;
        this.memoryOfCollectionProviders = new AtomicLong(0L);
        this.memoryOfLocalProvider = new ConcurrentHashMap();
        this.functionEvaluationEvents = new ConcurrentLinkedQueue();
    }

    @NotNull
    public KeyMap<DfaSingleMeasurementResult> getMetrics() {
        KeyMap keyMap;
        long peakOfLocalProvidersMemoryEstimation = this.computeUpperBoundOfLocalMemoryPeak();
        Collection<Long> collection = this.memoryOfLocalProvider.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable memoryOfLocalProviderValues = collection;
        CollectionsKt.averageOfLong((Iterable)memoryOfLocalProviderValues);
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)DfaMeasurementKind.Memory.Companion.getTOTAL_MEMORY(), (Object)(peakOfLocalProvidersMemoryEstimation + this.memoryOfCollectionProviders.get() + this.memoryOfGlobalProvider));
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)memoryOfLocalProviderValues);
        pairArray[1] = TuplesKt.to((Object)DfaMeasurementKind.Memory.Companion.getMAX_LOCAL_MEM(), (Object)(l != null ? l : 0L));
        pairArray[2] = TuplesKt.to((Object)DfaMeasurementKind.Memory.Companion.getAVG_LOCAL_MEM(), (Object)((long)CollectionsKt.averageOfLong((Iterable)memoryOfLocalProviderValues)));
        pairArray[3] = TuplesKt.to((Object)DfaMeasurementKind.Memory.Companion.getMAX_SUM_LOCAL_MEM(), (Object)CollectionsKt.sumOfLong((Iterable)CollectionsKt.take((Iterable)CollectionsKt.sortedDescending((Iterable)memoryOfLocalProviderValues), (int)this.parallelism)));
        pairArray[4] = TuplesKt.to((Object)DfaMeasurementKind.Memory.Companion.getPEAK_SUM_LOCAL_MEM(), (Object)peakOfLocalProvidersMemoryEstimation);
        pairArray[5] = TuplesKt.to((Object)DfaMeasurementKind.Memory.Companion.getACC_LOCAL_MEM(), (Object)CollectionsKt.sumOfLong((Iterable)memoryOfLocalProviderValues));
        pairArray[6] = TuplesKt.to((Object)DfaMeasurementKind.Memory.Companion.getCOLLECTION_MEM(), (Object)this.memoryOfCollectionProviders.get());
        pairArray[7] = TuplesKt.to((Object)DfaMeasurementKind.Memory.Companion.getGLOBAL_MEM(), (Object)this.memoryOfGlobalProvider);
        Map metrics = MapsKt.mapOf((Pair[])pairArray);
        KeyMap.Companion this_$iv = KeyMap.Companion;
        boolean $i$f$create = false;
        KeyMap it = keyMap = new KeyMap();
        boolean bl = false;
        for (Map.Entry entry : metrics.entrySet()) {
            Key key = (Key)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            it.set(key, (Object)new DfaSingleMeasurementResult.Numeric.MemoryConsumption(value));
        }
        return keyMap;
    }

    private final long computeUpperBoundOfLocalMemoryPeak() {
        long maxLocalMem = 0L;
        long curLocalMem = 0L;
        Iterator<FunctionEvaluationEvent> iterator = this.functionEvaluationEvents.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<FunctionEvaluationEvent> iterator2 = iterator;
        block4: while (iterator2.hasNext()) {
            FunctionEvaluationEvent event = iterator2.next();
            Long l = this.memoryOfLocalProvider.get(event.getId());
            long functionLocalMem = l != null ? l : 0L;
            switch (WhenMappings.$EnumSwitchMapping$0[event.getAction().ordinal()]) {
                case 1: {
                    maxLocalMem = Math.max(maxLocalMem, curLocalMem += functionLocalMem);
                    continue block4;
                }
                case 2: {
                    maxLocalMem = Math.max(maxLocalMem, curLocalMem);
                    curLocalMem -= functionLocalMem;
                    continue block4;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        if (!(curLocalMem == 0L)) {
            throw new IllegalStateException("Check failed.");
        }
        return maxLocalMem;
    }

    @Override
    public void functionAnalysisStarted(@NotNull DfaFunctionEvaluationBaseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof DfaSummaryFunctionEvaluationBaseEvent)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.functionEvaluationEvents.add(new FunctionEvaluationEvent(event.getFunction(), ((DfaSummaryFunctionEvaluationBaseEvent)event).getPass(), Action.START));
    }

    @Override
    public void functionAnalysisFinished(@NotNull DfaFunctionEvaluationEvent event, long startTime) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof DfaSummaryFunctionEvaluationEvent)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.functionEvaluationEvents.add(new FunctionEvaluationEvent(event.getFunction(), ((DfaSummaryFunctionEvaluationEvent)event).getPass(), Action.FINISH));
        long localMem = this.memory(event.getProvider());
        ((Map)this.memoryOfLocalProvider).put(new FunctionEvalID(event.getFunction(), ((DfaSummaryFunctionEvaluationEvent)event).getPass()), localMem);
        this.memoryOfCollectionProviders.addAndGet(this.memory(((DfaSummaryFunctionEvaluationEvent)event).getSummaryProvider()));
        this.memoryOfCollectionProviders.addAndGet(this.memory(((DfaSummaryFunctionEvaluationEvent)event).getForSecondPassProvider()));
    }

    @Override
    public void afterAllPasses(@NotNull RMLInstancesProvider globalProvider, long startTime, @Nullable Long storageSize) {
        Intrinsics.checkNotNullParameter((Object)globalProvider, (String)"globalProvider");
        this.memoryOfGlobalProvider = this.memory(globalProvider);
    }

    private final long memory(RMLInstancesProvider $this$memory) {
        return $this$memory.getBddMemoryStat().getAmortizedTotalBytes();
    }

    private final double byteToMb(Number $this$byteToMb) {
        return $this$byteToMb.doubleValue() / (double)1000000;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$Action;", "", "<init>", "(Ljava/lang/String;I)V", "START", "FINISH", "intellij.rml.dfa.impl"})
    private static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action START = new Action();
        public static final /* enum */ Action FINISH = new Action();
        private static final /* synthetic */ Action[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        @NotNull
        public static EnumEntries<Action> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = actionArray = new Action[]{Action.START, Action.FINISH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$FunctionEvalID;", "", "attr", "Lcom/intellij/rml/dfa/attributes/Attribute;", "pass", "Lcom/intellij/rml/dfa/AnalysisPass;", "<init>", "(Lcom/intellij/rml/dfa/attributes/Attribute;Lcom/intellij/rml/dfa/AnalysisPass;)V", "getAttr", "()Lcom/intellij/rml/dfa/attributes/Attribute;", "getPass", "()Lcom/intellij/rml/dfa/AnalysisPass;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rml.dfa.impl"})
    private static final class FunctionEvalID {
        @NotNull
        private final Attribute attr;
        @NotNull
        private final AnalysisPass pass;

        public FunctionEvalID(@NotNull Attribute attr, @NotNull AnalysisPass pass) {
            Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            this.attr = attr;
            this.pass = pass;
        }

        @NotNull
        public final Attribute getAttr() {
            return this.attr;
        }

        @NotNull
        public final AnalysisPass getPass() {
            return this.pass;
        }

        @NotNull
        public final Attribute component1() {
            return this.attr;
        }

        @NotNull
        public final AnalysisPass component2() {
            return this.pass;
        }

        @NotNull
        public final FunctionEvalID copy(@NotNull Attribute attr, @NotNull AnalysisPass pass) {
            Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            return new FunctionEvalID(attr, pass);
        }

        public static /* synthetic */ FunctionEvalID copy$default(FunctionEvalID functionEvalID, Attribute attribute, AnalysisPass analysisPass, int n, Object object) {
            if ((n & 1) != 0) {
                attribute = functionEvalID.attr;
            }
            if ((n & 2) != 0) {
                analysisPass = functionEvalID.pass;
            }
            return functionEvalID.copy(attribute, analysisPass);
        }

        @NotNull
        public String toString() {
            return "FunctionEvalID(attr=" + this.attr + ", pass=" + this.pass + ")";
        }

        public int hashCode() {
            int result = this.attr.hashCode();
            result = result * 31 + this.pass.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FunctionEvalID)) {
                return false;
            }
            FunctionEvalID functionEvalID = (FunctionEvalID)other;
            if (!Intrinsics.areEqual((Object)this.attr, (Object)functionEvalID.attr)) {
                return false;
            }
            return this.pass == functionEvalID.pass;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$FunctionEvaluationEvent;", "", "attr", "Lcom/intellij/rml/dfa/attributes/Attribute;", "pass", "Lcom/intellij/rml/dfa/AnalysisPass;", "action", "Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$Action;", "<init>", "(Lcom/intellij/rml/dfa/attributes/Attribute;Lcom/intellij/rml/dfa/AnalysisPass;Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$Action;)V", "getAction", "()Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$Action;", "id", "Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$FunctionEvalID;", "getId", "()Lcom/intellij/rml/dfa/impl/summaries/DfaMemoryMeasurement$FunctionEvalID;", "intellij.rml.dfa.impl"})
    private static final class FunctionEvaluationEvent {
        @NotNull
        private final Action action;
        @NotNull
        private final FunctionEvalID id;

        public FunctionEvaluationEvent(@NotNull Attribute attr, @NotNull AnalysisPass pass, @NotNull Action action) {
            Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            this.action = action;
            this.id = new FunctionEvalID(attr, pass);
        }

        @NotNull
        public final Action getAction() {
            return this.action;
        }

        @NotNull
        public final FunctionEvalID getId() {
            return this.id;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Action.values().length];
            try {
                nArray[Action.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.FINISH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

