/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.ui.LearningUiHighlightingManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltraining/ui/LearningHighlightPainter;", "Lcom/intellij/openapi/ui/AbstractPainter;", "startDate", "Ljava/util/Date;", "options", "Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "bounds", "Ljava/awt/Rectangle;", "<init>", "(Ljava/util/Date;Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;Ljava/awt/Rectangle;)V", "pulsationOffset", "", "previous", "", "executePaint", "", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "needsRepaint", "", "intellij.featuresTrainer"})
public final class LearningHighlightPainter
extends AbstractPainter {
    @NotNull
    private final Date startDate;
    @NotNull
    private final LearningUiHighlightingManager.HighlightingOptions options;
    @NotNull
    private final Rectangle bounds;
    private final int pulsationOffset;
    private long previous;

    public LearningHighlightPainter(@NotNull Date startDate, @NotNull LearningUiHighlightingManager.HighlightingOptions options, @NotNull Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.startDate = startDate;
        this.options = options;
        this.bounds = bounds;
        this.pulsationOffset = this.options.getUsePulsation() ? 20 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
        Path2D.Double double_;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle r = this.bounds;
        long time = new Date().getTime();
        long delta = time - this.startDate.getTime();
        this.previous = time;
        int shift = this.pulsationOffset != 0 && delta / (long)1000 % (long)4 == 2L ? (int)Math.abs((delta / (long)25 + (long)20) % (long)40 - (long)20) : 0;
        double alphaCycle = (double)LearningHighlightPainter.executePaint$cyclicNumber(1000, delta) / (double)1000;
        Color color = ColorUtil.withAlpha((Color)Color.magenta, (double)0.8);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"withAlpha(...)");
        Color magenta = color;
        Color color2 = ColorUtil.withAlpha((Color)Color.orange, (double)0.8);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"withAlpha(...)");
        Color orange = color2;
        Color color3 = ColorUtil.withAlpha((Color)((Color)new JBColor(new Color(0, 0, shift * 10), new Color(255 - shift * 10, 255 - shift * 10, 255))), (double)((0.3 + 0.7 * (double)shift / 20.0) * alphaCycle));
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"withAlpha(...)");
        Color background = color3;
        float gradientShift = delta / (long)20;
        GradientPaint gp = new GradientPaint(gradientShift + 0.0f, gradientShift + 0.0f, magenta, gradientShift + (float)r.height, gradientShift + (float)r.height, orange, true);
        double x = r.x + this.pulsationOffset - shift;
        double y = r.y + this.pulsationOffset - shift;
        double width = r.width - (this.pulsationOffset - shift) * 2;
        double height = r.height - (this.pulsationOffset - shift) * 2;
        double arc = JBUI.scale((int)(this.options.isRoundedCorners() ? 16 : 2));
        double thickness = JBUI.scale((int)this.options.getThickness());
        RoundRectangle2D.Double outerRect = new RoundRectangle2D.Double(x, y, width, height, arc, arc);
        RoundRectangle2D.Double innerRect = new RoundRectangle2D.Double(x + thickness, y + thickness, width - thickness * (double)2, height - thickness * (double)2, arc - thickness * (double)2, arc - thickness * (double)2);
        Path2D.Double $this$executePaint_u24lambda_u240 = double_ = new Path2D.Double(0);
        boolean bl = false;
        $this$executePaint_u24lambda_u240.append(outerRect, false);
        $this$executePaint_u24lambda_u240.append(innerRect, false);
        $this$executePaint_u24lambda_u240.closePath();
        Path2D.Double border = double_;
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            GraphicsUtil.setupAAPainting((Graphics)g2d);
            if (this.options.getHighlightInside()) {
                RoundRectangle2D.Double rect = this.options.getHighlightBorder() ? innerRect : outerRect;
                g2d.setColor(background);
                g2d.fill(rect);
            }
            if (this.options.getHighlightBorder()) {
                g2d.setPaint(gp);
                g2d.fill(border);
            }
        }
        finally {
            g2d.dispose();
        }
    }

    public boolean needsRepaint() {
        return true;
    }

    private static final int executePaint$cyclicNumber(int amplitude, long change) {
        return (int)Math.abs(change % (long)(2 * amplitude) - (long)amplitude);
    }
}

