/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import org.jetbrains.coverage.org.objectweb.asm.ByteVector;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.SymbolTable;

public class Attribute {
    public final String type;
    private byte[] content;
    Attribute nextAttribute;

    /*
     * WARNING - void declaration
     */
    protected Attribute(String type) {
        void var1_1;
        this.type = var1_1;
    }

    public boolean isUnknown() {
        return true;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    protected Label[] getLabels() {
        return new Label[0];
    }

    /*
     * WARNING - void declaration
     */
    protected Attribute read(ClassReader classReader, int offset, int length, char[] charBuffer, int codeAttributeOffset, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        Attribute attribute = new Attribute(this.type);
        new Attribute(this.type).content = new byte[length];
        System.arraycopy(var1_1.classFileBuffer, (int)var2_2, attribute.content, 0, (int)var3_3);
        return attribute;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
        return new ByteVector(this.content);
    }

    /*
     * WARNING - void declaration
     */
    final int getAttributeCount() {
        void var1_1;
        int count = 0;
        Attribute attribute = this;
        while (attribute != null) {
            ++count;
            attribute = attribute.nextAttribute;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final int computeAttributesSize(SymbolTable symbolTable) {
        void var2_2;
        void var1_1;
        Object code = null;
        return this.computeAttributesSize((SymbolTable)var1_1, (byte[])var2_2, 0, -1, -1);
    }

    final int computeAttributesSize(SymbolTable symbolTable, byte[] code, int codeLength, int maxStack, int maxLocals) {
        ClassWriter classWriter = symbolTable.classWriter;
        int size = 0;
        Attribute attribute = this;
        while (attribute != null) {
            symbolTable.addConstantUtf8(attribute.type);
            size += 6 + attribute.write((ClassWriter)classWriter, (byte[])code, (int)codeLength, (int)maxStack, (int)maxLocals).length;
            attribute = attribute.nextAttribute;
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    static int computeAttributesSize(SymbolTable symbolTable, int accessFlags, int signatureIndex) {
        void var3_3;
        void var1_1;
        void var2_2;
        int size = 0;
        if ((accessFlags & 0x1000) != 0 && symbolTable.getMajorVersion() < 49) {
            symbolTable.addConstantUtf8("Synthetic");
            size += 6;
        }
        if (var2_2 != false) {
            symbolTable.addConstantUtf8("Signature");
            size += 8;
        }
        if ((var1_1 & 0x20000) != 0) {
            SymbolTable symbolTable2;
            symbolTable2.addConstantUtf8("Deprecated");
            size += 6;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    final void putAttributes(SymbolTable symbolTable, ByteVector output) {
        void var2_2;
        void var3_3;
        void var1_1;
        Object code = null;
        this.putAttributes((SymbolTable)var1_1, (byte[])var3_3, 0, -1, -1, (ByteVector)var2_2);
    }

    final void putAttributes(SymbolTable symbolTable, byte[] code, int codeLength, int maxStack, int maxLocals, ByteVector output) {
        ClassWriter classWriter = symbolTable.classWriter;
        Attribute attribute = this;
        while (attribute != null) {
            ByteVector attributeContent = attribute.write(classWriter, code, codeLength, maxStack, maxLocals);
            output.putShort(symbolTable.addConstantUtf8(attribute.type)).putInt(attributeContent.length);
            output.putByteArray(attributeContent.data, 0, attributeContent.length);
            attribute = attribute.nextAttribute;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void putAttributes(SymbolTable symbolTable, int accessFlags, int signatureIndex, ByteVector output) {
        void var1_1;
        if ((accessFlags & 0x1000) != 0 && symbolTable.getMajorVersion() < 49) {
            output.putShort(symbolTable.addConstantUtf8("Synthetic")).putInt(0);
        }
        if (signatureIndex != 0) {
            void var2_2;
            output.putShort(symbolTable.addConstantUtf8("Signature")).putInt(2).putShort((int)var2_2);
        }
        if ((var1_1 & 0x20000) != 0) {
            SymbolTable symbolTable2;
            void var3_3;
            var3_3.putShort(symbolTable2.addConstantUtf8("Deprecated")).putInt(0);
        }
    }

    static final class Set {
        private int size;
        private Attribute[] data = new Attribute[6];

        Set() {
        }

        final void addAttributes(Attribute attributeList) {
            Attribute attribute = attributeList;
            while (attribute != null) {
                if (!this.contains(attribute)) {
                    this.add(attribute);
                }
                attribute = attribute.nextAttribute;
            }
        }

        /*
         * WARNING - void declaration
         */
        final Attribute[] toArray() {
            void var1_1;
            Attribute[] result = new Attribute[this.size];
            System.arraycopy(this.data, 0, result, 0, this.size);
            return var1_1;
        }

        private boolean contains(Attribute attribute) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.data[i].type.equals(attribute.type)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private void add(Attribute attribute) {
            void var1_1;
            if (this.size >= this.data.length) {
                void var2_2;
                Attribute[] newData = new Attribute[this.data.length + 6];
                System.arraycopy(this.data, 0, newData, 0, this.size);
                this.data = var2_2;
            }
            this.data[this.size++] = var1_1;
        }
    }
}

