/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jdbc.inspection.fix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.dialects.base.SqlObjectBuilderImplKt;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationAppender;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.data.utils.SpringDataBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014 \f*\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b0\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/spring/data/jdbc/inspection/fix/AddKeyColumnFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "annotation", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "Lorg/jetbrains/annotations/NotNull;", "annotationText", "", "Lcom/intellij/openapi/util/NlsSafe;", "kotlin.jvm.PlatformType", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.spring.data"})
public final class AddKeyColumnFix
implements LocalQuickFix {
    @NotNull
    private final FileType fileType;
    private final String annotationText;

    public AddKeyColumnFix(@NotNull PsiElement annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        FileType fileType = annotation.getContainingFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        this.fileType = fileType;
        this.annotationText = annotation.getText();
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringDataBundle.message("spring.data.jdbc.mapped.collection.key.column.fix.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String command = SpringDataBundle.message("spring.data.jdbc.mapped.collection.key.column.fix.command", new Object[0]);
        PsiFile[] psiFileArray = new PsiFile[]{descriptor.getPsiElement().getContainingFile()};
        WriteCommandAction.runWriteCommandAction((Project)project, (String)command, null, () -> AddKeyColumnFix.applyFix$lambda$0(descriptor, project), (PsiFile[])psiFileArray);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        String string2 = this.annotationText;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"annotationText");
        if (StringsKt.endsWith$default((String)string2, (String)")", (boolean)false, (int)2, null)) {
            String string3 = this.annotationText;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"annotationText");
            string = StringsKt.removeSuffix((String)string3, (CharSequence)")") + ", keyColumn = \"\")";
        } else {
            string = this.annotationText + "(keyColumn = \"\")";
        }
        String modifiedText = string;
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff(this.fileType, this.annotationText, modifiedText);
    }

    private static final void applyFix$lambda$0(ProblemDescriptor $descriptor, Project $project) {
        PsiElement psiElement;
        PsiElement psiElement2 = $descriptor.getPsiElement();
        if (psiElement2 == null) {
            return;
        }
        PsiElement annotation = psiElement2;
        AnnotationAppender annotationAppender = (AnnotationAppender)AnnotationAppender.Companion.getInstance(annotation);
        if (annotationAppender == null || (psiElement = annotationAppender.addAnnotationParameterValue(annotation, "keyColumn", "\"\"")) == null) {
            return;
        }
        PsiElement psiElement3 = psiElement;
        Editor editor = FileEditorManager.getInstance((Project)$project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        editor2.getCaretModel().moveToOffset(SqlObjectBuilderImplKt.getStartOffset((PsiElement)psiElement3) + 1);
    }
}

