/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.completion.YamlKeyCompletionInsertHandler;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

final class SpringBootApplicationYamlDeprecationFixFactory {
    SpringBootApplicationYamlDeprecationFixFactory() {
    }

    @NotNull
    static @NotNull LocalQuickFix @NotNull [] getDeprecationFixes(PsiElement keyElement, MetaConfigKey configKey, boolean isOnTheFly) {
        String replacement = configKey.getDeprecation().getReplacement();
        if (replacement == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                SpringBootApplicationYamlDeprecationFixFactory.$$$reportNull$$$0(0);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (SpringBootApplicationYamlDeprecationFixFactory.replacementKeyExists(keyElement, replacement)) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                SpringBootApplicationYamlDeprecationFixFactory.$$$reportNull$$$0(1);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new UseReplacementKeyFix(keyElement, replacement, configKey, isOnTheFly)};
        if (localQuickFixArray == null) {
            SpringBootApplicationYamlDeprecationFixFactory.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    private static boolean replacementKeyExists(PsiElement keyElement, String replacement) {
        ConfigYamlAccessor accessor = new ConfigYamlAccessor(keyElement, (MetaConfigKeyManager)SpringBootApplicationMetaConfigKeyManager.getInstance());
        YAMLKeyValue existingReplacement = accessor.findExistingKey(replacement);
        return existingReplacement != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlDeprecationFixFactory", "getDeprecationFixes"));
    }

    private static final class UseReplacementKeyFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myReplacement;
        @FileModifier.SafeFieldForPreview
        private final MetaConfigKey myConfigKey;
        private final boolean myIsOnTheFly;

        private UseReplacementKeyFix(PsiElement keyElement, String replacement, MetaConfigKey configKey, boolean isOnTheFly) {
            super(keyElement);
            this.myReplacement = replacement;
            this.myConfigKey = configKey;
            this.myIsOnTheFly = isOnTheFly;
        }

        @NotNull
        public String getText() {
            String string = SpringBootApiBundle.message((String)"application.config.replacement.quick.fix", (Object[])new Object[]{this.myReplacement});
            if (string == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            boolean isPreview;
            YAMLValue existingValueCopy;
            if (project == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(4);
            }
            if (SpringBootApplicationYamlDeprecationFixFactory.replacementKeyExists(startElement, this.myReplacement)) {
                return;
            }
            YAMLKeyValue existingKey = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)startElement, YAMLKeyValue.class);
            if (existingKey == null) {
                return;
            }
            String existingKeyName = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)existingKey);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)startElement);
            assert (module != null) : "could not find module for deprecated element " + String.valueOf(startElement);
            SpringBootApplicationMetaConfigKeyManager metaConfigKeyManager = SpringBootApplicationMetaConfigKeyManager.getInstance();
            MetaConfigKeyManager.ConfigKeyNameBinder binder = metaConfigKeyManager.getConfigKeyNameBinder(module);
            if (!binder.bindsTo(this.myConfigKey, existingKeyName)) {
                return;
            }
            ConfigYamlAccessor accessor = new ConfigYamlAccessor(startElement, (MetaConfigKeyManager)metaConfigKeyManager);
            YAMLValue existingValue = existingKey.getValue();
            YAMLValue yAMLValue = existingValueCopy = existingValue == null ? null : (YAMLValue)existingValue.copy();
            if (existingValueCopy instanceof YAMLSequence) {
                YamlKeyCompletionInsertHandler.trimSequenceItemIndents((YAMLSequence)((YAMLSequence)existingValueCopy));
            }
            YAMLKeyValue replacementKeyValue = accessor.create(this.myReplacement, !(isPreview = editor instanceof ImaginaryEditor));
            assert (replacementKeyValue != null);
            YAMLMapping mapping = existingKey.getParentMapping();
            assert (existingKey.getParentMapping() != null);
            UseReplacementKeyFix.deleteKeyValuesRecursively(mapping, existingKey, Set.of(replacementKeyValue));
            if (existingValueCopy != null) {
                MetaConfigKey replacementMetaConfigKey = metaConfigKeyManager.findApplicationMetaConfigKey(module, this.myReplacement);
                if (replacementMetaConfigKey != null && replacementMetaConfigKey.getType() != null && this.myConfigKey.getType() != null && !this.myConfigKey.getType().isAssignableFrom(replacementMetaConfigKey.getType())) {
                    if (editor == null) {
                        return;
                    }
                    ASTNode[] colons = replacementKeyValue.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.COLON}));
                    assert (colons.length == 1);
                    ASTNode colon = colons[0];
                    editor.getCaretModel().moveToOffset(colon.getTextRange().getEndOffset());
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)" ");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    if (!isPreview) {
                        AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
                    }
                    return;
                }
                replacementKeyValue.setValue(existingValueCopy);
            }
            if (this.myIsOnTheFly && !isPreview) {
                replacementKeyValue.navigate(true);
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SpringBootApiBundle.message((String)"application.config.replacement.quick.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            IntentionPreviewInfo info;
            if (project == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(6);
            }
            if (previewDescriptor == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(7);
            }
            IntentionPreviewInfo intentionPreviewInfo = (info = super.generatePreview(project, previewDescriptor)) == IntentionPreviewInfo.DIFF ? IntentionPreviewInfo.DIFF_NO_TRIM : info;
            if (intentionPreviewInfo == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }

        private static void deleteKeyValuesRecursively(YAMLMapping mapping, YAMLKeyValue keyValue, Collection<YAMLKeyValue> safeValues) {
            mapping.deleteKeyValue(keyValue);
            for (YAMLKeyValue value : mapping.getKeyValues()) {
                if (value.getValue() == null && !safeValues.contains(value)) continue;
                return;
            }
            YAMLKeyValue parentKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)mapping, YAMLKeyValue.class);
            YAMLMapping parentMapping = parentKeyValue != null ? parentKeyValue.getParentMapping() : null;
            mapping.delete();
            if (parentMapping != null) {
                UseReplacementKeyFix.deleteKeyValuesRecursively(parentMapping, parentKeyValue, safeValues);
            } else if (parentKeyValue != null) {
                YAMLUtil.deleteSurroundingWhitespace((PsiElement)parentKeyValue);
                parentKeyValue.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlDeprecationFixFactory$UseReplacementKeyFix";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlDeprecationFixFactory$UseReplacementKeyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

