/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40;

import com.intellij.maven.server.m40.compat.Maven40InvokerRequestFactory;
import com.intellij.maven.server.m40.utils.ExceptionUtils;
import com.intellij.maven.server.m40.utils.Maven40ApiModelConverter;
import com.intellij.maven.server.m40.utils.Maven40EffectivePomDumper;
import com.intellij.maven.server.m40.utils.Maven40ExecutionResult;
import com.intellij.maven.server.m40.utils.Maven40ImporterSpy;
import com.intellij.maven.server.m40.utils.Maven40Invoker;
import com.intellij.maven.server.m40.utils.Maven40ModelConverter;
import com.intellij.maven.server.m40.utils.Maven40ProjectResolver;
import com.intellij.maven.server.m40.utils.Maven40RepositorySystemSessionFactory;
import com.intellij.maven.server.m40.utils.Maven40ServerConsoleLogger;
import com.intellij.maven.server.m40.utils.Maven40Sl4jLoggerWrapper;
import com.intellij.maven.server.m40.utils.Maven40Slf4jServiceProvider;
import com.intellij.maven.server.m40.utils.Maven40TransferListenerAdapter;
import com.intellij.maven.server.m40.utils.Maven40WorkspaceMapReader;
import com.intellij.maven.server.telemetry.MavenServerOpenTelemetry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.DownloadedArtifact;
import org.apache.maven.api.Node;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Logger;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.model.Source;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.ArtifactResolverResult;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.api.services.model.ModelResolverException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.cling.invoker.BaseParser;
import org.apache.maven.cling.invoker.ProtoLookup;
import org.apache.maven.cling.invoker.mvn.MavenParser;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProfileActivation;
import org.apache.maven.internal.impl.DefaultSessionFactory;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.jline.JLineMessageBuilderFactory;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.resolver.MavenChainedWorkspaceReader;
import org.apache.maven.resolver.RepositorySystemSessionFactory;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenSource;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.LongRunningTaskInput;
import org.jetbrains.idea.maven.server.MavenArtifactResolutionRequest;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenConfigParseException;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenGoalExecutionRequest;
import org.jetbrains.idea.maven.server.MavenGoalExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerConfigUtil;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;
import org.jetbrains.idea.maven.server.MavenServerEmbeddedBase;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.MavenServerResponse;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.ParallelRunnerForServer;
import org.jetbrains.idea.maven.server.PluginResolutionRequest;
import org.jetbrains.idea.maven.server.PluginResolutionResponse;
import org.jetbrains.idea.maven.server.PomHashMap;
import org.jetbrains.idea.maven.server.ProjectResolutionRequest;
import org.jetbrains.idea.maven.server.security.MavenToken;

public class Maven40ServerEmbedderImpl
extends MavenServerEmbeddedBase {
    @NotNull
    private final Maven40Invoker myMavenInvoker;
    @NotNull
    private final Lookup myContainer;
    private final Maven40ServerConsoleLogger myConsoleWrapper;
    private final boolean myAlwaysUpdateSnapshots;
    @NotNull
    private final MavenRepositorySystem myRepositorySystem;
    @NotNull
    private final Maven40ImporterSpy myImporterSpy;
    @NotNull
    protected final MavenEmbedderSettings myEmbedderSettings;

    public Maven40ServerEmbedderImpl(MavenEmbedderSettings settings) {
        InvokerRequest invokerRequest;
        String userSettingsPath;
        String globalSettingsPath;
        this.myEmbedderSettings = settings;
        String mmpDir = settings.getMultiModuleProjectDirectory();
        String multiModuleProjectDirectory = mmpDir == null ? "" : mmpDir;
        MavenServerSettings serverSettings = settings.getSettings();
        String mh = serverSettings.getMavenHomePath();
        String mavenHome = null == mh ? "" : mh;
        this.myConsoleWrapper = new Maven40ServerConsoleLogger();
        this.myConsoleWrapper.setThreshold(serverSettings.getLoggingLevel());
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        this.myMavenInvoker = new Maven40Invoker(ProtoLookup.builder().addMapping(ClassWorld.class, (Object)classWorld).build());
        String userHomeProperty = System.getProperty("user.home");
        String userHome = userHomeProperty == null ? multiModuleProjectDirectory : userHomeProperty;
        Path mavenHomeDirectory = Maven40ServerEmbedderImpl.getCanonicalPath(Paths.get(mavenHome, new String[0]));
        Path userHomeDirectory = Maven40ServerEmbedderImpl.getCanonicalPath(Paths.get(userHome, new String[0]));
        Path cwd = Maven40ServerEmbedderImpl.getCanonicalPath(Paths.get(multiModuleProjectDirectory, new String[0]));
        ArrayList<Object> commandLineOptions = new ArrayList<Object>(serverSettings.getUserProperties().size());
        for (Map.Entry<Object, Object> each : serverSettings.getUserProperties().entrySet()) {
            commandLineOptions.add("-D" + String.valueOf(each.getKey()) + "=" + String.valueOf(each.getValue()));
        }
        if (serverSettings.getLocalRepositoryPath() != null) {
            commandLineOptions.add("-Dmaven.repo.local=" + serverSettings.getLocalRepositoryPath());
        }
        if (serverSettings.isUpdateSnapshots()) {
            commandLineOptions.add("-U");
        }
        if (serverSettings.getLoggingLevel() == 0) {
            commandLineOptions.add("-X");
            commandLineOptions.add("-e");
        } else if (serverSettings.getLoggingLevel() == 5) {
            commandLineOptions.add("-q");
        }
        String mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args");
        if (mavenEmbedderCliOptions != null) {
            commandLineOptions.addAll(StringUtilRt.splitHonorQuotes((String)mavenEmbedderCliOptions, (char)' '));
        }
        if ((globalSettingsPath = serverSettings.getGlobalSettingsPath()) != null && new File(globalSettingsPath).isFile()) {
            commandLineOptions.add("-is");
            commandLineOptions.add(globalSettingsPath);
        }
        if ((userSettingsPath = serverSettings.getUserSettingsPath()) != null && new File(userSettingsPath).isFile()) {
            commandLineOptions.add("-s");
            commandLineOptions.add(userSettingsPath);
        }
        if (serverSettings.isOffline()) {
            commandLineOptions.add("-o");
        }
        System.setProperty("slf4j.provider", Maven40Slf4jServiceProvider.class.getName());
        commandLineOptions.add("-raw-streams");
        commandLineOptions.add("true");
        Maven40ServerEmbedderImpl.initLogging(this.myConsoleWrapper);
        ParserRequest parserRequest = ParserRequest.builder((String)"", (String)"", commandLineOptions, (MessageBuilderFactory)new JLineMessageBuilderFactory()).userHome(userHomeDirectory).mavenHome(mavenHomeDirectory).cwd(cwd).build();
        MavenParser mavenParser = new MavenParser(){

            public Path getRootDirectory(BaseParser.LocalContext context) {
                Path rootDir = super.getRootDirectory(context);
                if (null == rootDir) {
                    Path topDirectory = context.topDirectory;
                    MavenServerGlobals.getLogger().warn("Root dir not found for " + String.valueOf(topDirectory));
                    return topDirectory;
                }
                return rootDir;
            }
        };
        ArrayList entries = new ArrayList();
        try {
            invokerRequest = Maven40InvokerRequestFactory.createProxy(mavenParser.parseInvocation(parserRequest));
            entries.addAll(invokerRequest.parserRequest().logger().drain());
            this.myContainer = this.myMavenInvoker.invokeAndGetContext((InvokerRequest)invokerRequest).lookup;
        }
        catch (InvokerException.ExitException e) {
            StringBuilder message = new StringBuilder(e.getMessage());
            for (Logger.Entry entry : entries) {
                if (entry.level() != Logger.Level.ERROR) continue;
                message.append("\n").append(entry.error().getMessage());
            }
            throw new MavenConfigParseException(message.toString(), multiModuleProjectDirectory, (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.myContainer == null) {
            throw new IllegalStateException("Cannot create maven container");
        }
        this.myAlwaysUpdateSnapshots = commandLineOptions.contains("-U") || commandLineOptions.contains("--update-snapshots");
        Map mySystemProperties = invokerRequest.systemProperties();
        if (serverSettings.getProjectJdk() != null) {
            mySystemProperties.put("java.home", serverSettings.getProjectJdk());
        }
        this.myRepositorySystem = this.getComponent(MavenRepositorySystem.class);
        Maven40ImporterSpy importerSpy = this.getComponentIfExists(Maven40ImporterSpy.class);
        if (importerSpy == null) {
            importerSpy = new Maven40ImporterSpy();
        }
        this.myImporterSpy = importerSpy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public MavenServerResponse<ArrayList<MavenServerExecutionResult>> resolveProjects(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ProjectResolutionRequest request, MavenToken token) {
        if (longRunningTaskInput == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(0);
        }
        if (request == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(1);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
        MavenServerOpenTelemetry telemetry = MavenServerOpenTelemetry.from((TelemetryContext)longRunningTaskInput.getTelemetryContext());
        List filesToResolve = request.getFilesToResolve();
        PomHashMap pomHashMap = request.getPomHashMap();
        List activeProfiles = request.getActiveProfiles();
        List inactiveProfiles = request.getInactiveProfiles();
        MavenWorkspaceMap workspaceMap = request.getWorkspaceMap();
        boolean updateSnapshots = this.myAlwaysUpdateSnapshots || request.updateSnapshots();
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, pomHashMap.size(), this.myConsoleWrapper);
        Maven40ProjectResolver projectResolver = new Maven40ProjectResolver(this, telemetry, updateSnapshots, this.myImporterSpy, task, filesToResolve, pomHashMap, activeProfiles, inactiveProfiles, workspaceMap, this.getLocalRepositoryFile(), request.getUserProperties(), Maven40ServerEmbedderImpl.canResolveDependenciesInParallel());
        this.customizeComponents(workspaceMap);
        ArrayList result = (ArrayList)telemetry.callWithSpan("projectResolver.resolveProjects", () -> projectResolver.resolveProjects());
        telemetry.shutdown();
        MavenServerResponse mavenServerResponse = new MavenServerResponse((Serializable)result, this.getLongRunningTaskStatus(longRunningTaskId, token));
        this.resetComponents();
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(2);
        }
        return mavenServerResponse2;
        {
            catch (Throwable throwable) {
                this.resetComponents();
                throw throwable;
            }
        }
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    private static boolean canResolveDependenciesInParallel() {
        return true;
    }

    private File getLocalRepositoryFile() {
        return new File(this.myEmbedderSettings.getSettings().getLocalRepositoryPath());
    }

    public Collection<MavenProjectProblem> collectProblems(@Nullable File file, @NotNull Collection<? extends Exception> exceptions, @NotNull List<? extends ModelProblem> modelProblems) {
        if (exceptions == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(3);
        }
        if (modelProblems == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(4);
        }
        LinkedHashSet<MavenProjectProblem> problems = new LinkedHashSet<MavenProjectProblem>();
        for (Throwable throwable : exceptions) {
            problems.addAll(this.collectExceptionProblems(file, throwable));
        }
        for (ModelProblem modelProblem : modelProblems) {
            Object source = !StringUtilRt.isEmptyOrSpaces((CharSequence)modelProblem.getSource()) ? modelProblem.getSource() + ":" + modelProblem.getLineNumber() + ":" + modelProblem.getColumnNumber() : (file == null ? "" : file.getPath());
            String message = "Maven model problem: " + modelProblem.getMessage() + " at " + modelProblem.getSource() + ":" + modelProblem.getLineNumber() + ":" + modelProblem.getColumnNumber();
            if (modelProblem.getSeverity() == ModelProblem.Severity.ERROR) {
                this.myConsoleWrapper.error(message);
            } else {
                this.myConsoleWrapper.warn(message);
            }
            Exception problemException = modelProblem.getException();
            if (problemException != null) {
                List<MavenProjectProblem> exceptionProblems = this.collectExceptionProblems(file, problemException);
                if (exceptionProblems.isEmpty()) {
                    this.myConsoleWrapper.error("Maven model problem", problemException);
                    problems.add(MavenProjectProblem.createStructureProblem((String)source, (String)modelProblem.getMessage()));
                    continue;
                }
                problems.addAll(exceptionProblems);
                continue;
            }
            problems.add(MavenProjectProblem.createStructureProblem((String)source, (String)modelProblem.getMessage(), (boolean)false));
        }
        return problems;
    }

    private List<MavenProjectProblem> collectExceptionProblems(@Nullable File file, Throwable ex) {
        String path;
        ArrayList<MavenProjectProblem> result = new ArrayList<MavenProjectProblem>();
        if (ex == null) {
            return result;
        }
        MavenServerGlobals.getLogger().print(ExceptionUtils.getFullStackTrace(ex));
        this.myConsoleWrapper.info("Validation error:", ex);
        Artifact problemTransferArtifact = Maven40ServerEmbedderImpl.getProblemTransferArtifact(ex);
        if (ex instanceof IllegalStateException && ex.getCause() != null) {
            ex = ex.getCause();
        }
        String string = path = file == null ? "" : file.getPath();
        if (path.isEmpty() && ex instanceof ProjectBuildingException) {
            File pomFile = ((ProjectBuildingException)ex).getPomFile();
            String string2 = path = pomFile == null ? "" : pomFile.getPath();
        }
        if (ex instanceof ProjectBuildingException) {
            String causeMessage = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
            result.add(MavenProjectProblem.createStructureProblem((String)path, (String)causeMessage));
        } else if (ex.getStackTrace().length > 0 && ex.getClass().getPackage().getName().equals("groovy.lang")) {
            this.myConsoleWrapper.error("Maven server structure problem", ex);
            StackTraceElement traceElement = ex.getStackTrace()[0];
            result.add(MavenProjectProblem.createStructureProblem((String)(traceElement.getFileName() + ":" + traceElement.getLineNumber()), (String)ex.getMessage()));
        } else if (problemTransferArtifact != null) {
            this.myConsoleWrapper.error("[server] Maven transfer artifact problem: " + String.valueOf(problemTransferArtifact));
            String message = Maven40ServerEmbedderImpl.getRootMessage(ex);
            MavenArtifact mavenArtifact = Maven40ModelConverter.convertArtifact(problemTransferArtifact, this.getLocalRepositoryFile());
            result.add(MavenProjectProblem.createRepositoryProblem((String)path, (String)message, (boolean)false, (MavenArtifact)mavenArtifact));
        } else if (ex instanceof ModelResolverException) {
            this.myConsoleWrapper.error("Maven resolver problem", ex);
            result.add(MavenProjectProblem.createStructureProblem((String)path, (String)ex.getMessage(), (boolean)false));
        } else {
            this.myConsoleWrapper.error("Maven server structure problem", ex);
            result.add(MavenProjectProblem.createStructureProblem((String)path, (String)Maven40ServerEmbedderImpl.getRootMessage(ex), (boolean)false));
        }
        return result;
    }

    @NotNull
    public static String getRootMessage(Throwable each) {
        String baseMessage = each.getMessage() != null ? each.getMessage() : "";
        Throwable rootCause = ExceptionUtils.getRootCause(each);
        String rootMessage = rootCause != null ? rootCause.getMessage() : "";
        String string = Maven40ServerEmbedderImpl.isNotEmpty(rootMessage) ? rootMessage : baseMessage;
        if (string == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    @Nullable
    private static Artifact getProblemTransferArtifact(Throwable each) {
        Throwable[] throwables;
        for (Throwable throwable : throwables = ExceptionUtils.getThrowables(each)) {
            if (!(throwable instanceof ArtifactTransferException)) continue;
            return RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)((ArtifactTransferException)throwable).getArtifact());
        }
        return null;
    }

    private <T> T getComponent(Class<T> clazz, String roleHint) {
        return (T)this.myContainer.lookup(clazz, roleHint);
    }

    public <T> T getComponent(Class<T> clazz) {
        return (T)this.myContainer.lookup(clazz);
    }

    private <T> T getComponentIfExists(Class<T> clazz) {
        return this.myContainer.lookupOptional(clazz).orElse(null);
    }

    private <T> T getComponentIfExists(Class<T> clazz, String roleHint) {
        return this.myContainer.lookupOptional(clazz, roleHint).orElse(null);
    }

    public MavenExecutionRequest createRequest(File file, List<String> activeProfiles, List<String> inactiveProfiles) {
        return this.createRequest(file, activeProfiles, inactiveProfiles, new Properties());
    }

    public MavenExecutionRequest createRequest(@Nullable File file, @Nullable List<String> activeProfiles, @Nullable List<String> inactiveProfiles, @NotNull Properties customProperties) {
        if (customProperties == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(6);
        }
        try {
            MavenExecutionRequest request = this.myMavenInvoker.createMavenExecutionRequest();
            Maven40ServerEmbedderImpl.activateProfiles(activeProfiles, inactiveProfiles, request);
            Properties userProperties = request.getUserProperties();
            if (file != null) {
                userProperties.putAll((Map<?, ?>)MavenServerConfigUtil.getMavenAndJvmConfigPropertiesForNestedProjectDir((File)file.getParentFile()));
            }
            userProperties.putAll((Map<?, ?>)customProperties);
            request.setPom(file);
            return request;
        }
        catch (Exception e) {
            Maven40ServerEmbedderImpl.warn(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private static void activateProfiles(@Nullable List<String> activeProfiles, @Nullable List<String> inactiveProfiles, MavenExecutionRequest request) {
        ProfileActivation profileActivation = request.getProfileActivation();
        if (null != activeProfiles) {
            for (String profileId : activeProfiles) {
                profileActivation.addProfileActivation(profileId, true, false);
            }
        }
        if (null != inactiveProfiles) {
            for (String profileId : inactiveProfiles) {
                profileActivation.addProfileActivation(profileId, false, false);
            }
        }
    }

    public MavenExecutionResult executeWithMavenSession(@NotNull MavenExecutionRequest request, @NotNull MavenWorkspaceMap workspaceMap, @NotNull MavenServerConsoleIndicatorImpl indicator, Consumer<MavenSession> runnable) {
        if (request == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(7);
        }
        if (workspaceMap == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(9);
        }
        return this.executeWithMavenSession(request, workspaceMap, indicator, b -> {}, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExecutionResult executeWithMavenSession(@NotNull MavenExecutionRequest request, @NotNull MavenWorkspaceMap workspaceMap, @NotNull MavenServerConsoleIndicatorImpl indicator, @NotNull Consumer<RepositorySystemSession.SessionBuilder> builderModifier, Consumer<MavenSession> runnable) {
        if (request == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(10);
        }
        if (workspaceMap == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(12);
        }
        if (builderModifier == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(13);
        }
        RepositorySystemSessionFactory rsf = this.getComponent(RepositorySystemSessionFactory.class);
        Maven40RepositorySystemSessionFactory irsf = new Maven40RepositorySystemSessionFactory(rsf, workspaceMap, indicator, builderModifier);
        Maven40WorkspaceMapReader workspaceReader = new Maven40WorkspaceMapReader(workspaceMap);
        WorkspaceReader ideWorkspaceReader = this.getComponentIfExists(WorkspaceReader.class, "ide");
        SessionScope sessionScope = this.getComponent(SessionScope.class);
        DefaultSessionFactory defaultSessionFactory = this.getComponent(DefaultSessionFactory.class);
        LegacySupport legacySupport = this.getComponent(LegacySupport.class);
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        Maven40ServerEmbedderImpl maven40ServerEmbedderImpl = this;
        synchronized (maven40ServerEmbedderImpl) {
            sessionScope.enter();
            MavenChainedWorkspaceReader chainedWorkspaceReader = new MavenChainedWorkspaceReader(new WorkspaceReader[]{workspaceReader, ideWorkspaceReader});
            try (RepositorySystemSession.CloseableSession closeableSession = Maven40ServerEmbedderImpl.newCloseableSession(request, (WorkspaceReader)chainedWorkspaceReader, irsf);){
                MavenSession session = new MavenSession((RepositorySystemSession)closeableSession, request, (MavenExecutionResult)result);
                session.setSession((Session)defaultSessionFactory.newSession(session));
                sessionScope.seed(MavenSession.class, (Object)session);
                sessionScope.seed(Session.class, (Object)session.getSession());
                sessionScope.seed(InternalMavenSession.class, (Object)InternalMavenSession.from((Session)session.getSession()));
                legacySupport.setSession(session);
                this.afterSessionStart(session);
                runnable.accept(session);
            }
            finally {
                legacySupport.setSession(null);
                sessionScope.exit();
            }
        }
        return result;
    }

    private static RepositorySystemSession.CloseableSession newCloseableSession(MavenExecutionRequest request, WorkspaceReader workspaceReader, RepositorySystemSessionFactory repositorySessionFactory) {
        return repositorySessionFactory.newRepositorySessionBuilder(request).setWorkspaceReader(workspaceReader).build();
    }

    private void afterSessionStart(MavenSession mavenSession) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.getExtensionComponents(Collections.emptyList(), AbstractMavenLifecycleParticipant.class);
        for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
            Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
            try {
                listener.afterSessionStart(mavenSession);
            }
            catch (MavenExecutionException e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public <T> Collection<T> getExtensionComponents(Collection<MavenProject> projects, Class<T> role) {
        LinkedHashSet<T> foundComponents = new LinkedHashSet<T>(this.getContainer().lookupList(role));
        foundComponents.addAll(this.getProjectScopedExtensionComponents(projects, role));
        return foundComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Collection<T> getProjectScopedExtensionComponents(Collection<MavenProject> projects, Class<T> role) {
        if (projects == null) {
            return Collections.emptyList();
        }
        LinkedHashSet foundComponents = new LinkedHashSet();
        HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
        try {
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                currentThread.setContextClassLoader((ClassLoader)projectRealm);
                foundComponents.addAll(this.getContainer().lookupList(role));
            }
            LinkedHashSet linkedHashSet = foundComponents;
            return linkedHashSet;
        }
        finally {
            currentThread.setContextClassLoader(originalContextClassLoader);
        }
    }

    private static void warn(String message, Throwable e) {
        MavenServerGlobals.getLogger().warn((Throwable)new RuntimeException(message, e));
    }

    @NotNull
    private Lookup getContainer() {
        Lookup lookup = this.myContainer;
        if (lookup == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(14);
        }
        return lookup;
    }

    public MavenServerResponse<ArrayList<PluginResolutionResponse>> resolvePlugins(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ArrayList<PluginResolutionRequest> pluginResolutionRequests, boolean forceUpdateSnapshots, MavenToken token) {
        if (longRunningTaskInput == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(15);
        }
        if (pluginResolutionRequests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(16);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
        MavenServerOpenTelemetry telemetry = MavenServerOpenTelemetry.from((TelemetryContext)longRunningTaskInput.getTelemetryContext());
        try (LongRunningTask task = this.newLongRunningTask(longRunningTaskId, pluginResolutionRequests.size(), this.myConsoleWrapper);){
            MavenExecutionRequest request = this.createRequest(null, null, null);
            request.setTransferListener((TransferListener)new Maven40TransferListenerAdapter(task.getIndicator()));
            request.setUpdateSnapshots(this.myAlwaysUpdateSnapshots || forceUpdateSnapshots);
            ArrayList results = new ArrayList();
            this.executeWithMavenSession(request, MavenWorkspaceMap.empty(), task.getIndicator(), session -> {
                List<PluginResolutionData> resolutions = this.collectPluginResolutionData((MavenSession)session, pluginResolutionRequests);
                results.addAll(ParallelRunnerForServer.execute((boolean)false, resolutions, resolution -> this.resolvePlugin(task, resolution.mavenPluginId, resolution.resolveDependencies, resolution.dependencies, resolution.remoteRepos, session.getRepositorySession())));
            });
            telemetry.shutdown();
            MavenServerResponse mavenServerResponse = new MavenServerResponse(new ArrayList(results), this.getLongRunningTaskStatus(longRunningTaskId, token));
            return mavenServerResponse;
        }
    }

    @NotNull
    private List<PluginResolutionData> collectPluginResolutionData(MavenSession session, @NotNull ArrayList<PluginResolutionRequest> pluginResolutionRequests) {
        if (pluginResolutionRequests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(17);
        }
        ArrayList<PluginResolutionData> resolutions = new ArrayList<PluginResolutionData>();
        for (PluginResolutionRequest pluginResolutionRequest : pluginResolutionRequests) {
            MavenId mavenPluginId = pluginResolutionRequest.getMavenPluginId();
            List remoteRepos = RepositoryUtils.toRepos(this.map2ArtifactRepositories(session, pluginResolutionRequest.getRepositories(), false));
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            for (MavenId dependencyId : pluginResolutionRequest.getPluginDependencies()) {
                Dependency dependency = new Dependency();
                dependency.setGroupId(dependencyId.getGroupId());
                dependency.setArtifactId(dependencyId.getArtifactId());
                dependency.setVersion(dependencyId.getVersion());
                dependencies.add(dependency);
            }
            PluginResolutionData resolution = new PluginResolutionData(mavenPluginId, pluginResolutionRequest.resolvePluginDependencies(), dependencies, remoteRepos);
            resolutions.add(resolution);
        }
        ArrayList<PluginResolutionData> arrayList = resolutions;
        if (arrayList == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PluginResolutionResponse resolvePlugin(LongRunningTask task, MavenId mavenPluginId, boolean resolveDependencies, List<Dependency> dependencies, List<RemoteRepository> remoteRepos, RepositorySystemSession session) {
        PluginResolutionResponse pluginResolutionResponse;
        long startTime = System.currentTimeMillis();
        MavenArtifact mavenPluginArtifact = null;
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        if (task.isCanceled()) {
            return new PluginResolutionResponse(mavenPluginId, mavenPluginArtifact, artifacts);
        }
        try {
            Plugin plugin = new Plugin();
            plugin.setGroupId(mavenPluginId.getGroupId());
            plugin.setArtifactId(mavenPluginId.getArtifactId());
            plugin.setVersion(mavenPluginId.getVersion());
            plugin.setDependencies(dependencies);
            PluginDependenciesResolver pluginDependenciesResolver = this.getComponent(PluginDependenciesResolver.class);
            org.eclipse.aether.artifact.Artifact pluginArtifact = pluginDependenciesResolver.resolve(plugin, remoteRepos, session);
            DependencyFilter dependencyFilter = resolveDependencies ? null : new DependencyFilter(){

                public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                    return false;
                }
            };
            DependencyNode node = pluginDependenciesResolver.resolve(plugin, pluginArtifact, dependencyFilter, remoteRepos, session);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            for (org.eclipse.aether.artifact.Artifact artifact : nlg.getArtifacts(true)) {
                MavenArtifact mavenArtifact = Maven40ModelConverter.convertArtifact(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifact), this.getLocalRepositoryFile());
                if (!Objects.equals(artifact.getArtifactId(), plugin.getArtifactId()) || !Objects.equals(artifact.getGroupId(), plugin.getGroupId())) {
                    artifacts.add(mavenArtifact);
                    continue;
                }
                mavenPluginArtifact = mavenArtifact;
            }
            task.incrementFinishedRequests();
            PluginResolutionResponse pluginResolutionResponse2 = new PluginResolutionResponse(mavenPluginId, mavenPluginArtifact, artifacts);
            pluginResolutionResponse = pluginResolutionResponse2;
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
            PluginResolutionResponse pluginResolutionResponse3 = new PluginResolutionResponse(mavenPluginId, mavenPluginArtifact, artifacts);
            PluginResolutionResponse pluginResolutionResponse4 = pluginResolutionResponse3;
            if (pluginResolutionResponse4 == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(20);
            }
            return pluginResolutionResponse4;
        }
        finally {
            long totalTime = System.currentTimeMillis() - startTime;
            MavenServerGlobals.getLogger().debug("Resolved plugin " + String.valueOf(mavenPluginId) + " in " + totalTime + " ms");
        }
        if (pluginResolutionResponse == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(19);
        }
        return pluginResolutionResponse;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public @NotNull MavenServerResponse<@NotNull String> evaluateEffectivePom(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull File file, @NotNull ArrayList<String> activeProfiles, @NotNull ArrayList<String> inactiveProfiles, MavenToken token) {
        MavenServerResponse mavenServerResponse;
        LongRunningTask task;
        block13: {
            if (longRunningTaskInput == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(21);
            }
            if (file == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(22);
            }
            if (activeProfiles == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(23);
            }
            if (inactiveProfiles == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(24);
            }
            MavenServerUtil.checkToken((MavenToken)token);
            String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
            task = this.newLongRunningTask(longRunningTaskId, 1, this.myConsoleWrapper);
            String result = Maven40EffectivePomDumper.evaluateEffectivePom(this, task.getIndicator(), file, activeProfiles, inactiveProfiles);
            task.incrementFinishedRequests();
            mavenServerResponse = new MavenServerResponse((Serializable)((Object)result), this.getLongRunningTaskStatus(longRunningTaskId, token));
            if (task == null) break block13;
            task.close();
        }
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(25);
        }
        return mavenServerResponse2;
        {
            catch (Throwable throwable) {
                try {
                    if (task != null) {
                        try {
                            task.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapToSerializableRuntimeException(e);
                }
            }
        }
    }

    @NotNull
    public MavenServerResponse<ArrayList<MavenGoalExecutionResult>> executeGoal(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ArrayList<MavenGoalExecutionRequest> requests, @NotNull String goal, MavenToken token) {
        if (longRunningTaskInput == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(26);
        }
        if (requests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(27);
        }
        if (goal == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(28);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
        MavenServerOpenTelemetry telemetry = MavenServerOpenTelemetry.from((TelemetryContext)longRunningTaskInput.getTelemetryContext());
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, requests.size(), this.myConsoleWrapper);
        ArrayList<MavenGoalExecutionResult> results = this.executeGoal(task, requests, goal);
        telemetry.shutdown();
        MavenServerResponse mavenServerResponse = new MavenServerResponse(results, this.getLongRunningTaskStatus(longRunningTaskId, token));
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(29);
        }
        return mavenServerResponse2;
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    private ArrayList<MavenGoalExecutionResult> executeGoal(@NotNull LongRunningTask task, @NotNull Collection<MavenGoalExecutionRequest> requests, @NotNull String goal) {
        if (task == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(30);
        }
        if (requests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(31);
        }
        if (goal == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(32);
        }
        try {
            ArrayList<MavenGoalExecutionResult> results = new ArrayList<MavenGoalExecutionResult>();
            for (MavenGoalExecutionRequest request : requests) {
                if (task.isCanceled()) break;
                MavenGoalExecutionResult result = this.doExecute(request, goal);
                results.add(result);
                task.incrementFinishedRequests();
            }
            return results;
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    private MavenGoalExecutionResult doExecute(@NotNull MavenGoalExecutionRequest request, @NotNull String goal) {
        if (request == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(33);
        }
        if (goal == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(34);
        }
        File file = request.file();
        MavenExplicitProfiles profiles = request.profiles();
        ArrayList<String> activeProfiles = new ArrayList<String>(profiles.getEnabledProfiles());
        ArrayList<String> inactiveProfiles = new ArrayList<String>(profiles.getDisabledProfiles());
        MavenExecutionRequest mavenExecutionRequest = this.createRequest(file, activeProfiles, inactiveProfiles);
        mavenExecutionRequest.setGoals(Collections.singletonList(goal));
        Properties userProperties = request.userProperties();
        mavenExecutionRequest.setUserProperties(userProperties);
        List selectedProjects = request.selectedProjects();
        if (!selectedProjects.isEmpty()) {
            mavenExecutionRequest.setSelectedProjects(selectedProjects);
        }
        Maven maven = this.getComponent(Maven.class);
        MavenExecutionResult executionResult = maven.execute(mavenExecutionRequest);
        Maven40ExecutionResult result = new Maven40ExecutionResult(executionResult.getProject(), Maven40ServerEmbedderImpl.filterExceptions(executionResult.getExceptions()));
        return this.createEmbedderExecutionResult(file, result);
    }

    @NotNull
    private MavenGoalExecutionResult createEmbedderExecutionResult(@NotNull File file, Maven40ExecutionResult result) {
        if (file == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(35);
        }
        Collection<MavenProjectProblem> problems = this.collectProblems(file, result.getExceptions(), Collections.emptyList());
        MavenGoalExecutionResult.Folders folders = new MavenGoalExecutionResult.Folders();
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenGoalExecutionResult(false, file, folders, problems);
        }
        folders.setMavenSources(Maven40ServerEmbedderImpl.convertSourceRoots(file, mavenProject.getSourceRoots()));
        return new MavenGoalExecutionResult(true, file, folders, problems);
    }

    private static List<MavenSource> convertSourceRoots(File pomFile, List<Source> roots) {
        ArrayList<MavenSource> list = new ArrayList<MavenSource>();
        for (Source it : roots) {
            MavenSource convert = Maven40ModelConverter.convert(pomFile, it);
            list.add(convert);
        }
        return list;
    }

    private static List<MavenSource> convertSourceRoots(File pomFile, Collection<SourceRoot> roots) {
        ArrayList<MavenSource> list = new ArrayList<MavenSource>();
        for (SourceRoot it : roots) {
            MavenSource convert = Maven40ModelConverter.convert(pomFile, it);
            list.add(convert);
        }
        return list;
    }

    private static List<Exception> filterExceptions(List<Throwable> list) {
        for (Throwable throwable : list) {
            if (throwable instanceof Exception) continue;
            throw new RuntimeException(throwable);
        }
        return list;
    }

    @Nullable
    public MavenModel readModel(File file, MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            HashMap<String, FileModelSource> inputOptions = new HashMap<String, FileModelSource>();
            inputOptions.put("org.apache.maven.model.building.source", new FileModelSource(file));
            ModelReader reader = (ModelReader)this.myContainer.lookup(ModelReader.class);
            if (reader != null) {
                try {
                    Model model = reader.read(file, inputOptions);
                    return Maven40ModelConverter.convertModel(file, model);
                }
                catch (Exception e) {
                    MavenServerGlobals.getLogger().warn((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
        }
        return null;
    }

    public void release(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            this.myMavenInvoker.close();
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    @NotNull
    public MavenServerResponse<ArrayList<MavenArtifact>> resolveArtifacts(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ArrayList<MavenArtifactResolutionRequest> requests, MavenToken token) {
        if (longRunningTaskInput == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(36);
        }
        if (requests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(37);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
        MavenServerOpenTelemetry telemetry = MavenServerOpenTelemetry.from((TelemetryContext)longRunningTaskInput.getTelemetryContext());
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, requests.size(), this.myConsoleWrapper);
        ArrayList<MavenArtifact> artifacts = this.doResolveArtifacts(task, requests);
        telemetry.shutdown();
        MavenServerResponse mavenServerResponse = new MavenServerResponse(artifacts, this.getLongRunningTaskStatus(longRunningTaskId, token));
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(38);
        }
        return mavenServerResponse2;
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    @NotNull
    private ArrayList<MavenArtifact> doResolveArtifacts(@NotNull LongRunningTask task, @NotNull Collection<MavenArtifactResolutionRequest> requests) {
        ArrayList<MavenArtifact> arrayList;
        if (task == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(39);
        }
        if (requests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(40);
        }
        if (requests.isEmpty()) {
            return new ArrayList<MavenArtifact>();
        }
        try {
            boolean updateSnapshots = this.myAlwaysUpdateSnapshots || requests.iterator().next().updateSnapshots();
            MavenExecutionRequest executionRequest = this.createRequest(null, null, null);
            if (!requests.isEmpty() && updateSnapshots) {
                executionRequest.setUpdateSnapshots(true);
            }
            ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
            LinkedHashSet repos = new LinkedHashSet();
            for (MavenArtifactResolutionRequest request : requests) {
                repos.addAll(request.getRemoteRepositories());
            }
            this.executeWithMavenSession(executionRequest, MavenWorkspaceMap.empty(), task.getIndicator(), mavenSession -> {
                try {
                    List<ArtifactRepository> repositories = this.map2ArtifactRepositories((MavenSession)mavenSession, (List<MavenRemoteRepository>)new ArrayList<MavenRemoteRepository>(repos), updateSnapshots);
                    repositories.forEach(arg_0 -> ((MavenExecutionRequest)executionRequest).addRemoteRepository(arg_0));
                    RepositorySystem repositorySystem = this.getComponent(RepositorySystem.class);
                    for (MavenArtifactResolutionRequest request : requests) {
                        MavenArtifact artifact = this.tryResolveArtifact((MavenSession)mavenSession, request, repositorySystem, repositories);
                        artifacts.add(artifact);
                        task.incrementFinishedRequests();
                    }
                }
                catch (Exception e) {
                    throw this.wrapToSerializableRuntimeException(e);
                }
            });
            arrayList = artifacts;
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
        if (arrayList == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    private MavenArtifact tryResolveArtifact(MavenSession mavenSession, MavenArtifactResolutionRequest request, RepositorySystem repositorySystem, List<ArtifactRepository> repositories) {
        MavenArtifact mavenArtifact;
        try {
            ArtifactResult artifactResult = repositorySystem.resolveArtifact(mavenSession.getRepositorySession(), new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)this.createArtifact(request.getArtifactInfo())), RepositoryUtils.toRepos(repositories), null));
            mavenArtifact = Maven40ModelConverter.convertArtifact(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifactResult.getArtifact()), this.getLocalRepositoryFile());
        }
        catch (ArtifactResolutionException e) {
            MavenArtifact mavenArtifact2 = Maven40ModelConverter.convertArtifact(this.createArtifact(request.getArtifactInfo()), this.getLocalRepositoryFile());
            if (mavenArtifact2 == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(43);
            }
            return mavenArtifact2;
        }
        if (mavenArtifact == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(42);
        }
        return mavenArtifact;
    }

    private static void initLogging(Maven40ServerConsoleLogger consoleWrapper) {
        Maven40Sl4jLoggerWrapper.setCurrentWrapper(consoleWrapper);
    }

    private List<ArtifactRepository> map2ArtifactRepositories(@Nullable MavenSession session, List<MavenRemoteRepository> repositories, boolean forceResolveSnapshots) {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        for (MavenRemoteRepository each : repositories) {
            try {
                result.add(this.buildArtifactRepository(session, Maven40ModelConverter.toNativeRepository(each, forceResolveSnapshots)));
            }
            catch (InvalidRepositoryException e) {
                MavenServerGlobals.getLogger().warn((Throwable)e);
            }
        }
        return result;
    }

    private ArtifactRepository buildArtifactRepository(@Nullable MavenSession session, Repository repo) throws InvalidRepositoryException {
        RepositorySystemSession repositorySession;
        MavenRepositorySystem repositorySystem = this.myRepositorySystem;
        ArtifactRepository repository = MavenRepositorySystem.buildArtifactRepository((Repository)repo);
        RepositorySystemSession repositorySystemSession = repositorySession = session == null ? null : session.getRepositorySession();
        if (repositorySession != null) {
            repositorySystem.injectMirror(repositorySession, Collections.singletonList(repository));
            repositorySystem.injectProxy(repositorySession, Collections.singletonList(repository));
            repositorySystem.injectAuthentication(repositorySession, Collections.singletonList(repository));
        }
        return repository;
    }

    private Artifact createArtifact(MavenArtifactInfo info) {
        return this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getPackaging(), info.getClassifier());
    }

    public HashSet<MavenRemoteRepository> resolveRepositories(@NotNull ArrayList<MavenRemoteRepository> repositories, MavenToken token) {
        if (repositories == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(44);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            return new HashSet<MavenRemoteRepository>(Maven40ModelConverter.convertRemoteRepositories(this.map2ArtifactRepositories(null, new ArrayList<MavenRemoteRepository>(repositories), false)));
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public @NotNull MavenServerResponse<@NotNull MavenArtifactResolveResult> resolveProcessorPathEntries(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ArrayList<MavenArtifactInfo> artifacts, @NotNull ArrayList<MavenRemoteRepository> remoteRepositories, @NotNull HashMap<String, MavenArtifactInfo> managedDependencies, @NotNull MavenExplicitProfiles profiles, MavenToken token) {
        MavenServerResponse mavenServerResponse;
        LongRunningTask task;
        block14: {
            if (longRunningTaskInput == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(45);
            }
            if (artifacts == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(46);
            }
            if (remoteRepositories == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(47);
            }
            if (managedDependencies == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(48);
            }
            if (profiles == null) {
                Maven40ServerEmbedderImpl.$$$reportNull$$$0(49);
            }
            MavenServerUtil.checkToken((MavenToken)token);
            String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
            task = this.newLongRunningTask(longRunningTaskId, artifacts.size(), this.myConsoleWrapper);
            MavenArtifactResolveResult result = this.resolveProcessorPathEntries(task, artifacts, remoteRepositories, managedDependencies);
            mavenServerResponse = new MavenServerResponse((Serializable)result, this.getLongRunningTaskStatus(longRunningTaskId, token));
            if (task == null) break block14;
            task.close();
        }
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(50);
        }
        return mavenServerResponse2;
        {
            catch (Throwable throwable) {
                try {
                    if (task != null) {
                        try {
                            task.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapToSerializableRuntimeException(e);
                }
            }
        }
    }

    @NotNull
    private MavenArtifactResolveResult resolveProcessorPathEntries(@NotNull LongRunningTask task, @NotNull ArrayList<MavenArtifactInfo> artifacts, @NotNull ArrayList<MavenRemoteRepository> remoteRepositories, @NotNull HashMap<String, MavenArtifactInfo> managedDependencies) {
        MavenArtifactResolveResult mavenArtifactResolveResult;
        if (task == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(51);
        }
        if (artifacts == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(52);
        }
        if (remoteRepositories == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(53);
        }
        if (managedDependencies == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(54);
        }
        if (artifacts.isEmpty()) {
            return new MavenArtifactResolveResult(new ArrayList(), null);
        }
        try {
            mavenArtifactResolveResult = this.doResolveArtifactsTransitively(task, artifacts);
        }
        catch (Throwable e) {
            MavenProjectProblem problem;
            MavenServerGlobals.getLogger().error(e);
            Artifact transferArtifact = Maven40ServerEmbedderImpl.getProblemTransferArtifact(e);
            String message = Maven40ServerEmbedderImpl.getRootMessage(e);
            if (transferArtifact != null) {
                MavenArtifact mavenArtifact = Maven40ModelConverter.convertArtifact(transferArtifact, this.getLocalRepositoryFile());
                problem = MavenProjectProblem.createRepositoryProblem((String)"", (String)message, (boolean)false, (MavenArtifact)mavenArtifact);
            } else {
                problem = MavenProjectProblem.createStructureProblem((String)"", (String)message);
            }
            return new MavenArtifactResolveResult(Collections.emptyList(), problem);
        }
        if (mavenArtifactResolveResult == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(55);
        }
        return mavenArtifactResolveResult;
    }

    private MavenArtifactResolveResult doResolveArtifactsTransitively(LongRunningTask task, @NotNull List<MavenArtifactInfo> artifacts) {
        if (artifacts == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(56);
        }
        MavenExecutionRequest request = this.createRequest(null, null, null);
        HashMap resolvedArtifactMap = new HashMap();
        this.executeWithMavenSession(request, MavenWorkspaceMap.empty(), task.getIndicator(), mavenSession -> {
            Session session = mavenSession.getSession();
            for (MavenArtifactInfo mavenArtifactInfo : artifacts) {
                if (task.isCanceled()) break;
                ArtifactCoordinates coordinate = session.createArtifactCoordinates(mavenArtifactInfo.getGroupId(), mavenArtifactInfo.getArtifactId(), mavenArtifactInfo.getVersion(), mavenArtifactInfo.getClassifier(), mavenArtifactInfo.getPackaging(), null);
                ArtifactResolver artifactResolver = (ArtifactResolver)session.getService(ArtifactResolver.class);
                ArtifactResolverResult resolved = artifactResolver.resolve(session, Collections.singleton(coordinate));
                resolved.getArtifacts().forEach(a -> resolvedArtifactMap.put(a, a.getPath()));
                DependencyCoordinates dependencyCoordinate = session.createDependencyCoordinates(coordinate);
                Node dependencyNode = session.collectDependencies(dependencyCoordinate, PathScope.MAIN_COMPILE);
                List dependencyCoordinates = dependencyNode.stream().filter(node -> node != dependencyNode).filter(node -> node.getDependency() != null).map(node -> node.getDependency().toCoordinates()).filter(Maven40ServerEmbedderImpl.distinctByKey(coords -> Arrays.asList(coords.getGroupId(), coords.getArtifactId(), coords.getVersionConstraint().toString(), coords.getClassifier(), coords.getExtension(), coords.getOptional()))).collect(Collectors.toList());
                ArtifactResolverResult resolvedChildren = artifactResolver.resolve(session, dependencyCoordinates);
                resolvedChildren.getArtifacts().forEach(a -> resolvedArtifactMap.put(a, a.getPath()));
                task.incrementFinishedRequests();
            }
        });
        File localRepositoryFile = this.getLocalRepositoryFile();
        ArrayList<MavenArtifact> resolvedArtifacts = new ArrayList<MavenArtifact>();
        for (DownloadedArtifact apiArtifact : resolvedArtifactMap.keySet()) {
            Path artifactPath = (Path)resolvedArtifactMap.get(apiArtifact);
            MavenArtifact mavenArtifact = Maven40ApiModelConverter.convertArtifactAndPath((org.apache.maven.api.Artifact)apiArtifact, artifactPath, localRepositoryFile);
            resolvedArtifacts.add(mavenArtifact);
        }
        return new MavenArtifactResolveResult(resolvedArtifacts, null);
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public ArrayList<MavenArchetype> getLocalArchetypes(MavenToken token, @NotNull String path) {
        if (path == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(57);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        throw new UnsupportedOperationException();
    }

    public ArrayList<MavenArchetype> getRemoteArchetypes(MavenToken token, @NotNull String url) {
        if (url == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(58);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        throw new UnsupportedOperationException();
    }

    @Nullable
    public HashMap<String, String> resolveAndGetArchetypeDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull ArrayList<MavenRemoteRepository> repositories, @Nullable String url, MavenToken token) {
        if (groupId == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(59);
        }
        if (artifactId == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(60);
        }
        if (version == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(61);
        }
        if (repositories == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(62);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        throw new UnsupportedOperationException();
    }

    private void customizeComponents(@Nullable MavenWorkspaceMap workspaceMap) {
    }

    private void resetComponents() {
    }

    @Nonnull
    public static Path getCanonicalPath(Path path) {
        Objects.requireNonNull(path, "path");
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return Maven40ServerEmbedderImpl.getCanonicalPath(path.getParent()).resolve(path.getFileName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 14, 18, 19, 20, 25, 29, 38, 41, 42, 43, 50, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longRunningTaskInput";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/maven/server/m40/Maven40ServerEmbedderImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProblems";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customProperties";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceMap";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderModifier";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginResolutionRequests";
                break;
            }
            case 22: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 27: 
            case 31: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 28: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
            case 30: 
            case 39: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 44: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 46: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managedDependencies";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/maven/server/m40/Maven40ServerEmbedderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProjects";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMessage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPluginResolutionData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePlugin";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateEffectivePom";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "executeGoal";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveArtifacts";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolveArtifact";
                break;
            }
            case 50: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProcessorPathEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjects";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 55: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeWithMavenSession";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugins";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectPluginResolutionData";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "executeGoal";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createEmbedderExecutionResult";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifacts";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "doResolveArtifacts";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "resolveRepositories";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "resolveProcessorPathEntries";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "doResolveArtifactsTransitively";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getLocalArchetypes";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteArchetypes";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndGetArchetypeDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 14, 18, 19, 20, 25, 29, 38, 41, 42, 43, 50, 55 -> new IllegalStateException(string);
        };
    }

    private static class PluginResolutionData {
        MavenId mavenPluginId;
        boolean resolveDependencies;
        List<Dependency> dependencies;
        List<RemoteRepository> remoteRepos;

        private PluginResolutionData(MavenId mavenPluginId, boolean resolveDependencies, List<Dependency> dependencies, List<RemoteRepository> remoteRepos) {
            this.mavenPluginId = mavenPluginId;
            this.resolveDependencies = resolveDependencies;
            this.remoteRepos = remoteRepos;
            this.dependencies = dependencies;
        }
    }
}

