/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.java.features;

import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereSpellCheckResult;
import com.intellij.internal.statistic.eventLog.events.DoubleEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywherePsiElementFeaturesProviderUtils;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0016JD\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/java/features/SearchEverywhereJavaPsiElementFeatureProvider;", "Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereElementFeaturesProvider;", "<init>", "()V", "getFeaturesDeclarations", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getElementFeatures", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "element", "", "currentTime", "", "searchQuery", "", "elementPriority", "", "cache", "Lcom/intellij/searchEverywhereMl/ranking/core/features/FeaturesProviderCache;", "correction", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereSpellCheckResult;", "calculatePackageDistance", "Lkotlin/Pair;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "openedFile", "getContainingFile", "item", "Lcom/intellij/psi/PsiElement;", "roundDouble", "value", "Fields", "intellij.searchEverywhereMl.ranking.java"})
public final class SearchEverywhereJavaPsiElementFeatureProvider
extends SearchEverywhereElementFeaturesProvider {
    public SearchEverywhereJavaPsiElementFeatureProvider() {
        Class[] classArray = new Class[]{ClassSearchEverywhereContributor.class, FileSearchEverywhereContributor.class, RecentFilesSEContributor.class};
        super(classArray);
    }

    @NotNull
    public List<EventField<?>> getFeaturesDeclarations() {
        Object[] objectArray = new PrimitiveEventField[]{Fields.INSTANCE.getPACKAGE_DISTANCE_DATA_KEY(), Fields.INSTANCE.getPACKAGE_DISTANCE_NORMALIZED_DATA_KEY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<EventPair<?>> getElementFeatures(@NotNull Object element, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable FeaturesProviderCache cache, @NotNull SearchEverywhereSpellCheckResult correction) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Intrinsics.checkNotNullParameter((Object)correction, (String)"correction");
        PsiElement psiElement = SearchEverywherePsiElementFeaturesProviderUtils.INSTANCE.getPsiElementOrNull(element);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement2 = psiElement;
        VirtualFile virtualFile = this.getContainingFile(psiElement2);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile file = virtualFile;
        FeaturesProviderCache featuresProviderCache = cache;
        VirtualFile openedFile = featuresProviderCache != null ? featuresProviderCache.getCurrentlyOpenedFile() : null;
        Project project = psiElement2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Pair<Integer, Double> pair = this.calculatePackageDistance(file, project, openedFile);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        Pair<Integer, Double> pair2 = pair;
        int packageDistance = ((Number)pair2.component1()).intValue();
        double normalizedPackageDistance = ((Number)pair2.component2()).doubleValue();
        Object[] objectArray = new EventPair[]{Fields.INSTANCE.getPACKAGE_DISTANCE_DATA_KEY().with((Object)packageDistance), Fields.INSTANCE.getPACKAGE_DISTANCE_NORMALIZED_DATA_KEY().with((Object)normalizedPackageDistance)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final Pair<Integer, Double> calculatePackageDistance(VirtualFile file, Project project, VirtualFile openedFile) {
        if (openedFile == null) {
            return null;
        }
        Pair $this$calculatePackageDistance_u24lambda_u241 = (Pair)ReadAction.compute(() -> SearchEverywhereJavaPsiElementFeatureProvider.calculatePackageDistance$lambda$0(project, openedFile, file));
        boolean bl = false;
        Pair pair = new Pair(SearchEverywhereJavaPsiElementFeatureProvider.calculatePackageDistance$lambda$1$splitPackage((String)$this$calculatePackageDistance_u24lambda_u241.getFirst()), SearchEverywhereJavaPsiElementFeatureProvider.calculatePackageDistance$lambda$1$splitPackage((String)$this$calculatePackageDistance_u24lambda_u241.getSecond()));
        List openedFilePackage = (List)pair.component1();
        List foundFilePackage = (List)pair.component2();
        if (openedFilePackage == null || foundFilePackage == null) {
            return null;
        }
        int maxDistance = openedFilePackage.size() + foundFilePackage.size();
        int common = 0;
        Iterator iterator = ((Iterable)openedFilePackage).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String value = (String)iterator.next();
            if (foundFilePackage.size() == index || !Intrinsics.areEqual(foundFilePackage.get(index), (Object)value)) break;
            ++common;
        }
        int distance = maxDistance - 2 * common;
        double normalizedDistance = this.roundDouble(maxDistance != 0 ? (double)distance / (double)maxDistance : 0.0);
        return new Pair((Object)distance, (Object)normalizedDistance);
    }

    private final VirtualFile getContainingFile(PsiElement item) {
        if (item instanceof PsiFileSystemItem) {
            return ((PsiFileSystemItem)item).getVirtualFile();
        }
        return (VirtualFile)ReadAction.compute(() -> SearchEverywhereJavaPsiElementFeatureProvider.getContainingFile$lambda$0(item));
    }

    private final double roundDouble(double value) {
        if (!(Math.abs(value) <= Double.MAX_VALUE)) {
            return -1.0;
        }
        return Math.rint(value * (double)100000) / (double)100000;
    }

    private static final List<String> calculatePackageDistance$lambda$1$splitPackage(String s) {
        List list;
        if (s == null) {
            list = null;
        } else if (StringsKt.isBlank((CharSequence)s)) {
            list = CollectionsKt.emptyList();
        } else {
            char[] cArray = new char[]{'.'};
            list = StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        return list;
    }

    private static final Pair calculatePackageDistance$lambda$0(Project $project, VirtualFile $openedFile, VirtualFile $file) {
        PackageIndex packageIndex = PackageIndex.getInstance((Project)$project);
        String openedFilePackageName = packageIndex.getPackageName($openedFile);
        String foundFilePackageName = packageIndex.getPackageName($file);
        return new Pair((Object)openedFilePackageName, (Object)foundFilePackageName);
    }

    private static final VirtualFile getContainingFile$lambda$0(PsiElement $item) {
        VirtualFile virtualFile;
        try {
            PsiFile psiFile = $item.getContainingFile();
            virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        }
        catch (PsiInvalidElementAccessException ex) {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/java/features/SearchEverywhereJavaPsiElementFeatureProvider$Fields;", "", "<init>", "()V", "PACKAGE_DISTANCE_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getPACKAGE_DISTANCE_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "PACKAGE_DISTANCE_NORMALIZED_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/DoubleEventField;", "getPACKAGE_DISTANCE_NORMALIZED_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/DoubleEventField;", "intellij.searchEverywhereMl.ranking.java"})
    public static final class Fields {
        @NotNull
        public static final Fields INSTANCE = new Fields();
        @NotNull
        private static final IntEventField PACKAGE_DISTANCE_DATA_KEY = EventFields.Int((String)"package_distance");
        @NotNull
        private static final DoubleEventField PACKAGE_DISTANCE_NORMALIZED_DATA_KEY = EventFields.Double((String)"package_distance_norm");

        private Fields() {
        }

        @NotNull
        public final IntEventField getPACKAGE_DISTANCE_DATA_KEY() {
            return PACKAGE_DISTANCE_DATA_KEY;
        }

        @NotNull
        public final DoubleEventField getPACKAGE_DISTANCE_NORMALIZED_DATA_KEY() {
            return PACKAGE_DISTANCE_NORMALIZED_DATA_KEY;
        }
    }
}

