/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.dependency.analyzer;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerGoToAction;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerView;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.dependency.analyzer.GradleDependencyAnalyzerUtilKt;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerGoToAction;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerGoToAction;", "<init>", "()V", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDeclaredDependency", "Lcom/intellij/buildsystem/model/DeclaredDependency;", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleDependencyAnalyzerGoToAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDependencyAnalyzerGoToAction.kt\norg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerGoToAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public final class GradleDependencyAnalyzerGoToAction
extends DependencyAnalyzerGoToAction {
    public GradleDependencyAnalyzerGoToAction() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        super(projectSystemId);
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DeclaredDependency declaredDependency = this.getDeclaredDependency(e);
        if (declaredDependency == null) {
            return null;
        }
        DeclaredDependency dependency = declaredDependency;
        PsiElement psiElement = dependency.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        PsiNavigationSupport navigationSupport = PsiNavigationSupport.getInstance();
        return navigationSupport.getDescriptor(psiElement2);
    }

    private final DeclaredDependency getDeclaredDependency(AnActionEvent e) {
        Object v4;
        block5: {
            Project project = e.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            DependencyAnalyzerDependency dependencyAnalyzerDependency = (DependencyAnalyzerDependency)e.getData(DependencyAnalyzerView.Companion.getDEPENDENCY());
            if (dependencyAnalyzerDependency == null) {
                return null;
            }
            DependencyAnalyzerDependency dependency = dependencyAnalyzerDependency;
            UnifiedCoordinates unifiedCoordinates = GradleDependencyAnalyzerUtilKt.getUnifiedCoordinates(dependency);
            if (unifiedCoordinates == null) {
                return null;
            }
            UnifiedCoordinates coordinates = unifiedCoordinates;
            Module module = GradleDependencyAnalyzerUtilKt.getParentModule(project2, dependency);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            DependencyModifierService dependencyModifierService = DependencyModifierService.Companion.getInstance(project2);
            Iterable iterable = dependencyModifierService.declaredDependencies(module2);
            for (Object t : iterable) {
                DeclaredDependency it = (DeclaredDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCoordinates(), (Object)coordinates)) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        return v4;
    }
}

