/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.jvmcompat;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.lang.JavaVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityState;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportDefaultDataKt;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataState;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataStorage;
import org.jetbrains.plugins.gradle.jvmcompat.VersionMapping;
import org.jetbrains.plugins.gradle.util.Ranges;

@State(name="GradleJvmSupportMatrix", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\b\u0010\u0010\u001a\u00020\u0002H\u0014J.\u0010\u0011\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000b0\u00062\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0002J\b\u0010#\u001a\u00020\u0007H\u0002J\b\u0010$\u001a\u00020\u0007H\u0002J\b\u0010%\u001a\u00020\u0007H\u0002J\b\u0010&\u001a\u00020\u0007H\u0002J\b\u0010'\u001a\u00020\tH\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u000eH\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix;", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataStorage;", "Lorg/jetbrains/plugins/gradle/jvmcompat/GradleCompatibilityState;", "<init>", "()V", "supportedGradleVersions", "", "Lorg/gradle/util/GradleVersion;", "supportedJavaVersions", "Lcom/intellij/util/lang/JavaVersion;", "compatibility", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/gradle/util/Ranges;", "applyState", "", "state", "newState", "getCompatibilityRanges", "data", "onStateChanged", "isSupportedImpl", "", "gradleVersion", "javaVersion", "isJavaSupportedByIdeaImpl", "isGradleSupportedByIdeaImpl", "isGradleDeprecatedByIdeaImpl", "getSupportedGradleVersionsImpl", "getSupportedJavaVersionsImpl", "suggestLatestGradleVersionImpl", "suggestLatestJavaVersionImpl", "suggestOldestCompatibleGradleVersionImpl", "suggestOldestCompatibleJavaVersionImpl", "getAllSupportedGradleVersionsByIdeaImpl", "getAllSupportedJavaVersionsByIdeaImpl", "getOldestSupportedGradleVersionByIdeaImpl", "getLatestSupportedGradleVersionByIdeaImpl", "getOldestNonDeprecatedGradleVersionByIdeaImpl", "getRecommendedGradleVersionByIdeaImpl", "getOldestSupportedJavaVersionByIdeaImpl", "getLatestMinorGradleVersionImpl", "major", "", "resetState", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleJvmSupportMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleJvmSupportMatrix.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1586#2:234\n1661#2,3:235\n1642#2,10:238\n1915#2:248\n1916#2:250\n1652#2:251\n1642#2,10:252\n1915#2:262\n1916#2:264\n1652#2:265\n1807#2,3:266\n777#2:269\n873#2,2:270\n777#2:272\n873#2,2:273\n777#2:275\n873#2,2:276\n1#3:249\n1#3:263\n*S KotlinDebug\n*F\n+ 1 GradleJvmSupportMatrix.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix\n*L\n29#1:234\n29#1:235,3\n30#1:238,10\n30#1:248\n30#1:250\n30#1:251\n40#1:252,10\n40#1:262\n40#1:264\n40#1:265\n56#1:266,3\n74#1:269\n74#1:270,2\n80#1:272\n80#1:273,2\n130#1:275\n130#1:276,2\n30#1:249\n40#1:263\n*E\n"})
public final class GradleJvmSupportMatrix
extends IdeVersionedDataStorage<GradleCompatibilityState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile List<? extends GradleVersion> supportedGradleVersions = CollectionsKt.emptyList();
    @NotNull
    private volatile List<JavaVersion> supportedJavaVersions = CollectionsKt.emptyList();
    @NotNull
    private volatile List<Pair<Ranges<JavaVersion>, Ranges<GradleVersion>>> compatibility = CollectionsKt.emptyList();

    public GradleJvmSupportMatrix() {
        super(GradleCompatibilityDataParser.INSTANCE, (IdeVersionedDataState)GradleJvmSupportDefaultDataKt.getDEFAULT_DATA());
        this.applyState(GradleJvmSupportDefaultDataKt.getDEFAULT_DATA());
    }

    /*
     * WARNING - void declaration
     */
    private final void applyState(GradleCompatibilityState state) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.compatibility = this.getCompatibilityRanges(state);
        Iterable iterable = state.getSupportedGradleVersions();
        GradleJvmSupportMatrix gradleJvmSupportMatrix = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GradleVersion.version((String)p0));
        }
        gradleJvmSupportMatrix.supportedGradleVersions = (List)destination$iv$iv;
        $this$map$iv = state.getSupportedJavaVersions();
        JavaVersion.Companion companion = JavaVersion.Companion;
        gradleJvmSupportMatrix = this;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JavaVersion it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if (companion.tryParse(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        gradleJvmSupportMatrix.supportedJavaVersions = (List)destination$iv$iv2;
    }

    @Override
    @NotNull
    protected GradleCompatibilityState newState() {
        return new GradleCompatibilityState();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Ranges<JavaVersion>, Ranges<GradleVersion>>> getCompatibilityRanges(GradleCompatibilityState data) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = data.getCompatibility();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Ranges javaRange2;
            Object object;
            String string;
            String gradleVersionInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VersionMapping entry = (VersionMapping)((Object)element$iv$iv);
            boolean bl2 = false;
            String string2 = entry.getGradleVersionInfo();
            if (string2 == null) {
                string2 = gradleVersionInfo = "";
            }
            if ((string = entry.getJavaVersionInfo()) == null) {
                string = "";
            }
            String javaVersionInfo = string;
            char[] cArray = new char[]{','};
            Ranges gradleRange2 = IdeVersionedDataParser.Companion.parseRange(StringsKt.split$default((CharSequence)gradleVersionInfo, (char[])cArray, (boolean)false, (int)0, (int)6, null), getCompatibilityRanges.1.gradleRange.1.INSTANCE);
            Object object2 = this;
            try {
                GradleJvmSupportMatrix $this$getCompatibilityRanges_u24lambda_u240_u240 = object2;
                boolean bl3 = false;
                char[] cArray2 = new char[]{','};
                object = Result.constructor-impl(IdeVersionedDataParser.Companion.parseRange(StringsKt.split$default((CharSequence)javaVersionInfo, (char[])cArray2, (boolean)false, (int)0, (int)6, null), (Function1)new Function1<String, JavaVersion>((Object)JavaVersion.Companion){

                    public final JavaVersion invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((JavaVersion.Companion)this.receiver).parse(p0);
                    }
                }));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            if (((Ranges)(Result.isFailure-impl((Object)object2) ? null : object2) == null ? null : TuplesKt.to((Object)javaRange2, gradleRange2)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void onStateChanged(@NotNull GradleCompatibilityState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        this.applyState(newState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSupportedImpl(GradleVersion gradleVersion, JavaVersion javaVersion) {
        boolean bl;
        Iterable $this$any$iv = this.compatibility;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            Ranges javaVersions = (Ranges)pair.component1();
            Ranges gradleVersions = (Ranges)pair.component2();
            if (javaVersions.contains((Comparable)javaVersion)) {
                GradleVersion gradleVersion2 = gradleVersion.getBaseVersion();
                Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"getBaseVersion(...)");
                if (gradleVersions.contains((Comparable)gradleVersion2)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isJavaSupportedByIdeaImpl(JavaVersion javaVersion) {
        return this.getOldestSupportedJavaVersionByIdeaImpl().compareTo(javaVersion) <= 0;
    }

    private final boolean isGradleSupportedByIdeaImpl(GradleVersion gradleVersion) {
        return this.getOldestSupportedGradleVersionByIdeaImpl().compareTo(gradleVersion.getBaseVersion()) <= 0;
    }

    private final boolean isGradleDeprecatedByIdeaImpl(GradleVersion gradleVersion) {
        return gradleVersion.getBaseVersion().compareTo(this.getOldestNonDeprecatedGradleVersionByIdeaImpl()) < 0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GradleVersion> getSupportedGradleVersionsImpl(JavaVersion javaVersion) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllSupportedGradleVersionsByIdeaImpl();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GradleVersion it = (GradleVersion)element$iv$iv;
            boolean bl = false;
            if (!this.isSupportedImpl(it, javaVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaVersion> getSupportedJavaVersionsImpl(GradleVersion gradleVersion) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllSupportedJavaVersionsByIdeaImpl();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JavaVersion it = (JavaVersion)element$iv$iv;
            boolean bl = false;
            if (!this.isSupportedImpl(gradleVersion, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final GradleVersion suggestLatestGradleVersionImpl(JavaVersion javaVersion) {
        return (GradleVersion)CollectionsKt.lastOrNull(this.getSupportedGradleVersionsImpl(javaVersion));
    }

    private final JavaVersion suggestLatestJavaVersionImpl(GradleVersion gradleVersion) {
        return (JavaVersion)CollectionsKt.lastOrNull(this.getSupportedJavaVersionsImpl(gradleVersion));
    }

    private final GradleVersion suggestOldestCompatibleGradleVersionImpl(JavaVersion javaVersion) {
        return (GradleVersion)CollectionsKt.firstOrNull(this.getSupportedGradleVersionsImpl(javaVersion));
    }

    private final JavaVersion suggestOldestCompatibleJavaVersionImpl(GradleVersion gradleVersion) {
        return (JavaVersion)CollectionsKt.firstOrNull(this.getSupportedJavaVersionsImpl(gradleVersion));
    }

    private final List<GradleVersion> getAllSupportedGradleVersionsByIdeaImpl() {
        return this.supportedGradleVersions;
    }

    private final List<JavaVersion> getAllSupportedJavaVersionsByIdeaImpl() {
        return this.supportedJavaVersions;
    }

    private final GradleVersion getOldestSupportedGradleVersionByIdeaImpl() {
        return (GradleVersion)CollectionsKt.minOrThrow((Iterable)this.getAllSupportedGradleVersionsByIdeaImpl());
    }

    private final GradleVersion getLatestSupportedGradleVersionByIdeaImpl() {
        return (GradleVersion)CollectionsKt.maxOrThrow((Iterable)this.getAllSupportedGradleVersionsByIdeaImpl());
    }

    private final GradleVersion getOldestNonDeprecatedGradleVersionByIdeaImpl() {
        GradleVersion gradleVersion = GradleVersion.version((String)"6.0");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"version(...)");
        return gradleVersion;
    }

    private final GradleVersion getRecommendedGradleVersionByIdeaImpl() {
        GradleVersion gradleVersion = GradleVersion.current();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"current(...)");
        return gradleVersion;
    }

    private final JavaVersion getOldestSupportedJavaVersionByIdeaImpl() {
        return (JavaVersion)CollectionsKt.minOrThrow((Iterable)this.getAllSupportedJavaVersionsByIdeaImpl());
    }

    /*
     * WARNING - void declaration
     */
    private final GradleVersion getLatestMinorGradleVersionImpl(int major) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllSupportedGradleVersionsByIdeaImpl();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GradleVersion it = (GradleVersion)element$iv$iv;
            boolean bl = false;
            if (!(it.getMajorVersion() == major)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (GradleVersion)CollectionsKt.maxOrThrow((Iterable)((List)destination$iv$iv));
    }

    @TestOnly
    public final void resetState() {
        this.onStateChanged(this.newState());
    }

    @JvmStatic
    @NotNull
    public static final GradleJvmSupportMatrix getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final boolean isSupported(@NotNull GradleVersion gradleVersion, @NotNull JavaVersion javaVersion) {
        return Companion.isSupported(gradleVersion, javaVersion);
    }

    @JvmStatic
    public static final boolean isJavaSupportedByIdea(@NotNull JavaVersion javaVersion) {
        return Companion.isJavaSupportedByIdea(javaVersion);
    }

    @JvmStatic
    public static final boolean isGradleSupportedByIdea(@NotNull GradleVersion gradleVersion) {
        return Companion.isGradleSupportedByIdea(gradleVersion);
    }

    @JvmStatic
    public static final boolean isGradleDeprecatedByIdea(@NotNull GradleVersion gradleVersion) {
        return Companion.isGradleDeprecatedByIdea(gradleVersion);
    }

    @JvmStatic
    @NotNull
    public static final GradleVersion getLatestMinorGradleVersion(int major) {
        return Companion.getLatestMinorGradleVersion(major);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0010J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010J\u0006\u0010\u0018\u001a\u00020\tJ\u0006\u0010\u0019\u001a\u00020\tJ\u0006\u0010\u001a\u001a\u00020\tJ\u0006\u0010\u001b\u001a\u00020\u000bJ\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix;", "isSupported", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "isJavaSupportedByIdea", "isGradleSupportedByIdea", "isGradleDeprecatedByIdea", "getSupportedGradleVersions", "", "getSupportedJavaVersions", "suggestLatestSupportedGradleVersion", "suggestLatestSupportedJavaVersion", "suggestOldestSupportedGradleVersion", "suggestOldestSupportedJavaVersion", "getAllSupportedGradleVersionsByIdea", "getAllSupportedJavaVersionsByIdea", "getOldestSupportedGradleVersionByIdea", "getLatestSupportedGradleVersionByIdea", "getRecommendedGradleVersionByIdea", "getOldestSupportedJavaVersionByIdea", "getLatestMinorGradleVersion", "major", "", "intellij.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleJvmSupportMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleJvmSupportMatrix.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,233:1\n42#2,3:234\n*S KotlinDebug\n*F\n+ 1 GradleJvmSupportMatrix.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix$Companion\n*L\n142#1:234,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GradleJvmSupportMatrix getInstance() {
            boolean $i$f$service = false;
            Class<GradleJvmSupportMatrix> serviceClass$iv = GradleJvmSupportMatrix.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GradleJvmSupportMatrix)object;
        }

        @JvmStatic
        public final boolean isSupported(@NotNull GradleVersion gradleVersion, @NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().isSupportedImpl(gradleVersion, javaVersion);
        }

        @JvmStatic
        public final boolean isJavaSupportedByIdea(@NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().isJavaSupportedByIdeaImpl(javaVersion);
        }

        @JvmStatic
        public final boolean isGradleSupportedByIdea(@NotNull GradleVersion gradleVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            return this.getInstance().isGradleSupportedByIdeaImpl(gradleVersion);
        }

        @JvmStatic
        public final boolean isGradleDeprecatedByIdea(@NotNull GradleVersion gradleVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            return this.getInstance().isGradleDeprecatedByIdeaImpl(gradleVersion);
        }

        @NotNull
        public final List<GradleVersion> getSupportedGradleVersions(@NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().getSupportedGradleVersionsImpl(javaVersion);
        }

        @NotNull
        public final List<JavaVersion> getSupportedJavaVersions(@NotNull GradleVersion gradleVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            return this.getInstance().getSupportedJavaVersionsImpl(gradleVersion);
        }

        @Nullable
        public final GradleVersion suggestLatestSupportedGradleVersion(@NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().suggestLatestGradleVersionImpl(javaVersion);
        }

        @Nullable
        public final JavaVersion suggestLatestSupportedJavaVersion(@NotNull GradleVersion gradleVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            return this.getInstance().suggestLatestJavaVersionImpl(gradleVersion);
        }

        @Nullable
        public final GradleVersion suggestOldestSupportedGradleVersion(@NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().suggestOldestCompatibleGradleVersionImpl(javaVersion);
        }

        @Nullable
        public final JavaVersion suggestOldestSupportedJavaVersion(@NotNull GradleVersion gradleVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            return this.getInstance().suggestOldestCompatibleJavaVersionImpl(gradleVersion);
        }

        @NotNull
        public final List<GradleVersion> getAllSupportedGradleVersionsByIdea() {
            return this.getInstance().getAllSupportedGradleVersionsByIdeaImpl();
        }

        @NotNull
        public final List<JavaVersion> getAllSupportedJavaVersionsByIdea() {
            return this.getInstance().getAllSupportedJavaVersionsByIdeaImpl();
        }

        @NotNull
        public final GradleVersion getOldestSupportedGradleVersionByIdea() {
            return this.getInstance().getOldestSupportedGradleVersionByIdeaImpl();
        }

        @NotNull
        public final GradleVersion getLatestSupportedGradleVersionByIdea() {
            return this.getInstance().getLatestSupportedGradleVersionByIdeaImpl();
        }

        @NotNull
        public final GradleVersion getRecommendedGradleVersionByIdea() {
            return this.getInstance().getRecommendedGradleVersionByIdeaImpl();
        }

        @NotNull
        public final JavaVersion getOldestSupportedJavaVersionByIdea() {
            return this.getInstance().getOldestSupportedJavaVersionByIdeaImpl();
        }

        @JvmStatic
        @NotNull
        public final GradleVersion getLatestMinorGradleVersion(int major) {
            return this.getInstance().getLatestMinorGradleVersionImpl(major);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

