/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.cache;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0007J0\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n2\u0006\u0010\u0014\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0007J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/service/cache/GradleLocalCacheHelper;", "", "<init>", "()V", "SOURCE_JAR_SUFFIX", "", "JAVADOC_JAR_SUFFIX", "JAR_SUFFIX", "CACHED_FILES_ROOT_PATH", "findArtifactComponents", "", "Lcom/intellij/openapi/externalSystem/model/project/LibraryPathType;", "", "Ljava/nio/file/Path;", "coordinates", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "gradleUserHome", "requestedComponents", "", "findAdjacentComponents", "cachedArtifactRoot", "toCachedArtifactRoot", "GradleCacheVisitor", "intellij.gradle"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGradleLocalCacheHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleLocalCacheHelper.kt\norg/jetbrains/plugins/gradle/service/cache/GradleLocalCacheHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class GradleLocalCacheHelper {
    @NotNull
    public static final GradleLocalCacheHelper INSTANCE = new GradleLocalCacheHelper();
    @NotNull
    private static final String SOURCE_JAR_SUFFIX = "-sources.jar";
    @NotNull
    private static final String JAVADOC_JAR_SUFFIX = "-javadoc.jar";
    @NotNull
    private static final String JAR_SUFFIX = ".jar";
    @NotNull
    private static final String CACHED_FILES_ROOT_PATH = "caches/modules-2/files-2.1";

    private GradleLocalCacheHelper() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @NotNull
    public static final Map<LibraryPathType, List<Path>> findArtifactComponents(@NotNull UnifiedCoordinates coordinates, @NotNull Path gradleUserHome, @NotNull Set<? extends LibraryPathType> requestedComponents) {
        Map<LibraryPathType, List<Path>> map;
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)gradleUserHome, (String)"gradleUserHome");
        Intrinsics.checkNotNullParameter(requestedComponents, (String)"requestedComponents");
        Path path = INSTANCE.toCachedArtifactRoot(coordinates, gradleUserHome);
        if (path != null) {
            Path it = path;
            boolean bl = false;
            Map<LibraryPathType, List<Path>> map2 = GradleLocalCacheHelper.findAdjacentComponents(it, requestedComponents);
            if (map2 != null) {
                map = map2;
                return map;
            }
        }
        map = MapsKt.emptyMap();
        return map;
    }

    @JvmStatic
    @NotNull
    public static final Map<LibraryPathType, List<Path>> findAdjacentComponents(@NotNull Path cachedArtifactRoot, @NotNull Set<? extends LibraryPathType> requestedComponents) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)cachedArtifactRoot, (String)"cachedArtifactRoot");
                Intrinsics.checkNotNullParameter(requestedComponents, (String)"requestedComponents");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(cachedArtifactRoot, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block2;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(cachedArtifactRoot, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block3;
            }
            return MapsKt.emptyMap();
        }
        GradleCacheVisitor it = new GradleCacheVisitor(cachedArtifactRoot, requestedComponents);
        boolean bl = false;
        Files.walkFileTree(cachedArtifactRoot, (Set<FileVisitOption>)EnumSet.noneOf(FileVisitOption.class), 2, it);
        return it.getTarget();
    }

    private final Path toCachedArtifactRoot(UnifiedCoordinates $this$toCachedArtifactRoot, Path gradleUserHome) {
        if ($this$toCachedArtifactRoot.getGroupId() == null || $this$toCachedArtifactRoot.getArtifactId() == null || $this$toCachedArtifactRoot.getVersion() == null) {
            return null;
        }
        return gradleUserHome.resolve(CACHED_FILES_ROOT_PATH).resolve($this$toCachedArtifactRoot.getGroupId()).resolve($this$toCachedArtifactRoot.getArtifactId()).resolve($this$toCachedArtifactRoot.getVersion());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J<\u0010\u0013\u001a\u00020\u0014*\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/service/cache/GradleLocalCacheHelper$GradleCacheVisitor;", "Ljava/nio/file/SimpleFileVisitor;", "Ljava/nio/file/Path;", "cachedArtifactRoot", "requestedComponents", "", "Lcom/intellij/openapi/externalSystem/model/project/LibraryPathType;", "<init>", "(Ljava/nio/file/Path;Ljava/util/Set;)V", "target", "Ljava/util/EnumMap;", "", "getTarget", "()Ljava/util/EnumMap;", "visitFile", "Ljava/nio/file/FileVisitResult;", "sourceCandidate", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "addPathIfTypeRequired", "", "path", "type", "requiredTypes", "intellij.gradle"})
    private static final class GradleCacheVisitor
    extends SimpleFileVisitor<Path> {
        @NotNull
        private final Path cachedArtifactRoot;
        @NotNull
        private final Set<LibraryPathType> requestedComponents;
        @NotNull
        private final EnumMap<LibraryPathType, List<Path>> target;

        public GradleCacheVisitor(@NotNull Path cachedArtifactRoot, @NotNull Set<? extends LibraryPathType> requestedComponents) {
            Intrinsics.checkNotNullParameter((Object)cachedArtifactRoot, (String)"cachedArtifactRoot");
            Intrinsics.checkNotNullParameter(requestedComponents, (String)"requestedComponents");
            this.cachedArtifactRoot = cachedArtifactRoot;
            this.requestedComponents = requestedComponents;
            this.target = new EnumMap(LibraryPathType.class);
        }

        @NotNull
        public final EnumMap<LibraryPathType, List<Path>> getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(@NotNull Path sourceCandidate, @NotNull BasicFileAttributes attrs) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sourceCandidate, (String)"sourceCandidate");
            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
            Path path = sourceCandidate.getParent();
            if (!Intrinsics.areEqual((Object)(path != null ? path.getParent() : null), (Object)this.cachedArtifactRoot)) {
                return FileVisitResult.SKIP_SIBLINGS;
            }
            if (attrs.isRegularFile()) {
                String candidateFileName = ((Object)sourceCandidate.getFileName()).toString();
                if (StringsKt.endsWith$default((String)candidateFileName, (String)GradleLocalCacheHelper.SOURCE_JAR_SUFFIX, (boolean)false, (int)2, null)) {
                    this.addPathIfTypeRequired(this.target, sourceCandidate, LibraryPathType.SOURCE, this.requestedComponents);
                } else if (StringsKt.endsWith$default((String)candidateFileName, (String)GradleLocalCacheHelper.JAVADOC_JAR_SUFFIX, (boolean)false, (int)2, null)) {
                    this.addPathIfTypeRequired(this.target, sourceCandidate, LibraryPathType.DOC, this.requestedComponents);
                } else if (StringsKt.endsWith$default((String)candidateFileName, (String)GradleLocalCacheHelper.JAR_SUFFIX, (boolean)false, (int)2, null)) {
                    this.addPathIfTypeRequired(this.target, sourceCandidate, LibraryPathType.BINARY, this.requestedComponents);
                }
            }
            if (this.target.keySet().containsAll((Collection)this.requestedComponents)) {
                return FileVisitResult.TERMINATE;
            }
            FileVisitResult fileVisitResult = super.visitFile(sourceCandidate, attrs);
            Intrinsics.checkNotNull((Object)((Object)fileVisitResult));
            return fileVisitResult;
        }

        private final void addPathIfTypeRequired(EnumMap<LibraryPathType, List<Path>> $this$addPathIfTypeRequired, Path path, LibraryPathType type, Set<? extends LibraryPathType> requiredTypes) {
            if (!requiredTypes.contains(type)) {
                return;
            }
            $this$addPathIfTypeRequired.computeIfAbsent(type, arg_0 -> GradleCacheVisitor.addPathIfTypeRequired$lambda$1(GradleCacheVisitor::addPathIfTypeRequired$lambda$0, arg_0)).add(path);
        }

        private static final List addPathIfTypeRequired$lambda$0(LibraryPathType it) {
            return (List)new SmartList();
        }

        private static final List addPathIfTypeRequired$lambda$1(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }
    }
}

