/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.externalSystem.util.OutputWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import org.gradle.api.logging.LogLevel;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.GradleEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.connection.GradleConnectorService;
import org.jetbrains.plugins.gradle.issue.DeprecatedGradleVersionIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.service.execution.GradleCommandLineUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionChecker;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContext;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContextImpl;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressListener;
import org.jetbrains.plugins.gradle.service.execution.SystemPropertiesAdjuster;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.service.project.GradleExecutionHelperExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

@ApiStatus.Internal
public final class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);
    public static final Key<Boolean> AUTO_JAVA_HOME = Key.create((String)"AUTO_JAVA_HOME");

    @Deprecated
    public GradleExecutionHelper() {
    }

    @Deprecated
    @NotNull
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @Nullable GradleExecutionSettings settings) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(0);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(2);
        }
        GradleExecutionSettings effectiveSettings = (GradleExecutionSettings)((Object)ObjectUtils.notNull((Object)((Object)settings), () -> new GradleExecutionSettings()));
        CancellationToken effectiveCancellationToken = (CancellationToken)ObjectUtils.notNull((Object)cancellationToken, () -> GradleConnector.newCancellationTokenSource().token());
        GradleExecutionContextImpl context = new GradleExecutionContextImpl("", taskId, effectiveSettings, listener2, effectiveCancellationToken);
        return GradleExecutionHelper.getBuildEnvironment(connection, context);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static <Model> Model getModel(@NotNull ProjectConnection connection, @NotNull GradleExecutionContext context, @NotNull Class<Model> modelClass) {
        Object object;
        Scope ignore;
        Span span;
        block16: {
            if (connection == null) {
                GradleExecutionHelper.$$$reportNull$$$0(3);
            }
            if (context == null) {
                GradleExecutionHelper.$$$reportNull$$$0(4);
            }
            if (modelClass == null) {
                GradleExecutionHelper.$$$reportNull$$$0(5);
            }
            span = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GetModel").setAttribute("modelClass", modelClass.getName()).startSpan();
            ignore = span.makeCurrent();
            ExternalSystemTaskId taskId = context.getTaskId();
            ExternalSystemTaskNotificationListener listener2 = context.getListener();
            ModelBuilder modelBuilder = connection.model(modelClass);
            modelBuilder.withCancellationToken(context.getCancellationToken());
            GradleExecutionHelper.setupJavaHome((LongRunningOperation)modelBuilder, context.getSettings(), taskId, listener2, null);
            GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, taskId, context.getProjectPath());
            modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
            modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
            modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener2, taskId, true));
            modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener2, taskId, false));
            object = modelBuilder.get();
            if (ignore == null) break block16;
            ignore.close();
        }
        Object object2 = object;
        if (object2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(6);
        }
        return (Model)object2;
        {
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CancellationException ce) {
                    throw ce;
                }
                catch (Exception ex) {
                    span.recordException((Throwable)ex);
                    span.setStatus(StatusCode.ERROR);
                    throw new RuntimeException(String.format("Failed to obtain model %s from Gradle daemon.", modelClass.getSimpleName()), ex);
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Deprecated
    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull com.intellij.util.Function<? super ProjectConnection, ? extends T> f) {
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(7);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(8);
        }
        return GradleExecutionHelper.execute(projectPath, settings, null, null, null, f);
    }

    @Deprecated
    public static <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @NotNull com.intellij.util.Function<? super ProjectConnection, ? extends T> f) {
        String projectDir;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(9);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(10);
        }
        File projectPathFile = new File(projectPath);
        if (Files.isRegularFile(Path.of(projectPath, new String[0]), new LinkOption[0]) && projectPath.endsWith("gradle") && projectPathFile.getParent() != null) {
            List arguments;
            projectDir = projectPathFile.getParent();
            if (settings != null && !(arguments = settings.getArguments()).contains("-b") && !arguments.contains("--build-file")) {
                settings.withArguments(new String[]{"-b", projectPath});
            }
        } else {
            projectDir = projectPath;
        }
        GradleConnectorService connectorService = GradleConnectorService.getInstance(projectDir, taskId);
        return (T)connectorService.withGradleConnection(projectDir, taskId, settings, listener2, cancellationToken, connection -> {
            try {
                return SystemPropertiesAdjuster.executeAdjusted(projectDir, () -> f.fun(connection));
            }
            catch (ExternalSystemException | ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Gradle execution error", e);
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause), e, new String[0]);
                externalSystemException.initCause(e);
                throw externalSystemException;
            }
        });
    }

    public static <T> T execute(@NotNull GradleExecutionContextImpl context, @NotNull Function<? super ProjectConnection, ? extends T> action) {
        if (context == null) {
            GradleExecutionHelper.$$$reportNull$$$0(11);
        }
        if (action == null) {
            GradleExecutionHelper.$$$reportNull$$$0(12);
        }
        return GradleExecutionHelper.execute(context.getProjectPath(), context.getSettings(), context.getTaskId(), context.getListener(), context.getCancellationToken(), connection -> {
            BuildEnvironment buildEnvironment = null;
            try {
                buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, context);
                context.setBuildEnvironment(buildEnvironment);
                return action.apply((ProjectConnection)connection);
            }
            catch (ExternalSystemException | CancellationException e) {
                throw e;
            }
            catch (Exception ex) {
                throw GradleProjectResolver.createProjectResolverChain().getUserFriendlyError(buildEnvironment, ex, context.getProjectPath(), null);
            }
        });
    }

    public static void prepareForExecution(@NotNull LongRunningOperation operation, @NotNull GradleExecutionContextImpl context) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(13);
        }
        if (context == null) {
            GradleExecutionHelper.$$$reportNull$$$0(14);
        }
        GradleExecutionContextImpl effectiveContext = new GradleExecutionContextImpl(context);
        ExternalSystemTaskId id = effectiveContext.getTaskId();
        GradleExecutionSettings settings = effectiveContext.getSettings();
        ExternalSystemTaskNotificationListener listener2 = effectiveContext.getListener();
        BuildEnvironment buildEnvironment = effectiveContext.getBuildEnvironment();
        GradleExecutionHelper.applyIdeaParameters(settings);
        GradleExecutionHelper.setupLogging(settings, buildEnvironment);
        GradleExecutionHelperExtension.EP_NAME.forEachExtensionSafe(proc -> proc.configureSettings(settings, effectiveContext));
        GradleExecutionHelper.clearSystemProperties(operation);
        GradleExecutionHelper.setupJvmArguments(operation, settings);
        GradleExecutionHelper.setupArguments(operation, settings);
        GradleExecutionHelper.setupEnvironment(operation, settings);
        GradleExecutionHelper.setupJavaHome(operation, settings, id, listener2, buildEnvironment);
        GradleExecutionHelper.setupProgressListeners(operation, settings, id, listener2, buildEnvironment);
        GradleExecutionHelper.setupStandardIO(operation, settings, id, listener2);
        operation.withCancellationToken(effectiveContext.getCancellationToken());
        GradleExecutionHelperExtension.EP_NAME.forEachExtensionSafe(proc -> proc.configureOperation(operation, effectiveContext));
    }

    private static void clearSystemProperties(LongRunningOperation operation) {
        operation.withSystemProperties(Collections.emptyMap());
    }

    private static void applyIdeaParameters(@NotNull GradleExecutionSettings settings) {
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(15);
        }
        if (settings.isOfflineWork()) {
            settings.withArgument("--offline");
        }
        settings.withArgument("-Didea.active=true");
        settings.withArgument("-Didea.version=" + GradleExecutionHelper.getIdeaVersion());
        settings.withArgument("-Didea.vendor.name=" + ApplicationInfo.getInstance().getShortCompanyName());
    }

    private static void setupProgressListeners(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull BuildEnvironment buildEnvironment) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(16);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(17);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(18);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(19);
        }
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(20);
        }
        Path buildRootDir = GradleExecutionHelper.getBuildRoot(buildEnvironment);
        GradleProgressListener progressListener = new GradleProgressListener(listener2, id, buildRootDir.toString());
        operation.addProgressListener((org.gradle.tooling.ProgressListener)progressListener);
        operation.addProgressListener((ProgressListener)progressListener, new OperationType[]{OperationType.TASK, OperationType.FILE_DOWNLOAD});
        if (settings.isRunAsTest() && settings.isBuiltInTestEventsUsed()) {
            operation.addProgressListener((ProgressListener)progressListener, new OperationType[]{OperationType.TEST, OperationType.TEST_OUTPUT, OperationType.TASK});
        }
    }

    private static void setupStandardIO(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(21);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(22);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(23);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(24);
        }
        operation.setStandardOutput((OutputStream)new OutputWrapper(listener2, id, true));
        operation.setStandardError((OutputStream)new OutputWrapper(listener2, id, false));
        InputStream inputStream = (InputStream)settings.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        if (inputStream != null) {
            operation.setStandardInput(inputStream);
        }
    }

    @VisibleForTesting
    public static void setupJvmArguments(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings) {
        List jvmArgs;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(25);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(26);
        }
        if (!(jvmArgs = ContainerUtil.filter((Collection)settings.getJvmArguments(), it -> !StringUtil.isEmpty((String)it))).isEmpty()) {
            operation.addJvmArguments(ArrayUtilRt.toStringArray((Collection)jvmArgs));
        }
    }

    private static void setupJavaHome(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable BuildEnvironment buildEnvironment) {
        String javaHome;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(27);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(28);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(29);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(30);
        }
        if ((javaHome = GradleExecutionHelper.getJavaHomeForOperation(settings, id, listener2, buildEnvironment)) == null) {
            return;
        }
        operation.setJavaHome(new File(javaHome));
        LOG.debug("Java home to set for Gradle operation: " + javaHome);
    }

    @Nullable
    private static String getJavaHomeForOperation(@NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable BuildEnvironment buildEnvironment) {
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(31);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(32);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(33);
        }
        if (Boolean.TRUE.equals(settings.getUserData(AUTO_JAVA_HOME)) && buildEnvironment != null) {
            Project project = id.getProject();
            GradleEnvironment gradle = buildEnvironment.getGradle();
            GradleVersion gradleVersion = GradleVersion.version((String)gradle.getGradleVersion());
            for (String sdkPath : ExternalSystemJdkUtil.suggestJdkHomePaths((Project)project)) {
                JavaVersion javaVersion = ExternalSystemJdkUtil.getJavaVersion((String)sdkPath);
                if (javaVersion == null || !GradleJvmSupportMatrix.isSupported(gradleVersion, javaVersion)) continue;
                listener2.onTaskOutput(id, GradleBundle.message("gradle.auto.jdk.was.selected", sdkPath) + System.lineSeparator(), ProcessOutputType.STDOUT);
                return sdkPath;
            }
        }
        return settings.getJavaHome();
    }

    private static void setupArguments(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(34);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(35);
        }
        GradleCommandLine commandLine = GradleExecutionHelper.fixUpGradleCommandLine(settings.getCommandLine());
        LOG.info("Passing command-line to Gradle Tooling API: " + StringUtil.join(GradleExecutionHelper.obfuscatePasswordParameters(commandLine.getTokens()), (String)" "));
        if (operation instanceof TestLauncher) {
            TestLauncher testLauncher = (TestLauncher)operation;
            GradleExecutionHelper.setupTestLauncherArguments(testLauncher, commandLine);
        } else if (operation instanceof BuildLauncher) {
            BuildLauncher buildLauncher = (BuildLauncher)operation;
            GradleExecutionHelper.setupBuildLauncherArguments(buildLauncher, commandLine, settings);
        } else {
            operation.withArguments(commandLine.getTokens());
        }
    }

    @NotNull
    private static GradleCommandLine fixUpGradleCommandLine(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(36);
        }
        ArrayList<GradleCommandLineTask> tasks2 = new ArrayList<GradleCommandLineTask>();
        for (GradleCommandLineTask task : commandLine.getTasks()) {
            String name = task.getName();
            List options = ContainerUtil.filter((Collection)task.getOptions(), it -> !GradleCommandLineUtil.isWildcardTestPattern(it));
            tasks2.add(new GradleCommandLineTask(name, options));
        }
        return new GradleCommandLine(tasks2, (List<? extends GradleCommandLineOption>)commandLine.getOptions());
    }

    private static void setupTestLauncherArguments(@NotNull TestLauncher testLauncher, @NotNull GradleCommandLine commandLine) {
        if (testLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(37);
        }
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(38);
        }
        for (GradleCommandLineTask task : commandLine.getTasks()) {
            Set<String> patterns = GradleCommandLineUtil.getTestPatterns(task);
            if (!patterns.isEmpty()) {
                testLauncher.withTestsFor(it -> it.forTaskPath(task.getName()).includePatterns((Collection)patterns));
                continue;
            }
            testLauncher.forTasks(ArrayUtil.toStringArray(task.getTokens()));
        }
        testLauncher.withArguments(commandLine.getOptions().getTokens());
    }

    private static void setupBuildLauncherArguments(@NotNull BuildLauncher buildLauncher, @NotNull GradleCommandLine commandLine, @NotNull GradleExecutionSettings settings) {
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(39);
        }
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(40);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(41);
        }
        buildLauncher.forTasks(ArrayUtil.toStringArray(commandLine.getTasks().getTokens()));
        buildLauncher.withArguments(commandLine.getOptions().getTokens());
        if (settings.isTestTaskRerun()) {
            Path initScript = GradleInitScriptUtil.createTestInitScript();
            buildLauncher.addArguments(new String[]{"--init-script", initScript.toString()});
        }
    }

    @VisibleForTesting
    public static void setupLogging(@NotNull GradleExecutionSettings settings, @Nullable BuildEnvironment buildEnvironment) {
        GradleProperties properties;
        LogLevel logLevel;
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(42);
        }
        List arguments = settings.getArguments();
        Collection options = GradleCommandLineOptionsProvider.LOGGING_OPTIONS.getOptions();
        List<String> optionsNames = GradleCommandLineOptionsProvider.getAllOptionsNames(options);
        if (ContainerUtil.exists(optionsNames, it -> arguments.contains(it))) {
            return;
        }
        Path buildRoot = GradleExecutionHelper.getBuildRoot(buildEnvironment);
        if (buildRoot != null && (logLevel = (properties = GradlePropertiesFile.getProperties(settings.getServiceDirectory(), buildRoot)).getGradleLogLevel()) != null) {
            switch (logLevel) {
                case DEBUG: {
                    settings.withArgument("-d");
                    break;
                }
                case INFO: {
                    settings.withArgument("-i");
                    break;
                }
                case WARN: {
                    settings.withArgument("-w");
                    break;
                }
                case QUIET: {
                    settings.withArgument("-q");
                }
            }
        }
        if (ContainerUtil.exists(optionsNames, it -> arguments.contains(it))) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isUnitTestMode()) {
            settings.withArgument("--info");
        }
    }

    @Nullable
    private static Path getBuildRoot(@Nullable BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            return null;
        }
        return buildEnvironment.getBuildIdentifier().getRootDir().toPath();
    }

    private static void setupEnvironment(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings) {
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider;
        TargetEnvironmentConfiguration environmentConfiguration;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(43);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(44);
        }
        if ((environmentConfiguration = (TargetEnvironmentConfiguration)ObjectUtils.doIfNotNull((Object)(environmentConfigurationProvider = ExternalSystemExecutionAware.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)settings)), it -> it.getEnvironmentConfiguration())) != null && !"local".equals(environmentConfiguration.getTypeId())) {
            if (settings.isPassParentEnvs()) {
                LOG.warn("Host system environment variables will not be passed for the target run.");
            }
            operation.setEnvironmentVariables(settings.getEnv());
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withEnvironment(settings.getEnv());
        commandLine.withParentEnvironmentType(settings.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Map effectiveEnvironment = commandLine.getEffectiveEnvironment();
        operation.setEnvironmentVariables(effectiveEnvironment);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull GradleExecutionContext context) {
        BuildEnvironment buildEnvironment;
        Scope ignore;
        Span span;
        block19: {
            BuildEnvironment buildEnvironment22;
            if (connection == null) {
                GradleExecutionHelper.$$$reportNull$$$0(45);
            }
            if (context == null) {
                GradleExecutionHelper.$$$reportNull$$$0(46);
            }
            span = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GetBuildEnvironment").startSpan();
            ignore = span.makeCurrent();
            try {
                ExternalSystemTaskId taskId = context.getTaskId();
                ExternalSystemTaskNotificationListener listener2 = context.getListener();
                ModelBuilder modelBuilder = connection.model(BuildEnvironment.class);
                modelBuilder.withCancellationToken(context.getCancellationToken());
                GradleExecutionHelper.setupJavaHome((LongRunningOperation)modelBuilder, context.getSettings(), taskId, listener2, null);
                GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, taskId, context.getProjectPath());
                modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
                modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
                modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener2, taskId, true));
                modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener2, taskId, false));
                buildEnvironment22 = (BuildEnvironment)modelBuilder.get();
            }
            catch (ExternalSystemException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to obtain build environment from Gradle daemon.", ex);
            }
            GradleExecutionHelper.checkThatGradleBuildEnvironmentIsSupportedByIdea(buildEnvironment22);
            GradleExecutionHelper.checkThatGradleBuildEnvironmentIsDeprecatedByIdea(context, buildEnvironment22);
            List checkers = GradleExecutionChecker.EP_NAME.getExtensionList();
            for (GradleExecutionChecker checker : checkers) {
                checker.checkExecution(context, buildEnvironment22);
            }
            buildEnvironment = buildEnvironment22;
            if (ignore == null) break block19;
            ignore.close();
        }
        BuildEnvironment buildEnvironment3 = buildEnvironment;
        if (buildEnvironment3 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(47);
        }
        return buildEnvironment3;
        {
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CancellationException ce) {
                    throw ce;
                }
                catch (Exception ex) {
                    span.recordException((Throwable)ex);
                    span.setStatus(StatusCode.ERROR);
                    throw ex;
                }
            }
        }
        finally {
            span.end();
        }
    }

    private static void checkThatGradleBuildEnvironmentIsDeprecatedByIdea(@NotNull GradleExecutionContext context, @NotNull BuildEnvironment buildEnvironment) {
        GradleVersion gradleVersion;
        if (context == null) {
            GradleExecutionHelper.$$$reportNull$$$0(48);
        }
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(49);
        }
        if (GradleJvmSupportMatrix.isGradleDeprecatedByIdea(gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion()))) {
            String projectPath = context.getProjectPath();
            DeprecatedGradleVersionIssue issue = new DeprecatedGradleVersionIssue(gradleVersion, projectPath);
            context.getListener().onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(context.getTaskId(), (BuildEvent)new BuildIssueEventImpl((Object)context.getTaskId(), (BuildIssue)issue, MessageEvent.Kind.WARNING)));
        }
    }

    private static void checkThatGradleBuildEnvironmentIsSupportedByIdea(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(50);
        }
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        LOG.debug("Gradle version: " + String.valueOf(gradleVersion));
        if (!GradleJvmSupportMatrix.isGradleSupportedByIdea(gradleVersion)) {
            throw new UnsupportedGradleVersionByIdeaException(gradleVersion);
        }
        File javaHome = buildEnvironment.getJava().getJavaHome();
        List jvmArguments = buildEnvironment.getJava().getJvmArguments();
        LOG.debug("Gradle java home: " + String.valueOf(javaHome));
        LOG.debug("Gradle jvm arguments: " + String.valueOf(jvmArguments));
        JavaVersion javaVersion = ExternalSystemJdkUtil.getJavaVersion((String)javaHome.getPath());
        if (javaVersion != null && !GradleJvmSupportMatrix.isJavaSupportedByIdea(javaVersion)) {
            throw new UnsupportedGradleJvmByIdeaException(gradleVersion, javaVersion);
        }
    }

    @VisibleForTesting
    @NotNull
    public static List<String> obfuscatePasswordParameters(@NotNull List<String> commandLineArguments) {
        if (commandLineArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(51);
        }
        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
        String PASSWORD_PARAMETER_IDENTIFIER = ".password=";
        for (String option : commandLineArguments) {
            int index = option.indexOf(".password=");
            if (index == -1) {
                replaced.add(option);
                continue;
            }
            replaced.add(option.substring(0, index + ".password=".length()) + "*********");
        }
        ArrayList<String> arrayList = replaced;
        if (arrayList == null) {
            GradleExecutionHelper.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    private static String getIdeaVersion() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        return appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 47, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 2: 
            case 19: 
            case 24: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
            case 6: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: 
            case 16: 
            case 21: 
            case 25: 
            case 27: 
            case 34: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 15: 
            case 17: 
            case 22: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 41: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 18: 
            case 23: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 20: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEnvironment";
                break;
            }
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testLauncher";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildLauncher";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildEnvironment";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "obfuscatePasswordParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuildEnvironment";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 6: 
            case 47: 
            case 52: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareForExecution";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyIdeaParameters";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setupProgressListeners";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setupStandardIO";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setupJvmArguments";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setupJavaHome";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getJavaHomeForOperation";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setupArguments";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fixUpGradleCommandLine";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setupTestLauncherArguments";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setupBuildLauncherArguments";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setupLogging";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkThatGradleBuildEnvironmentIsDeprecatedByIdea";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkThatGradleBuildEnvironmentIsSupportedByIdea";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "obfuscatePasswordParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 47, 52 -> new IllegalStateException(string);
        };
    }

    public static class UnsupportedGradleVersionByIdeaException
    extends RuntimeException {
        @NotNull
        private final GradleVersion myGradleVersion;

        public UnsupportedGradleVersionByIdeaException(@NotNull GradleVersion gradleVersion) {
            if (gradleVersion == null) {
                UnsupportedGradleVersionByIdeaException.$$$reportNull$$$0(0);
            }
            super("Unsupported Gradle version");
            this.myGradleVersion = gradleVersion;
        }

        @NotNull
        public GradleVersion getGradleVersion() {
            GradleVersion gradleVersion = this.myGradleVersion;
            if (gradleVersion == null) {
                UnsupportedGradleVersionByIdeaException.$$$reportNull$$$0(1);
            }
            return gradleVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleVersionByIdeaException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleVersionByIdeaException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class UnsupportedGradleJvmByIdeaException
    extends RuntimeException {
        @NotNull
        private final GradleVersion myGradleVersion;
        @Nullable
        private final JavaVersion myJavaVersion;

        public UnsupportedGradleJvmByIdeaException(@NotNull GradleVersion gradleVersion, @Nullable JavaVersion javaVersion) {
            if (gradleVersion == null) {
                UnsupportedGradleJvmByIdeaException.$$$reportNull$$$0(0);
            }
            super("Unsupported Gradle JVM version");
            this.myGradleVersion = gradleVersion;
            this.myJavaVersion = javaVersion;
        }

        @NotNull
        public GradleVersion getGradleVersion() {
            GradleVersion gradleVersion = this.myGradleVersion;
            if (gradleVersion == null) {
                UnsupportedGradleJvmByIdeaException.$$$reportNull$$$0(1);
            }
            return gradleVersion;
        }

        @Nullable
        public JavaVersion getJavaVersion() {
            return this.myJavaVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleJvmByIdeaException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleJvmByIdeaException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

