/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.telemetry;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.diagnostic.telemetry.OtlpConfiguration;
import com.intellij.platform.diagnostic.telemetry.impl.agent.AgentConfiguration;
import com.intellij.platform.diagnostic.telemetry.impl.agent.TelemetryAgentProvider;
import com.intellij.platform.diagnostic.telemetry.impl.agent.TelemetryAgentResolver;
import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContext;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContext;
import org.jetbrains.plugins.gradle.service.project.GradleExecutionHelperExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/telemetry/GradleTelemetryAgentProvidingExecutionHelperExtension;", "Lorg/jetbrains/plugins/gradle/service/project/GradleExecutionHelperExtension;", "<init>", "()V", "configureSettings", "", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "context", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContext;", "intellij.gradle"})
public final class GradleTelemetryAgentProvidingExecutionHelperExtension
implements GradleExecutionHelperExtension {
    @Override
    public void configureSettings(@NotNull GradleExecutionSettings settings, @NotNull GradleExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Registry.Companion.is("gradle.daemon.opentelemetry.agent.enabled", false)) {
            return;
        }
        URI uRI = OtlpConfiguration.getTraceEndpointURI();
        if (uRI == null) {
            return;
        }
        URI traceEndpoint = uRI;
        Path path = TelemetryAgentResolver.getAgentLocation();
        if (path == null) {
            return;
        }
        Path agentLocation = path;
        TelemetryContext telemetryContext = TelemetryContext.current();
        Intrinsics.checkNotNullExpressionValue((Object)telemetryContext, (String)"current(...)");
        AgentConfiguration configuration = AgentConfiguration.Companion.forService("Gradle", telemetryContext, traceEndpoint, agentLocation, AgentConfiguration.Settings.Companion.builder().build());
        List jvmArgs = TelemetryAgentProvider.getJvmArgs((AgentConfiguration)configuration);
        settings.withVmOptions(jvmArgs);
    }
}

