/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.jupyter.core.editor.NotebookContextMenuMouseListener;
import com.intellij.jupyter.core.editor.NotebookContextMenuMouseManagementKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\t\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookContextMenuMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "popupHandler", "com/intellij/jupyter/core/editor/NotebookContextMenuMouseListener$popupHandler$1", "Lcom/intellij/jupyter/core/editor/NotebookContextMenuMouseListener$popupHandler$1;", "mousePressed", "", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseReleased", "processEvent", "invokePopupIfNeeded", "intellij.jupyter.core"})
final class NotebookContextMenuMouseListener
implements EditorMouseListener {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final popupHandler.1 popupHandler;

    public NotebookContextMenuMouseListener(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.popupHandler = new ContextMenuPopupHandler.ById(this){
            final /* synthetic */ NotebookContextMenuMouseListener this$0;
            {
                this.this$0 = $receiver;
            }

            public String getActionGroupId(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return this.this$0.getEditor().getContextMenuGroupId();
            }
        };
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public void mousePressed(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processEvent(event);
    }

    public void mouseReleased(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processEvent(event);
    }

    private final void processEvent(EditorMouseEvent event) {
        if (event.isConsumed()) {
            return;
        }
        MouseEvent mouseEvent = event.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
        if (!NotebookContextMenuMouseManagementKt.hasContextMenuMouseButton(mouseEvent)) {
            return;
        }
        boolean bl = Intrinsics.areEqual((Object)event.getEditor(), (Object)this.editor);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int line = event.getLogicalPosition().line;
        if (line >= event.getEditor().getDocument().getLineCount()) {
            return;
        }
        Object object = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)this.editor));
        if (object == null || (object = object.getSelectedCells()) == null) {
            return;
        }
        Object selectedCells = object;
        NotebookCellLines.Interval currentCell = NotebookVisualizationUiUtilKt.getCell((Editor)((Editor)this.editor), (int)line);
        if (selectedCells.contains(currentCell)) {
            this.invokePopupIfNeeded(event);
        }
    }

    private final void invokePopupIfNeeded(EditorMouseEvent event) {
        if (Intrinsics.areEqual((Object)event.getArea(), (Object)EditorMouseEventArea.EDITING_AREA) && event.getMouseEvent().isPopupTrigger() && !event.isConsumed()) {
            this.popupHandler.handlePopup(event);
            event.consume();
        }
    }
}

