/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.convert;

import com.intellij.jupyter.core.jupyter.convert.VegaSupportKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0000\u00a8\u0006\u0005"}, d2={"requiresBrowserForRendering", "", "html", "", "getBrowserBasedScriptFallbackMessage", "intellij.jupyter.core"})
public final class BrowserBasedScriptDetectionKt {
    public static final boolean requiresBrowserForRendering(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        boolean hasPlotly = StringsKt.contains((CharSequence)html, (CharSequence)"plotly", (boolean)true) && (StringsKt.contains$default((CharSequence)html, (CharSequence)"Plotly.newPlot", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"plotly.min.js", (boolean)false, (int)2, null));
        boolean hasBokeh = StringsKt.contains((CharSequence)html, (CharSequence)"bokeh", (boolean)true) && (StringsKt.contains$default((CharSequence)html, (CharSequence)"Bokeh.embed", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"bokeh.min.js", (boolean)false, (int)2, null));
        boolean hasVega = VegaSupportKt.isVegaVisualization(html);
        boolean hasD3 = StringsKt.contains$default((CharSequence)html, (CharSequence)"d3.js", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"d3.min.js", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"d3.", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)html, (CharSequence)"<script", (boolean)false, (int)2, null);
        boolean hasRequireJs = StringsKt.contains$default((CharSequence)html, (CharSequence)"require.config", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"requirejs", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"require([", (boolean)false, (int)2, null);
        CharSequence charSequence = html;
        boolean hasExternalScripts = new Regex("<script[^>]*src=[\"']https?://", RegexOption.IGNORE_CASE).containsMatchIn(charSequence);
        boolean hasDomManipulation = StringsKt.contains$default((CharSequence)html, (CharSequence)"<script", (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)html, (CharSequence)"getElementById", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"querySelector", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"createElement", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"appendChild", (boolean)false, (int)2, null));
        boolean hasAsyncCode = StringsKt.contains$default((CharSequence)html, (CharSequence)"<script", (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)html, (CharSequence)"async ", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"await ", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)".then(", (boolean)false, (int)2, null));
        return hasPlotly || hasBokeh || hasVega || hasD3 || hasRequireJs || hasExternalScripts && hasDomManipulation || hasAsyncCode && hasDomManipulation;
    }

    @NotNull
    public static final String getBrowserBasedScriptFallbackMessage() {
        return "<div class=\"browser-script-fallback\" style=\"padding: 20px; background: #f0f0f0; border: 1px solid #ccc; border-radius: 4px;\">\n  <p><strong>Interactive Visualization</strong></p>\n  <p style=\"color: #666; font-size: 0.9em;\">\n    This cell contains a dynamic script that requires a browser to render properly.\n  </p>\n  <p style=\"color: #666; font-size: 0.9em;\">\n    To include this output in PDF exports, use the nbconvert-based export actions:\n  </p>\n  <ol style=\"color: #666; font-size: 0.9em; margin-left: 20px;\">\n    <li>Open the <strong>Find Action</strong> dialog (Ctrl+Shift+A / Cmd+Shift+A)</li>\n    <li>Search for \"<strong>nbconvert</strong>\"</li>\n    <li>Choose one of the export options:\n      <ul style=\"margin-top: 5px;\">\n        <li><em>Entire Notebook (nbconvert)</em></li>\n        <li><em>Only Outputs (nbconvert)</em></li>\n        <li><em>Markdown and Outputs (nbconvert)</em></li>\n      </ul>\n    </li>\n  </ol>\n  <p style=\"color: #888; font-size: 0.8em; margin-top: 10px;\">\n    Note: The first nbconvert export will automatically download required dependencies (Chrome browser).\n  </p>\n</div>";
    }
}

