/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.jupyter.data.input.JupyterAttachNewFileAction;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.utils.JupyterPathUtils;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0012\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/InputCellFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;)V", "getCell", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "parentFilePath", "", "getParentFilePath", "()Ljava/lang/String;", "parentFilePath$delegate", "Lkotlin/Lazy;", "notebookRelativizedFilePath", "getNotebookRelativizedFilePath", "notebookRelativizedFilePath$delegate", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.jupyter.core"})
final class InputCellFileAction
extends DumbAwareAction {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Editor editor;
    @NotNull
    private final JupyterCell cell;
    @NotNull
    private final Lazy parentFilePath$delegate;
    @NotNull
    private final Lazy notebookRelativizedFilePath$delegate;

    public InputCellFileAction(@NotNull VirtualFile file, @NotNull Editor editor, @NotNull JupyterCell cell) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        super(StringUtil.escapeMnemonics((String)file.getName()), null, JupyterCoreIcons.ImportDataCell);
        this.file = file;
        this.editor = editor;
        this.cell = cell;
        this.parentFilePath$delegate = LazyKt.lazy(() -> InputCellFileAction.parentFilePath_delegate$lambda$0(this));
        this.notebookRelativizedFilePath$delegate = LazyKt.lazy(() -> InputCellFileAction.notebookRelativizedFilePath_delegate$lambda$0(this));
    }

    @NotNull
    public final JupyterCell getCell() {
        return this.cell;
    }

    @Nullable
    public final String getParentFilePath() {
        Lazy lazy = this.parentFilePath$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getNotebookRelativizedFilePath() {
        Lazy lazy = this.notebookRelativizedFilePath$delegate;
        return (String)lazy.getValue();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = FileDocumentManager.getInstance().getFile(this.editor.getDocument());
        if (object == null || (object = object.toNioPath()) == null) {
            return;
        }
        Object notebookPath = object;
        Path path = this.file.toNioPath();
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        JupyterDataInputCellMetadataKt.setFileInfoUndoable(this.cell, path, project2, (Path)notebookPath, document);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        String string = this.getParentFilePath();
        if (string == null) {
            string = "";
        }
        presentation.putClientProperty(ActionUtil.SECONDARY_TEXT, (Object)string);
        e.getPresentation().setEnabled(CollectionsKt.contains((Iterable)JupyterAttachNewFileAction.Util.INSTANCE.getSupportedExtensions$intellij_jupyter_core(), (Object)this.file.getExtension()));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final String parentFilePath_delegate$lambda$0(InputCellFileAction this$0) {
        Project project = this$0.editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Path path = this$0.file.toNioPath().getParent();
        if (path == null) {
            return null;
        }
        Path parentOfFile = path;
        return JupyterPathUtils.INSTANCE.getFileUserPresentableString(parentOfFile, project2);
    }

    private static final String notebookRelativizedFilePath_delegate$lambda$0(InputCellFileAction this$0) {
        Project project = this$0.editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Object object = FileDocumentManager.getInstance().getFile(this$0.editor.getDocument());
        if (object == null || (object = object.toNioPath()) == null) {
            return null;
        }
        Object notebookPath = object;
        Path path = this$0.file.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        return JupyterPathUtils.INSTANCE.getFileNotebookRelativizedString(path, project2, (Path)notebookPath);
    }
}

