/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputValuesContributorExtensionPoint;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/InputCellTableAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "tableInfo", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputValuesContributorExtensionPoint$TableInfo;", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputValuesContributorExtensionPoint$TableInfo;Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;Lcom/intellij/openapi/editor/Editor;)V", "getTableInfo", "()Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputValuesContributorExtensionPoint$TableInfo;", "getCell", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.jupyter.core"})
final class InputCellTableAction
extends DumbAwareAction {
    @NotNull
    private final JupyterDataInputValuesContributorExtensionPoint.TableInfo tableInfo;
    @NotNull
    private final JupyterCell cell;
    @NotNull
    private final Editor editor;

    public InputCellTableAction(@NotNull JupyterDataInputValuesContributorExtensionPoint.TableInfo tableInfo, @NotNull JupyterCell cell, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)tableInfo, (String)"tableInfo");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(StringUtil.escapeMnemonics((String)tableInfo.getTableName()), null, JupyterCoreIcons.ImportDataCell);
        this.tableInfo = tableInfo;
        this.cell = cell;
        this.editor = editor;
    }

    @NotNull
    public final JupyterDataInputValuesContributorExtensionPoint.TableInfo getTableInfo() {
        return this.tableInfo;
    }

    @NotNull
    public final JupyterCell getCell() {
        return this.cell;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        CommandProcessor.getInstance().executeCommand(project2, () -> InputCellTableAction.actionPerformed$lambda$0(this, project2), null, null, this.editor.getDocument());
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().putClientProperty(ActionUtil.SECONDARY_TEXT, (Object)this.tableInfo.getSchemaName());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final void actionPerformed$lambda$0(InputCellTableAction this$0, Project $project) {
        JupyterCell jupyterCell = this$0.cell;
        String string = this$0.tableInfo.getDataSourceUniqueId();
        String string2 = this$0.tableInfo.getTableObjectPath();
        String string3 = this$0.tableInfo.getTableName();
        Document document = this$0.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        JupyterDataInputCellTableMetadataKt.setTableInfoUndoable(jupyterCell, string, string2, string3, $project, document);
    }
}

