/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.actions.FileSaveUtils;
import com.intellij.jupyter.core.jupyter.editor.outputs.image.ImageComponentWrapper;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/actions/JupyterSaveImageOutputAsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.jupyter.core"})
public final class JupyterSaveImageOutputAsAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getData(ImageComponentWrapper.Companion.getORIGINAL_IMAGE()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ImageComponentWrapper imageComponentWrapper = (ImageComponentWrapper)e.getData(ImageComponentWrapper.Companion.getIMAGE_COMPONENT());
        if (imageComponentWrapper == null) {
            return;
        }
        ImageComponentWrapper imageComponent = imageComponentWrapper;
        Pair pair = (Pair)e.getData(ImageComponentWrapper.Companion.getORIGINAL_IMAGE());
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        String format = (String)pair2.component1();
        String image = (String)pair2.component2();
        String[] stringArray = new String[]{JupyterBundle.message("notebook.save.output.option.original", new Object[0]), JupyterBundle.message("notebook.save.output.option.as.displayed", new Object[0])};
        String[] dialogOptions = stringArray;
        int choiceDialog = Messages.showChooseDialog((Project)e.getProject(), (String)JupyterBundle.message("notebook.save.output.option.text", new Object[0]), (String)JupyterBundle.message("notebook.save.output.title", new Object[0]), null, (String[])dialogOptions, (String)dialogOptions[0]);
        if (choiceDialog == -1) {
            return;
        }
        switch (choiceDialog) {
            case 0: {
                byte[] byArray = Base64.getMimeDecoder().decode(image);
                Intrinsics.checkNotNull((Object)byArray);
                object = byArray;
                break;
            }
            case 1: {
                object = imageComponent.getImage();
                if (object != null) {
                    BufferedImage it = object;
                    boolean bl = false;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)it, format, outputStream);
                    byte[] byArray = outputStream.toByteArray();
                    object = byArray;
                    if (byArray != null) break;
                }
                return;
            }
            default: {
                return;
            }
        }
        Object imageData = object;
        VirtualFileWrapper wrapper = FileSaveUtils.createSaveFile$default(FileSaveUtils.INSTANCE, e.getProject(), "output." + format, JupyterBundle.message("notebook.save.output.title", new Object[0]), null, 8, null);
        FileSaveUtils.INSTANCE.saveToFile(wrapper, (byte[])imageData);
    }
}

