/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.controllers.frame;

import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.visualization.controllers.selfUpdate.SelfManagedCellController;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorLayerController;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.ui.providers.frame.CellFrameState;
import com.intellij.notebooks.visualization.ui.providers.frame.EditorCellFrameManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.observable.properties.ObservableProperty;
import java.awt.Color;
import java.awt.geom.Line2D;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/controllers/frame/CellFrameRightLineController;", "Lcom/intellij/notebooks/visualization/controllers/selfUpdate/SelfManagedCellController;", "editorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "getEditorCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "frameManager", "Lcom/intellij/notebooks/visualization/ui/providers/frame/EditorCellFrameManager;", "rightBorderLineAndColor", "Lkotlin/Pair;", "Ljava/awt/geom/Line2D;", "Ljava/awt/Color;", "frameState", "Lcom/intellij/notebooks/visualization/ui/providers/frame/CellFrameState;", "getFrameState", "()Lcom/intellij/notebooks/visualization/ui/providers/frame/CellFrameState;", "dispose", "", "drawRightBorder", "removeRightBorder", "intellij.jupyter.core"})
public final class CellFrameRightLineController
implements SelfManagedCellController {
    @NotNull
    private final EditorCell editorCell;
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private final EditorCellFrameManager frameManager;
    @Nullable
    private Pair<? extends Line2D, ? extends Color> rightBorderLineAndColor;

    public CellFrameRightLineController(@NotNull EditorCell editorCell) {
        Intrinsics.checkNotNullParameter((Object)editorCell, (String)"editorCell");
        this.editorCell = editorCell;
        this.editor = this.editorCell.getEditor();
        this.frameManager = this.editorCell.getCellFrameManager();
        EditorCellFrameManager editorCellFrameManager = this.frameManager;
        if (editorCellFrameManager != null && (editorCellFrameManager = editorCellFrameManager.getState()) != null) {
            NotebookEditorUiUtilKt.bind((ObservableProperty)((ObservableProperty)editorCellFrameManager), (Disposable)((Disposable)this), arg_0 -> CellFrameRightLineController._init_$lambda$0(this, arg_0));
        }
        JupyterBoundsChangeHandler.Companion.get((Editor)this.editor).subscribe((Disposable)this, () -> CellFrameRightLineController._init_$lambda$1(this));
    }

    @NotNull
    public final EditorCell getEditorCell() {
        return this.editorCell;
    }

    private final CellFrameState getFrameState() {
        EditorCellFrameManager editorCellFrameManager = this.frameManager;
        return editorCellFrameManager != null && (editorCellFrameManager = editorCellFrameManager.getState()) != null ? (CellFrameState)editorCellFrameManager.get() : null;
    }

    public void dispose() {
        this.removeRightBorder();
    }

    private final void drawRightBorder() {
        CellFrameState cellFrameState = this.getFrameState();
        if (cellFrameState == null) {
            return;
        }
        CellFrameState frameState = cellFrameState;
        if (!frameState.isVisible()) {
            return;
        }
        Color color = frameState.getColor();
        Object object = this.frameManager;
        if (object == null || (object = object.getOrCalculateLineFrameVerticalLine()) == null) {
            return;
        }
        Object line2DDouble = object;
        Pair<? extends Line2D, ? extends Color> pair = this.rightBorderLineAndColor;
        if (Intrinsics.areEqual((Object)(pair != null ? (Line2D)pair.getFirst() : null), (Object)line2DDouble)) {
            Pair<? extends Line2D, ? extends Color> pair2 = this.rightBorderLineAndColor;
            if (Intrinsics.areEqual((Object)(pair2 != null ? (Color)pair2.getSecond() : null), (Object)color)) {
                return;
            }
        }
        EditorLayerController editorLayerController = EditorLayerController.Companion.getLayerController(this.editor);
        if (editorLayerController == null) {
            return;
        }
        EditorLayerController layerController = editorLayerController;
        Pair<? extends Line2D, ? extends Color> pair3 = this.rightBorderLineAndColor;
        Line2D oldLine = pair3 != null ? (Line2D)pair3.getFirst() : null;
        layerController.replaceOverlayLine(oldLine, (Line2D)line2DDouble, color);
        this.rightBorderLineAndColor = new Pair(line2DDouble, (Object)color);
    }

    private final void removeRightBorder() {
        Object object = this.rightBorderLineAndColor;
        if (object == null || (object = (Line2D)object.getFirst()) == null) {
            return;
        }
        Object line = object;
        EditorLayerController editorLayerController = EditorLayerController.Companion.getLayerController(this.editor);
        if (editorLayerController == null) {
            return;
        }
        EditorLayerController layerController = editorLayerController;
        layerController.removeOverlayLine(line);
        this.rightBorderLineAndColor = null;
    }

    private static final Unit _init_$lambda$0(CellFrameRightLineController this$0, CellFrameState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.isVisible()) {
            this$0.drawRightBorder();
        } else {
            this$0.removeRightBorder();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(CellFrameRightLineController this$0) {
        this$0.drawRightBorder();
        return Unit.INSTANCE;
    }
}

