/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs;

import com.intellij.jupyter.core.extensions.JBCefBrowserExtKt;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterSvgDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.util.ImageOutputUtilKt;
import com.intellij.notebooks.visualization.outputs.NotebookOutputComponentFactory;
import com.intellij.notebooks.visualization.outputs.NotebookOutputInlayControllerUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterSvgOutputComponentFactory;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterSvgOutputComponentFactory$JupyterSvgComponent;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterSvgDataKey;", "<init>", "()V", "componentClass", "Ljava/lang/Class;", "getComponentClass", "()Ljava/lang/Class;", "outputDataKeyClass", "getOutputDataKeyClass", "match", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$Match;", "component", "outputDataKey", "updateComponent", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "createComponent", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "JupyterSvgComponent", "intellij.jupyter.core"})
public final class JupyterSvgOutputComponentFactory
implements NotebookOutputComponentFactory<JupyterSvgComponent, JupyterSvgDataKey> {
    @NotNull
    private final Class<JupyterSvgComponent> componentClass = JupyterSvgComponent.class;
    @NotNull
    private final Class<JupyterSvgDataKey> outputDataKeyClass = JupyterSvgDataKey.class;

    @NotNull
    public Class<JupyterSvgComponent> getComponentClass() {
        return this.componentClass;
    }

    @NotNull
    public Class<JupyterSvgDataKey> getOutputDataKeyClass() {
        return this.outputDataKeyClass;
    }

    @NotNull
    public NotebookOutputComponentFactory.Match match(@NotNull JupyterSvgComponent component2, @NotNull JupyterSvgDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        return component2.compare(outputDataKey.getSvg()) ? NotebookOutputComponentFactory.Match.SAME : NotebookOutputComponentFactory.Match.COMPATIBLE;
    }

    public void updateComponent(@NotNull EditorImpl editor, @NotNull JupyterSvgComponent component2, @NotNull JupyterSvgDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        component2.update(outputDataKey.getSvg());
    }

    @NotNull
    public NotebookOutputComponentFactory.CreatedComponent<JupyterSvgComponent> createComponent(@NotNull EditorImpl editor, @NotNull JupyterSvgDataKey outputDataKey) {
        JupyterSvgComponent jupyterSvgComponent;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        JupyterSvgComponent $this$createComponent_u24lambda_u240 = jupyterSvgComponent = new JupyterSvgComponent();
        boolean bl = false;
        $this$createComponent_u24lambda_u240.update(outputDataKey.getSvg());
        JupyterSvgComponent jupyterSvgComponent2 = jupyterSvgComponent;
        jupyterSvgComponent = NotebookOutputComponentFactory.WidthStretching.STRETCH_AND_SQUEEZE;
        return new NotebookOutputComponentFactory.CreatedComponent((JComponent)jupyterSvgComponent2, (NotebookOutputComponentFactory.WidthStretching)jupyterSvgComponent, false, true, JupyterSvgOutputComponentFactory::createComponent$lambda$1, null, null, null, 160, null);
    }

    private static final String createComponent$lambda$1() {
        return JupyterBundle.message("notebook.collapsed.svg.output.text", new Object[0]);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterSvgOutputComponentFactory$JupyterSvgComponent;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "svg", "", "browser", "Lcom/intellij/ui/jcef/JBCefBrowserBase;", "resizeJsQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "initialImageDimension", "Lkotlin/Pair;", "", "reverseAspectRatio", "", "updateUI", "", "getPreferredSize", "Ljava/awt/Dimension;", "getStretchedSize", "doLayout", "compare", "", "update", "updateUiImpl", "resizeJsQueryHandler", "Lcom/intellij/ui/jcef/JBCefJSQuery$Response;", "payload", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterSvgOutputComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterSvgOutputComponentFactory.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterSvgOutputComponentFactory$JupyterSvgComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,223:1\n1586#2:224\n1661#2,3:225\n23#3:228\n*S KotlinDebug\n*F\n+ 1 JupyterSvgOutputComponentFactory.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterSvgOutputComponentFactory$JupyterSvgComponent\n*L\n211#1:224\n211#1:225,3\n218#1:228\n*E\n"})
    public static final class JupyterSvgComponent
    extends JPanel
    implements Disposable.Default {
        @Nullable
        private String svg;
        @NotNull
        private JBCefBrowserBase browser;
        @NotNull
        private final JBCefJSQuery resizeJsQuery;
        @Nullable
        private Pair<Integer, Integer> initialImageDimension;
        private double reverseAspectRatio;

        public JupyterSvgComponent() {
            super(null);
            JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setOffScreenRendering(true).setMouseWheelEventEnable(false).build();
            Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
            this.browser = (JBCefBrowserBase)jBCefBrowser;
            Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.browser));
            JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)this.browser);
            Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
            this.resizeJsQuery = jBCefJSQuery;
            WeakReference<JupyterSvgComponent> weakThis = new WeakReference<JupyterSvgComponent>(this);
            this.resizeJsQuery.addHandler(arg_0 -> JupyterSvgComponent._init_$lambda$1(arg_0 -> JupyterSvgComponent._init_$lambda$0(weakThis, arg_0), arg_0));
            JComponent jComponent = this.browser.getComponent();
            Intrinsics.checkNotNull((Object)jComponent);
            this.add(jComponent);
            this.updateUiImpl();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.updateUiImpl();
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            return this.getStretchedSize();
        }

        private final Dimension getStretchedSize() {
            Pair<Integer, Integer> initialImageDimension = this.initialImageDimension;
            return this.reverseAspectRatio <= 0.0 || this.getWidth() <= 0 ? new Dimension(0, 0) : (this.getHeight() > 0 ? new Dimension(this.getWidth(), this.getHeight()) : (initialImageDimension != null && this.getWidth() >= ((Number)initialImageDimension.getFirst()).intValue() ? new Dimension(((Number)initialImageDimension.getFirst()).intValue(), ((Number)initialImageDimension.getSecond()).intValue()) : ImageOutputUtilKt.fitToRatioOf(new Dimension(this.getWidth(), (int)Math.ceil((double)this.getWidth() * this.reverseAspectRatio)), new Dimension(10000, 2000))));
        }

        @Override
        public void doLayout() {
            boolean bl;
            boolean bl2 = bl = this.getComponentCount() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Component child = this.getComponent(0);
            Dimension stretchedSize = this.getStretchedSize();
            if (stretchedSize.width > 0 && stretchedSize.height > 0 && !Intrinsics.areEqual((Object)child.getSize(), (Object)stretchedSize)) {
                this.revalidate();
            }
            child.setBounds(0, 0, stretchedSize.width, stretchedSize.height);
        }

        public final boolean compare(@NotNull String svg) {
            Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
            return Intrinsics.areEqual((Object)this.svg, (Object)svg);
        }

        public final void update(@NotNull String svg) {
            String string;
            Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
            this.svg = svg;
            this.setSize(new Dimension(0, 0));
            this.initialImageDimension = null;
            this.reverseAspectRatio = 0.0;
            NotebookOutputInlayControllerUtilKt.resetOutputInlayCustomHeight((Component)this.getParent());
            if (StringsKt.startsWith$default((String)svg, (String)"<!", (boolean)false, (int)2, null)) {
                String string2 = svg.substring(((String)SequencesKt.first((Sequence)StringsKt.lineSequence((CharSequence)svg))).length());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = svg;
            }
            String svgWithoutDoctype = string;
            String html = "<!doctype html>\n<html>\n<head>\n<style type='text/css'>\nbody {\n  margin: 0;\n  overflow-y: hidden;\n}\nsvg {\n  max-height: 100vh;\n}\n</style>\n</head>\n<body>\n" + svgWithoutDoctype + "\n<script type='text/javascript'>\n" + JBCefBrowserExtKt.jsCodeSettingBackgroundToEditorColor() + ";\n\nlet payload;\n\nlet svg = document.getElementsByTagName(\"svg\")[0];\nsvg.setAttribute(\"preserveAspectRatio\", \"xMinYMin meet\");\nif (svg.hasAttribute(\"width\") && svg.hasAttribute(\"height\")) {\n  let w = svg.width.baseVal.value;\n  let h = svg.height.baseVal.value;\n  if (w > 0 && h > 0) {\n    payload = w + ' ' + h;\n  }\n}\nif (!payload) {\n  payload = 'R' + svg.viewBox.baseVal.height / svg.viewBox.baseVal.width;\n}\nsvg.removeAttribute(\"width\");\nsvg.removeAttribute(\"height\");\n\nwindow." + this.resizeJsQuery.getFuncName() + "({request: payload});\n</script>\n</body>\n</html>\n";
            this.browser.loadHTML(html);
        }

        private final void updateUiImpl() {
            block0: {
                JBCefBrowserBase jBCefBrowserBase = this.browser;
                if (jBCefBrowserBase == null || (jBCefBrowserBase = jBCefBrowserBase.getCefBrowser()) == null) break block0;
                JBCefBrowserBase $this$updateUiImpl_u24lambda_u240 = jBCefBrowserBase;
                boolean bl = false;
                $this$updateUiImpl_u24lambda_u240.executeJavaScript(JBCefBrowserExtKt.jsCodeSettingBackgroundToEditorColor(), $this$updateUiImpl_u24lambda_u240.getURL(), 0);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final JBCefJSQuery.Response resizeJsQueryHandler(String payload) {
            try {
                if (StringsKt.startsWith$default((String)payload, (String)"R", (boolean)false, (int)2, null)) {
                    this.initialImageDimension = null;
                    String string = payload.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    this.reverseAspectRatio = Double.parseDouble(string);
                } else {
                    void $this$mapTo$iv$iv;
                    char[] cArray = new char[]{' '};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)payload, (char[])cArray, (boolean)false, (int)2, (int)2, null);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(Double.parseDouble((String)p0));
                    }
                    List list = (List)destination$iv$iv;
                    double width = ((Number)list.get(0)).doubleValue();
                    double height = ((Number)list.get(1)).doubleValue();
                    this.initialImageDimension = TuplesKt.to((Object)((int)Math.ceil(width)), (Object)((int)Math.ceil(height)));
                    this.reverseAspectRatio = height / width;
                }
                this.revalidate();
            }
            catch (Exception err) {
                JupyterSvgComponent $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterSvgComponent.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to get height of an SVG image rendered via JCef, payload: " + payload, (Throwable)err);
            }
            return new JBCefJSQuery.Response("");
        }

        private static final JBCefJSQuery.Response _init_$lambda$0(WeakReference $weakThis, String payload) {
            JBCefJSQuery.Response response;
            JupyterSvgComponent jupyterSvgComponent = (JupyterSvgComponent)$weakThis.get();
            if (jupyterSvgComponent != null) {
                Intrinsics.checkNotNull((Object)payload);
                response = jupyterSvgComponent.resizeJsQueryHandler(payload);
            } else {
                response = null;
            }
            return response;
        }

        private static final JBCefJSQuery.Response _init_$lambda$1(Function1 $tmp0, Object p0) {
            return (JBCefJSQuery.Response)$tmp0.invoke(p0);
        }
    }
}

