/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralLocalSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.UrlOpener;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.system.OS;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\fH\u0016J$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J$\u0010\u0015\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\"\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J8\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\n\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0014J\u001a\u0010\u001f\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\u0007H\u0014J?\u0010\"\u001a\u00020\u00052\r\u0010#\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b$2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001cH\u0014J\u0012\u0010-\u001a\u00020.2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001c\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00060"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherAppless;", "Lcom/intellij/ide/browsers/BrowserLauncher;", "<init>", "()V", "open", "", "url", "", "openWithDesktopApi", "file", "Ljava/io/File;", "browse", "Ljava/nio/file/Path;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "project", "Lcom/intellij/openapi/project/Project;", "uri", "Ljava/net/URI;", "openMailToUrl", "", "processWithUrlOpener", "openWithDefaultBrowserCommand", "openWithBrowser", "spawn", "command", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "retry", "Lkotlin/Function0;", "signUrl", "getDefaultBrowser", "canBrowse", "substituteBrowser", "browserPath", "showError", "message", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "generalSettings", "Lcom/intellij/ide/GeneralLocalSettings;", "getGeneralSettings", "()Lcom/intellij/ide/GeneralLocalSettings;", "defaultBrowserCommand", "", "getDefaultBrowserCommand", "()Ljava/util/List;", "getScope", "Lkotlinx/coroutines/CoroutineScope;", "Companion", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBrowserLauncherAppless.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserLauncherAppless.kt\ncom/intellij/ide/browsers/BrowserLauncherAppless\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n106#2:275\n78#2,22:276\n60#3,5:298\n60#3,5:305\n60#3,5:311\n13#3:316\n1807#4,2:303\n1809#4:310\n*S KotlinDebug\n*F\n+ 1 BrowserLauncherAppless.kt\ncom/intellij/ide/browsers/BrowserLauncherAppless\n*L\n99#1:275\n99#1:276,22\n100#1:298,5\n172#1:305,5\n230#1:311,5\n36#1:316\n171#1:303,2\n171#1:310\n*E\n"})
public class BrowserLauncherAppless
extends BrowserLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public void open(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (BrowserUtil.isAbsoluteURL(url)) {
            this.browse(url, null, null);
        } else {
            File file = new File(url);
            if (BrowserLauncherAppless.Companion.isDesktopActionSupported(Desktop.Action.OPEN)) {
                if (!file.exists()) {
                    Object[] objectArray = new Object[]{file.getPath()};
                    BrowserLauncherAppless.showError$default(this, IdeBundle.message("error.file.does.not.exist", objectArray), null, null, null, 12, null);
                    return;
                }
                this.openWithDesktopApi(url, file);
            } else {
                this.browse(file);
            }
        }
    }

    private final void openWithDesktopApi(String url, File file) {
        BuildersKt.launch$default((CoroutineScope)this.getScope(null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, url, this, null){
            int label;
            final /* synthetic */ File $file;
            final /* synthetic */ String $url;
            final /* synthetic */ BrowserLauncherAppless this$0;
            {
                this.$file = $file;
                this.$url = $url;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            void $this$debug_u24default$iv;
                            Logger logger = BrowserLauncherAppless.access$getLOG$cp();
                            String string = this.$url;
                            Throwable t$iv = null;
                            boolean $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                void var7_7 = $this$debug_u24default$iv;
                                boolean bl = false;
                                var7_7.debug("trying Desktop#open on [" + string + "]", t$iv);
                            }
                            Desktop.getDesktop().open(this.$file);
                        }
                        catch (IOException e) {
                            BrowserLauncherAppless.access$getLOG$cp().warn("[" + this.$url + "]", (Throwable)e);
                            this.this$0.browse(this.$file);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void browse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String path = file.getAbsolutePath();
        String absPath = OS.CURRENT == OS.Windows && path.charAt(0) != '/' ? "/" + path : path;
        this.browse("file://" + absPath, null, null);
    }

    @Override
    public void browse(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String path = ((Object)file.toAbsolutePath()).toString();
        String absPath = OS.CURRENT == OS.Windows && path.charAt(0) != '/' ? "/" + path : path;
        this.browse("file://" + absPath, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void browse(@NotNull String url, @Nullable WebBrowser browser, @Nullable Project project) {
        Object[] objectArray;
        void $this$trim$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        SideEffectGuard.Companion.checkSideEffectAllowed(SideEffectGuard.EffectType.EXEC);
        if (StringsKt.startsWith$default((String)url, (String)"jar:", (boolean)false, (int)2, null)) {
            LOG.info("ignoring 'jar:' URL");
            return;
        }
        String string = url;
        BrowserLauncherAppless browserLauncherAppless = this;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String signedUrl = browserLauncherAppless.signUrl(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            browserLauncherAppless = $this$debug_u24default$iv;
            boolean bl = false;
            browserLauncherAppless.debug("opening [" + signedUrl + "]", t$iv);
        }
        if (!this.canBrowse(project, signedUrl)) {
            return;
        }
        URI uri = VfsUtil.toUri((String)signedUrl);
        if (uri == null) {
            objectArray = new Object[]{signedUrl};
            BrowserLauncherAppless.showError$default(this, IdeBundle.message("error.malformed.url", objectArray), project, null, null, 12, null);
            return;
        }
        if (StringsKt.equals((String)uri.getScheme(), (String)"file", (boolean)true) && uri.getHost() != null) {
            objectArray = new Object[]{uri};
            BrowserLauncherAppless.showError$default(this, IdeBundle.message("error.unc.not.supported", objectArray), project, null, null, 12, null);
            return;
        }
        this.browse(uri, browser, project);
    }

    private final void browse(URI uri, WebBrowser browser, Project project) {
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        if (this.processWithUrlOpener(browser, string, project)) {
            return;
        }
        if (this.openMailToUrl(uri, project)) {
            return;
        }
        GeneralLocalSettings settings = this.getGeneralSettings();
        if (settings.getUseDefaultBrowser()) {
            if (BrowserLauncherAppless.Companion.isDesktopActionSupported(Desktop.Action.BROWSE)) {
                this.openWithDesktopApi(uri, project);
            } else {
                String string2 = uri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                this.openWithDefaultBrowserCommand(string2, project);
            }
        } else {
            String browserPath = settings.getBrowserPath();
            WebBrowser substitutedBrowser = this.substituteBrowser(browserPath);
            if (substitutedBrowser != null) {
                String string3 = uri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                this.openWithBrowser(string3, substitutedBrowser, project);
            } else {
                BrowserLauncherAppless.spawn$default(this, new GeneralCommandLine(BrowserUtil.getOpenBrowserCommand(browserPath, uri.toString(), CollectionsKt.emptyList(), false)), project, null, () -> BrowserLauncherAppless.browse$lambda$2(this, uri, project), 4, null);
            }
        }
    }

    private final boolean openMailToUrl(URI uri, Project project) {
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"mailto") && BrowserLauncherAppless.Companion.isDesktopActionSupported(Desktop.Action.MAIL)) {
            BuildersKt.launch$default((CoroutineScope)this.getScope(project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, null){
                int label;
                final /* synthetic */ URI $uri;
                {
                    this.$uri = $uri;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            try {
                                BrowserLauncherAppless.access$getLOG$cp().debug("trying Desktop#mail");
                                Desktop.getDesktop().mail(this.$uri);
                            }
                            catch (Exception e) {
                                BrowserLauncherAppless.access$getLOG$cp().warn("[" + this.$uri + "]", (Throwable)e);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return true;
        }
        return false;
    }

    private final boolean processWithUrlOpener(WebBrowser browser, String url, Project project) {
        if (browser != null || StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null)) {
            WebBrowser effectiveBrowser;
            WebBrowser webBrowser = browser;
            if (webBrowser == null) {
                webBrowser = this.getDefaultBrowser();
            }
            if ((effectiveBrowser = webBrowser) != null) {
                boolean handled;
                block8: {
                    Iterable $this$any$iv = UrlOpener.EP_NAME.getExtensionList();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UrlOpener it = (UrlOpener)element$iv;
                            boolean bl = false;
                            Logger $this$debug_u24default$iv = LOG;
                            Throwable t$iv = null;
                            boolean $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                Logger logger = $this$debug_u24default$iv;
                                boolean bl2 = false;
                                logger.debug("trying " + it.getClass(), t$iv);
                            }
                            if (!it.openUrl(effectiveBrowser, url, project)) continue;
                            v1 = true;
                            break block8;
                        }
                        v1 = handled = false;
                    }
                }
                if (!handled) {
                    this.openWithBrowser(url, effectiveBrowser, project);
                }
                return true;
            }
        }
        return false;
    }

    private final void openWithDesktopApi(URI uri, Project project) {
        BuildersKt.launch$default((CoroutineScope)this.getScope(project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, this, project, null){
            int label;
            final /* synthetic */ URI $uri;
            final /* synthetic */ BrowserLauncherAppless this$0;
            final /* synthetic */ Project $project;
            {
                this.$uri = $uri;
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            BrowserLauncherAppless.access$getLOG$cp().debug("trying Desktop#browse");
                            Desktop.getDesktop().browse(this.$uri);
                        }
                        catch (Exception e) {
                            BrowserLauncherAppless.access$getLOG$cp().warn("[" + this.$uri + "]", (Throwable)e);
                            if (OS.CURRENT == OS.macOS) {
                                String string = e.getMessage();
                                Intrinsics.checkNotNull((Object)string);
                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Error code: -10814", (boolean)false, (int)2, null)) {
                                    return Unit.INSTANCE;
                                }
                            }
                            String string = this.$uri.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                            BrowserLauncherAppless.access$openWithDefaultBrowserCommand(this.this$0, string, this.$project);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void openWithDefaultBrowserCommand(String url, Project project) {
        Function0 retry = () -> BrowserLauncherAppless.openWithDefaultBrowserCommand$lambda$0(this, url, project);
        List<String> command = this.getDefaultBrowserCommand();
        if (command == null) {
            this.showError(IdeBundle.message("browser.default.not.supported", new Object[0]), project, null, (Function0<Unit>)retry);
            return;
        }
        String[] stringArray = new String[]{url};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(command).withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        this.spawn(generalCommandLine, project, null, (Function0<Unit>)retry);
    }

    private final void openWithBrowser(String url, WebBrowser browser, Project project) {
        Object object;
        Object parameters;
        Function0 retry = () -> BrowserLauncherAppless.openWithBrowser$lambda$0(this, url, browser, project);
        String browserPath = PathUtil.toSystemDependentName((String)browser.getPath());
        CharSequence charSequence = browserPath;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.showError(browser.getBrowserNotFoundMessage(), project, browser, (Function0<Unit>)retry);
            return;
        }
        Object object2 = browser.getSpecificSettings();
        if (object2 == null || (object2 = ((BrowserSpecificSettings)object2).getAdditionalParameters()) == null) {
            object2 = parameters = CollectionsKt.emptyList();
        }
        if ((object = browser.getSpecificSettings()) == null || (object = ((BrowserSpecificSettings)object).getEnvironmentVariables()) == null) {
            object = MapsKt.emptyMap();
        }
        Object environment = object;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(BrowserUtil.getOpenBrowserCommand(browserPath, url, (List<String>)parameters, false)).withEnvironment((Map)environment);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withEnvironment(...)");
        GeneralCommandLine command = generalCommandLine;
        this.spawn(command, project, browser, (Function0<Unit>)retry);
    }

    private final void spawn(GeneralCommandLine command, Project project, WebBrowser browser, Function0<Unit> retry) {
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("starting [" + command.getCommandLineString() + "]", t$iv);
        }
        BuildersKt.launch$default((CoroutineScope)this.getScope(project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(command, this, project, browser, retry, null){
            int label;
            final /* synthetic */ GeneralCommandLine $command;
            final /* synthetic */ BrowserLauncherAppless this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ WebBrowser $browser;
            final /* synthetic */ Function0<Unit> $retry;
            {
                this.$command = $command;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$browser = $browser;
                this.$retry = $retry;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            ProcessOutput output = new CapturingProcessHandler.Silent(this.$command).runProcess(10000, false);
                            if (!output.checkSuccess(BrowserLauncherAppless.access$getLOG$cp()) && output.getExitCode() == 1) {
                                List list = output.getStderrLines();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStderrLines(...)");
                                String error = (String)CollectionsKt.firstOrNull((List)list);
                                this.this$0.showError(error, this.$project, this.$browser, this.$retry);
                            }
                        }
                        catch (ExecutionException e) {
                            BrowserLauncherAppless.access$getLOG$cp().warn((Throwable)e);
                            this.this$0.showError(e.getMessage(), this.$project, this.$browser, this.$retry);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    static /* synthetic */ void spawn$default(BrowserLauncherAppless browserLauncherAppless, GeneralCommandLine generalCommandLine, Project project, WebBrowser webBrowser, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: spawn");
        }
        if ((n & 4) != 0) {
            webBrowser = null;
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        browserLauncherAppless.spawn(generalCommandLine, project, webBrowser, (Function0<Unit>)function0);
    }

    @NotNull
    protected String signUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return url;
    }

    @Nullable
    protected WebBrowser getDefaultBrowser() {
        return null;
    }

    protected boolean canBrowse(@Nullable Project project, @NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return true;
    }

    @Nullable
    protected WebBrowser substituteBrowser(@NotNull String browserPath) {
        Intrinsics.checkNotNullParameter((Object)browserPath, (String)"browserPath");
        return null;
    }

    protected void showError(@Nullable String message, @Nullable Project project, @Nullable WebBrowser browser, @Nullable Function0<Unit> retry) {
        LOG.warn(message);
    }

    public static /* synthetic */ void showError$default(BrowserLauncherAppless browserLauncherAppless, String string, Project project, WebBrowser webBrowser, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showError");
        }
        if ((n & 4) != 0) {
            webBrowser = null;
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        browserLauncherAppless.showError(string, project, webBrowser, (Function0<Unit>)function0);
    }

    private final GeneralLocalSettings getGeneralSettings() {
        return ApplicationManager.getApplication() != null ? GeneralLocalSettings.Companion.getInstance() : new GeneralLocalSettings();
    }

    private final List<String> getDefaultBrowserCommand() {
        List list;
        if (OS.CURRENT == OS.Windows) {
            Object[] objectArray = new String[4];
            Intrinsics.checkNotNullExpressionValue((Object)CommandLineUtil.getWinShellName(), (String)"getWinShellName(...)");
            objectArray[1] = "/c";
            objectArray[2] = "start";
            Intrinsics.checkNotNullExpressionValue((Object)GeneralCommandLine.inescapableQuote((String)""), (String)"inescapableQuote(...)");
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = OS.CURRENT == OS.macOS ? CollectionsKt.listOf((Object)ExecUtil.getOpenCommandPath()) : (PathEnvironmentVariableUtil.isOnPath((String)"xdg-open") ? CollectionsKt.listOf((Object)"xdg-open") : null);
        }
        return list;
    }

    private final CoroutineScope getScope(Project project) {
        Project project2 = project;
        ComponentManager componentManager = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        ComponentManagerEx componentManagerEx = componentManager instanceof ComponentManagerEx ? (ComponentManagerEx)componentManager : null;
        if (componentManagerEx == null || (componentManagerEx = componentManagerEx.getCoroutineScope()) == null) {
            componentManagerEx = CoroutineScopeKt.MainScope();
        }
        return CoroutineScopeKt.plus((CoroutineScope)componentManagerEx, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    private static final Unit browse$lambda$2(BrowserLauncherAppless this$0, URI $uri, Project $project) {
        this$0.browse($uri, null, $project);
        return Unit.INSTANCE;
    }

    private static final Unit openWithDefaultBrowserCommand$lambda$0(BrowserLauncherAppless this$0, String $url, Project $project) {
        this$0.browse($url, null, $project);
        return Unit.INSTANCE;
    }

    private static final Unit openWithBrowser$lambda$0(BrowserLauncherAppless this$0, String $url, WebBrowser $browser, Project $project) {
        this$0.openWithBrowser($url, $browser, $project);
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final boolean canUseSystemDefaultBrowserPolicy() {
        return Companion.canUseSystemDefaultBrowserPolicy();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$openWithDefaultBrowserCommand(BrowserLauncherAppless $this, String url, Project project) {
        $this.openWithDefaultBrowserCommand(url, project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BrowserLauncherAppless.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherAppless$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "canUseSystemDefaultBrowserPolicy", "", "isDesktopActionSupported", "action", "Ljava/awt/Desktop$Action;", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean canUseSystemDefaultBrowserPolicy() {
            return this.isDesktopActionSupported(Desktop.Action.BROWSE) || OS.CURRENT == OS.Windows || OS.CURRENT == OS.macOS || PathEnvironmentVariableUtil.isOnPath((String)"xdg-open");
        }

        private final boolean isDesktopActionSupported(Desktop.Action action) {
            return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(action);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

