/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.configuration;

import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.SharedFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessLogging;", "", "<init>", "()V", "logMessage", "", "message", "", "logWarning", "exception", "", "logFatalError", "loggingFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$LogEntry;", "SeverityKind", "Message", "LogEntry", "HeadlessLoggingService", "intellij.platform.ide"})
public final class HeadlessLogging {
    @NotNull
    public static final HeadlessLogging INSTANCE = new HeadlessLogging();

    private HeadlessLogging() {
    }

    public final void logMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        HeadlessLoggingService.Companion.getInstance().logEntry(new LogEntry(SeverityKind.Info, Message.Plain.box-impl(Message.Plain.constructor-impl(message))));
    }

    public final void logWarning(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        HeadlessLoggingService.Companion.getInstance().logEntry(new LogEntry(SeverityKind.Warning, Message.Plain.box-impl(Message.Plain.constructor-impl(message))));
    }

    public final void logWarning(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        HeadlessLoggingService.Companion.getInstance().logEntry(new LogEntry(SeverityKind.Warning, Message.Exception.box-impl(Message.Exception.constructor-impl(exception))));
    }

    public final void logFatalError(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        HeadlessLoggingService.Companion.getInstance().logEntry(new LogEntry(SeverityKind.Fatal, Message.Exception.box-impl(Message.Exception.constructor-impl(exception))));
    }

    public final void logFatalError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        HeadlessLoggingService.Companion.getInstance().logEntry(new LogEntry(SeverityKind.Fatal, Message.Plain.box-impl(Message.Plain.constructor-impl(message))));
    }

    @NotNull
    public final SharedFlow<LogEntry> loggingFlow() {
        return HeadlessLoggingService.Companion.getInstance().loggingFlow();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0004H&J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessLogging$HeadlessLoggingService;", "", "logEntry", "", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$LogEntry;", "loggingFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "Companion", "intellij.platform.ide"})
    public static interface HeadlessLoggingService {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public void logEntry(@NotNull LogEntry var1);

        @NotNull
        public SharedFlow<LogEntry> loggingFlow();

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessLogging$HeadlessLoggingService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$HeadlessLoggingService;", "intellij.platform.ide"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final HeadlessLoggingService getInstance() {
                Object object = ApplicationManager.getApplication().getService(HeadlessLoggingService.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
                return (HeadlessLoggingService)object;
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessLogging$LogEntry;", "", "severity", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$SeverityKind;", "message", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message;", "<init>", "(Lcom/intellij/openapi/project/configuration/HeadlessLogging$SeverityKind;Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message;)V", "getSeverity", "()Lcom/intellij/openapi/project/configuration/HeadlessLogging$SeverityKind;", "getMessage", "()Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide"})
    public static final class LogEntry {
        @NotNull
        private final SeverityKind severity;
        @NotNull
        private final Message message;

        public LogEntry(@NotNull SeverityKind severity, @NotNull Message message) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.severity = severity;
            this.message = message;
        }

        @NotNull
        public final SeverityKind getSeverity() {
            return this.severity;
        }

        @NotNull
        public final Message getMessage() {
            return this.message;
        }

        @NotNull
        public final SeverityKind component1() {
            return this.severity;
        }

        @NotNull
        public final Message component2() {
            return this.message;
        }

        @NotNull
        public final LogEntry copy(@NotNull SeverityKind severity, @NotNull Message message) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new LogEntry(severity, message);
        }

        public static /* synthetic */ LogEntry copy$default(LogEntry logEntry, SeverityKind severityKind, Message message, int n, Object object) {
            if ((n & 1) != 0) {
                severityKind = logEntry.severity;
            }
            if ((n & 2) != 0) {
                message = logEntry.message;
            }
            return logEntry.copy(severityKind, message);
        }

        @NotNull
        public String toString() {
            return "LogEntry(severity=" + this.severity + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result2 = this.severity.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LogEntry)) {
                return false;
            }
            LogEntry logEntry = (LogEntry)other;
            if (this.severity != logEntry.severity) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)logEntry.message);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0004\u0005J\b\u0010\u0002\u001a\u00020\u0003H&\u0082\u0001\u0002\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message;", "", "representation", "", "Plain", "Exception", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message$Exception;", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message$Plain;", "intellij.platform.ide"})
    public static sealed interface Message {
        @NotNull
        public String representation();

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @JvmInline
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087@\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0083\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0011\u0010\u0016\u001a\u00020\tH\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0088\u0001\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message$Exception;", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message;", "exception", "", "constructor-impl", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "getException", "()Ljava/lang/Throwable;", "representation", "", "representation-impl", "(Ljava/lang/Throwable;)Ljava/lang/String;", "equals", "", "other", "", "equals-impl", "(Ljava/lang/Throwable;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/lang/Throwable;)I", "toString", "toString-impl", "intellij.platform.ide"})
        public static final class Exception
        implements Message {
            @NotNull
            private final Throwable exception;

            @NotNull
            public final Throwable getException() {
                return this.exception;
            }

            @NotNull
            public static String representation-impl(Throwable arg0) {
                return arg0.toString();
            }

            @Override
            @NotNull
            public String representation() {
                return Exception.representation-impl(this.exception);
            }

            public static String toString-impl(Throwable arg0) {
                return "Exception(exception=" + arg0 + ")";
            }

            public String toString() {
                return Exception.toString-impl(this.exception);
            }

            public static int hashCode-impl(Throwable arg0) {
                return arg0.hashCode();
            }

            public int hashCode() {
                return Exception.hashCode-impl(this.exception);
            }

            public static boolean equals-impl(Throwable arg0, Object other) {
                if (!(other instanceof Exception)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)arg0, (Object)((Exception)other).unbox-impl());
            }

            public boolean equals(Object other) {
                return Exception.equals-impl(this.exception, other);
            }

            private /* synthetic */ Exception(Throwable exception) {
                this.exception = exception;
            }

            @NotNull
            public static Throwable constructor-impl(@NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return exception;
            }

            public static final /* synthetic */ Exception box-impl(Throwable v) {
                return new Exception(v);
            }

            public final /* synthetic */ Throwable unbox-impl() {
                return this.exception;
            }

            public static final boolean equals-impl0(Throwable p1, Throwable p2) {
                return Intrinsics.areEqual((Object)p1, (Object)p2);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @JvmInline
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087@\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\u0005J\u001b\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0011\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0088\u0001\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message$Plain;", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$Message;", "message", "", "constructor-impl", "(Ljava/lang/String;)Ljava/lang/String;", "getMessage", "()Ljava/lang/String;", "representation", "representation-impl", "equals", "", "other", "", "equals-impl", "(Ljava/lang/String;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/lang/String;)I", "toString", "toString-impl", "intellij.platform.ide"})
        public static final class Plain
        implements Message {
            @NotNull
            private final String message;

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public static String representation-impl(String arg0) {
                return arg0;
            }

            @Override
            @NotNull
            public String representation() {
                return Plain.representation-impl(this.message);
            }

            public static String toString-impl(String arg0) {
                return "Plain(message=" + arg0 + ")";
            }

            public String toString() {
                return Plain.toString-impl(this.message);
            }

            public static int hashCode-impl(String arg0) {
                return arg0.hashCode();
            }

            public int hashCode() {
                return Plain.hashCode-impl(this.message);
            }

            public static boolean equals-impl(String arg0, Object other) {
                if (!(other instanceof Plain)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)arg0, (Object)((Plain)other).unbox-impl());
            }

            public boolean equals(Object other) {
                return Plain.equals-impl(this.message, other);
            }

            private /* synthetic */ Plain(String message) {
                this.message = message;
            }

            @NotNull
            public static String constructor-impl(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return message;
            }

            public static final /* synthetic */ Plain box-impl(String v) {
                return new Plain(v);
            }

            public final /* synthetic */ String unbox-impl() {
                return this.message;
            }

            public static final boolean equals-impl0(String p1, String p2) {
                return Intrinsics.areEqual((Object)p1, (Object)p2);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessLogging$SeverityKind;", "", "<init>", "(Ljava/lang/String;I)V", "Info", "Warning", "Fatal", "intellij.platform.ide"})
    public static final class SeverityKind
    extends Enum<SeverityKind> {
        public static final /* enum */ SeverityKind Info = new SeverityKind();
        public static final /* enum */ SeverityKind Warning = new SeverityKind();
        public static final /* enum */ SeverityKind Fatal = new SeverityKind();
        private static final /* synthetic */ SeverityKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SeverityKind[] values() {
            return (SeverityKind[])$VALUES.clone();
        }

        public static SeverityKind valueOf(String value2) {
            return Enum.valueOf(SeverityKind.class, value2);
        }

        @NotNull
        public static EnumEntries<SeverityKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = severityKindArray = new SeverityKind[]{SeverityKind.Info, SeverityKind.Warning, SeverityKind.Fatal};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

